/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.vcenter.listener;

import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.cdc.internal.vcenter.client.transport.ChangeLogCollectorProxy;
import com.vmware.cdc.internal.vcenter.listener.ChangeNotifierImpl;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.cdc.vcenter.listener.vapi.VapiServiceStubFactory;
import com.vmware.cdc.vcenter.listener.vmomi.VmomiServiceStubFactory;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangeNotifierFactory
implements AutoCloseable {
    private static final Logger _logger = LoggerFactory.getLogger(ChangeNotifierFactory.class);
    public static final String CHANGE_LOG_PROVIDER_ENDPOINT_TYPE = "com.vmware.cdc.provider";
    private static final int DEFAULT_MAX_POLLING_THREAD_POOL_SIZE = Short.MAX_VALUE;
    private static final long DEFAULT_CHANGE_LOG_POLLING_INTERVAL_MS = 1000L;
    private final ExecutorService _pollingExecutor = new PollingThreadPool(Short.MAX_VALUE);

    public ChangeNotifier forVmomiProvider(VmomiServiceStubFactory vmomiServiceStubFactory) {
        Validate.notNull((Object)vmomiServiceStubFactory);
        ChangeLogCollector changeLogCollector = ChangeLogCollectorProxy.forVmomiProvider(vmomiServiceStubFactory);
        ChangeNotifierImpl.ChangeLogCollectorPollerFactory changeLogCollectorPollerFactory = new ChangeNotifierImpl.ChangeLogCollectorPollerFactory(vmomiServiceStubFactory.getName(), this._pollingExecutor, 1000L, changeLogCollector);
        return new ChangeNotifierImpl(changeLogCollectorPollerFactory);
    }

    @Deprecated
    public ChangeNotifier forVmomiProvider(final Client vlsiClient) {
        Validate.notNull((Object)vlsiClient);
        return this.forVmomiProvider(new VmomiServiceStubFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T extends ManagedObject> T createServiceStub(Class<T> serviceClass, ManagedObjectReference moRef) {
                ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    ManagedObject managedObject = vlsiClient.createStub(serviceClass, moRef);
                    return (T)managedObject;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalLoader);
                }
            }

            @Override
            public String getName() {
                return vlsiClient.getBinding().getEndpointUri().toString();
            }
        });
    }

    public ChangeNotifier forVapiProvider(VapiServiceStubFactory vapiServiceStubFactory) {
        Validate.notNull((Object)vapiServiceStubFactory);
        ChangeLogCollector changeLogCollector = ChangeLogCollectorProxy.forVapiProvider(vapiServiceStubFactory);
        ChangeNotifierImpl.ChangeLogCollectorPollerFactory changeLogCollectorPollerFactory = new ChangeNotifierImpl.ChangeLogCollectorPollerFactory(vapiServiceStubFactory.getName(), this._pollingExecutor, 1000L, changeLogCollector);
        return new ChangeNotifierImpl(changeLogCollectorPollerFactory);
    }

    @Override
    public void close() {
        this._pollingExecutor.shutdownNow();
    }

    private static final class PollingThreadFactory
    implements ThreadFactory {
        private final AtomicInteger _index = new AtomicInteger();

        private PollingThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = "change-log-polling-" + this._index.incrementAndGet();
            return new Thread(r, name);
        }
    }

    private static final class PollingThreadPool
    extends ThreadPoolExecutor {
        public PollingThreadPool(int maxSize) {
            super(0, maxSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new PollingThreadFactory());
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                _logger.error("Polling task {} finished with error: {}: {}", new Object[]{r, t.getClass(), t.getMessage(), t});
            }
        }
    }
}

