/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.vcenter.listener;

import com.vmware.cdc.internal.vcenter.listener.ChangeNotifierImpl;
import com.vmware.cdc.internal.vcenter.listener.ListenerSpec;
import com.vmware.cdc.vcenter.listener.AlarmChangeListener;
import com.vmware.cdc.vcenter.listener.ResourceChangeListener;
import org.apache.commons.lang.Validate;

public final class ListenerSpecBuilder {
    private final ChangeNotifierImpl _changeNotifier;
    private ResourceChangeListener _resourceListenerToAdd;
    private ResourceChangeListener _resourceListenerToRemove;
    private AlarmChangeListener _alarmListenerToAdd;
    private AlarmChangeListener _alarmListenerToRemove;

    public ListenerSpecBuilder(ChangeNotifierImpl changeNotifier) {
        this._changeNotifier = changeNotifier;
    }

    public ListenerSpecBuilder add(ResourceChangeListener resourceChangeListener) {
        Validate.notNull((Object)resourceChangeListener);
        if (this._resourceListenerToAdd != null) {
            throw new IllegalArgumentException("Only one ResourceChangeListener allowed to be added.");
        }
        if (this._resourceListenerToRemove != null) {
            throw new IllegalArgumentException("Not possible to both add and remove a ResourceChangeListener.");
        }
        this._resourceListenerToAdd = resourceChangeListener;
        return this;
    }

    public ListenerSpecBuilder remove(ResourceChangeListener resourceChangeListener) {
        Validate.notNull((Object)resourceChangeListener);
        if (this._resourceListenerToRemove != null) {
            throw new IllegalArgumentException("Only one ResourceChangeListener allowed to be removed.");
        }
        if (this._resourceListenerToAdd != null) {
            throw new IllegalArgumentException("Not possible to both add and remove a ResourceChangeListener.");
        }
        this._resourceListenerToRemove = resourceChangeListener;
        return this;
    }

    public ListenerSpecBuilder add(AlarmChangeListener alarmChangeListener) {
        Validate.notNull((Object)alarmChangeListener);
        if (this._alarmListenerToAdd != null) {
            throw new IllegalArgumentException("Only one AlarmChangeListener allowed to be added.");
        }
        if (this._alarmListenerToRemove != null) {
            throw new IllegalArgumentException("Not possible to both add and remove an AlarmChangeListener.");
        }
        this._alarmListenerToAdd = alarmChangeListener;
        return this;
    }

    public ListenerSpecBuilder remove(AlarmChangeListener alarmChangeListener) {
        Validate.notNull((Object)alarmChangeListener);
        if (this._alarmListenerToRemove != null) {
            throw new IllegalArgumentException("Only one AlarmChangeListener allowed to be removed.");
        }
        if (this._alarmListenerToAdd != null) {
            throw new IllegalArgumentException("Not possible to both add and remove an AlarmChangeListener.");
        }
        this._alarmListenerToRemove = alarmChangeListener;
        return this;
    }

    public void commit() {
        ListenerSpec spec = this.build();
        this._changeNotifier.commit(spec);
    }

    private ListenerSpec build() {
        if (this._resourceListenerToAdd == null && this._resourceListenerToRemove == null && this._alarmListenerToAdd == null && this._alarmListenerToRemove == null) {
            throw new IllegalArgumentException("Cannot submit an empty list of listeners.");
        }
        return new ListenerSpec(this._resourceListenerToAdd, this._resourceListenerToRemove, this._alarmListenerToAdd, this._alarmListenerToRemove);
    }
}

