/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cimmonitor.util;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.HealthStatusSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.cimmonitor.http.HttpCimException;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import java.util.HashMap;
import java.util.Map;

public class CimMonitorUtil {
    private static final String RESOURCE_BUNDLE_NAME = "CimMonitorService";
    private static final Map<HttpCimException.Id, String> _errorIdMap = new HashMap<HttpCimException.Id, String>();

    public static Exception getLocalizedException(HttpCimException exception) {
        HttpCimException.Id errorId = exception.getId();
        if (errorId == null) {
            return MixedUtil.getMethodFault((Throwable)new Exception(exception.getMessage()));
        }
        String key = _errorIdMap.containsKey(errorId) ? _errorIdMap.get(errorId) : "unknownError";
        return MixedUtil.getMethodFault((Throwable)new Exception(CimMonitorUtil.getLocalizedString(key)));
    }

    public static Exception getLocalizedException(String key) {
        return MixedUtil.getMethodFault((Throwable)new Exception(CimMonitorUtil.getLocalizedString(key)));
    }

    public static Exception getLocalizedException(String key, Exception cause) {
        return MixedUtil.getMethodFault((Throwable)new Exception(CimMonitorUtil.getLocalizedString(key), cause));
    }

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)CimMonitorUtil.class.getClassLoader());
    }

    public static HealthStatusSystem getHealthStatusSystem(ManagedObjectReference hostRef) throws Exception {
        HostSystem hs = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        ConfigManager cmgr = hs.getConfigManager();
        ManagedObjectReference hssRef = cmgr.getHealthStatusSystem();
        HealthStatusSystem hss = (HealthStatusSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hssRef);
        return hss;
    }

    static {
        _errorIdMap.put(HttpCimException.Id.SERVICE_NOT_FOUND, "contactCIMOMFailed");
        _errorIdMap.put(HttpCimException.Id.INVOCATION_EXCEPTION, "acquireCIMTicketFailed");
        _errorIdMap.put(HttpCimException.Id.INSUFFICIENT_PRIVILEGE, "insufficientPrivilege");
        _errorIdMap.put(HttpCimException.Id.INVALID_PARAMETER, "invalidParameter");
        _errorIdMap.put(HttpCimException.Id.UNKNOWN_ERROR, "unknownError");
        _errorIdMap.put(HttpCimException.Id.HOST_IN_MAINTENANCE_MODE, "hostInMaintenanceMode");
        _errorIdMap.put(HttpCimException.Id.HOST_NOT_CONNECTED, "hostNotConnected");
        _errorIdMap.put(HttpCimException.Id.HOST_NOT_POWERED_ON, "hostNotPoweredOn");
        _errorIdMap.put(HttpCimException.Id.VERSION2_VIM_API_NOT_SUPPORTED, "version2VimApiNotSupported");
        _errorIdMap.put(HttpCimException.Id.IPMI_NOT_SUPPORTED, "ipmiNotSupported");
    }
}

