/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryUtil {
    private static final Log _logger = LogFactory.getLog(QueryUtil.class);
    public static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    public static final QuerySpec[] EMPTY_QUERY_SPEC_ARRAY = new QuerySpec[0];
    public static final ResultSet[] EMPTYSET = new ResultSet[0];
    public static final ResultItem[] EMPTY_RESULT_ITEM_ARRAY = new ResultItem[0];
    public static final PropertyValue[] EMPTY_PROPERTY_VALUE_ARRAY = new PropertyValue[0];
    public static final ResultSet EMPTY_RESULT_SET = new ResultSet();
    public static final FacetInfo[] EMPTY_FACET_INFO_ARRAY = new FacetInfo[0];
    public static final TypeInfo[] EMPTY_TYPE_INFO = new TypeInfo[0];
    private static volatile DataServiceExtensionRegistryInternal _dataAdapterRegistry;

    public static void setDataServiceExtensionRegistry(DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        if (dataServiceExtensionRegistry != null && !(dataServiceExtensionRegistry instanceof DataServiceExtensionRegistryInternal)) {
            throw new IllegalArgumentException("dataAdapterRegistry should be an instance of DataServiceExtensionRegistryInternal");
        }
        _dataAdapterRegistry = (DataServiceExtensionRegistryInternal)dataServiceExtensionRegistry;
    }

    @Deprecated
    public static String getReferenceType(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Invalid argument to lookup reference type.");
        }
        ResourceObjectReferenceAdapter resourceObjectReferenceAdapter = _dataAdapterRegistry.getObjectRefTypeAdapter(object.getClass());
        if (resourceObjectReferenceAdapter == null) {
            return null;
        }
        String string = resourceObjectReferenceAdapter.getResourceType(object);
        return string;
    }

    @Deprecated
    public static String getReferenceServerGuid(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Invalid argument to lookup reference serverGuid.");
        }
        ResourceObjectReferenceAdapter resourceObjectReferenceAdapter = _dataAdapterRegistry.getObjectRefTypeAdapter(object.getClass());
        if (resourceObjectReferenceAdapter == null) {
            return null;
        }
        String string = resourceObjectReferenceAdapter.getServerGuid(object);
        return string;
    }

    @Deprecated
    public static String getReferenceUid(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Invalid argument to lookup reference uid.");
        }
        ResourceObjectReferenceAdapter resourceObjectReferenceAdapter = _dataAdapterRegistry.getObjectRefTypeAdapter(object.getClass());
        if (resourceObjectReferenceAdapter == null) {
            return null;
        }
        String string = resourceObjectReferenceAdapter.getUid(object);
        return string;
    }

    @Deprecated
    public static Object getReference(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid argument to lookup reference.");
        }
        ResourceObjectReferenceAdapter resourceObjectReferenceAdapter = _dataAdapterRegistry.getObjectRefTypeAdapter(string);
        if (resourceObjectReferenceAdapter == null) {
            return null;
        }
        Object object = resourceObjectReferenceAdapter.getReference(string);
        return object;
    }

    @Deprecated
    public static <T> T getProperty(DataService dataService, Object object, String string) throws Exception {
        PropertyValue[] propertyValueArray;
        if (object == null || StringUtil.isNullOrEmpty((String)string)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        for (PropertyValue propertyValue : propertyValueArray = QueryUtil.getProperties(dataService, object, new String[]{string})) {
            if (propertyValue == null || propertyValue.propertyName == null || !propertyValue.propertyName.equals(string)) continue;
            return (T)propertyValue.value;
        }
        return null;
    }

    @Deprecated
    public static PropertyValue[] getProperty(DataService dataService, Object[] objectArray, String string) throws Exception {
        return QueryUtil.getProperties(dataService, objectArray, new String[]{string});
    }

    @Deprecated
    public static PropertyValue[] getProperties(DataService dataService, Object object, String[] stringArray) throws Exception {
        return QueryUtil.getProperties(dataService, object, stringArray, null);
    }

    public static PropertyValue[] getProperties(DataService dataService, Object object, String[] stringArray, Map<String, List<ParameterSpec>> map) throws Exception {
        return QueryUtil.getProperties(dataService, new Object[]{object}, stringArray, map);
    }

    @Deprecated
    public static PropertyValue[] getProperties(DataService dataService, Object[] objectArray, String[] stringArray) throws Exception {
        return QueryUtil.getProperties(dataService, objectArray, stringArray, null);
    }

    public static PropertyValue[] getProperties(DataService dataService, Object[] objectArray, String[] stringArray, Map<String, List<ParameterSpec>> map) throws Exception {
        ResultItem[] resultItemArray;
        if (objectArray == null || objectArray.length == 0 || stringArray == null || stringArray.length == 0) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        Object object = objectArray[0];
        QuerySpec querySpec = QueryUtil.buildQuerySpec(objectArray, stringArray, map);
        querySpec.name = QueryUtil.getReferenceUid(object) + ".properties";
        ResultSet resultSet = QueryUtil.getData(dataService, querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0 && resultItemArray[0] != null) {
            for (ResultItem resultItem : resultItemArray) {
                for (PropertyValue propertyValue : resultItem.properties) {
                    propertyValue.resourceObject = resultItem.resourceObject;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(arrayList, PropertyValue.class);
    }

    @Deprecated
    public static PropertyValue[] getPropertyForRelatedObjects(DataService dataService, Object object, String string, String string2, String string3) throws Exception {
        return QueryUtil.getPropertiesForRelatedObjects(dataService, object, string, string2, new String[]{string3});
    }

    @Deprecated
    public static PropertyValue[] getPropertiesForRelatedObjects(DataService dataService, Object object, String string, String string2, String[] stringArray) throws Exception {
        if (object == null || stringArray == null || stringArray.length == 0) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            return QueryUtil.getProperties(dataService, object, stringArray);
        }
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint(string, objectIdentityConstraint, true, string2);
        QuerySpec querySpec = QueryUtil.buildQuerySpec(relationalConstraint, stringArray);
        querySpec.name = QueryUtil.getReferenceUid(object) + "." + string + ".properties";
        ResultSet resultSet = QueryUtil.getData(dataService, querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem == null || resultItem.properties == null) continue;
                for (PropertyValue propertyValue : resultItem.properties) {
                    if (propertyValue == null) continue;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(arrayList, PropertyValue.class);
    }

    @Deprecated
    public static ResultSet getData(DataService dataService, QuerySpec querySpec) throws Exception {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = new Response();
        response = dataService.getData(requestSpec);
        ResultSet[] resultSetArray = response.resultSet;
        if (resultSetArray == null || resultSetArray.length == 0 || resultSetArray[0] == null) {
            throw new Exception(Utils.getLocalizedString("error.emptyResult"));
        }
        return resultSetArray[0];
    }

    @Deprecated
    public static QuerySpec buildQuerySpec(Object object, String[] stringArray) {
        return QueryUtil.buildQuerySpec(object, stringArray, null);
    }

    public static QuerySpec buildQuerySpec(Object object, String[] stringArray, Map<String, List<ParameterSpec>> map) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        String string = QueryUtil.getReferenceType(object);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        QuerySpec querySpec = QueryUtil.buildQuerySpec(objectIdentityConstraint, stringArray, hashSet, map);
        return querySpec;
    }

    @Deprecated
    public static QuerySpec buildQuerySpec(Object[] objectArray, String[] stringArray) {
        return QueryUtil.buildQuerySpec(objectArray, stringArray, null);
    }

    public static QuerySpec buildQuerySpec(Object[] objectArray, String[] stringArray, Map<String, List<ParameterSpec>> map) {
        if (objectArray.length == 1) {
            return QueryUtil.buildQuerySpec(objectArray[0], stringArray, map);
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        Constraint[] constraintArray = new Constraint[objectArray.length];
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = objectArray[i];
            constraintArray[i] = objectIdentityConstraint;
            string = QueryUtil.getReferenceType(objectIdentityConstraint.target);
            hashSet.add(string);
        }
        compositeConstraint.nestedConstraints = constraintArray;
        QuerySpec querySpec = QueryUtil.buildQuerySpec(compositeConstraint, stringArray, hashSet, map);
        return querySpec;
    }

    @Deprecated
    public static QuerySpec buildQuerySpec(Constraint constraint, String[] stringArray) {
        QuerySpec querySpec = QueryUtil.buildQuerySpec(constraint, stringArray, (Set<String>)null);
        return querySpec;
    }

    @Deprecated
    public static QuerySpec buildQuerySpec(Constraint constraint, String[] stringArray, Set<String> set) {
        return QueryUtil.buildQuerySpec(constraint, stringArray, set, null);
    }

    public static QuerySpec buildQuerySpec(Constraint constraint, String[] stringArray, Set<String> set, Map<String, List<ParameterSpec>> map) {
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        if (set != null) {
            for (String string : set) {
                PropertySpec propertySpec = QueryUtil.createPropertySpec(stringArray, string, map);
                arrayList.add(propertySpec);
            }
        } else {
            PropertySpec propertySpec = QueryUtil.createPropertySpec(stringArray, null, map);
            arrayList.add(propertySpec);
        }
        resourceSpec.propertySpecs = arrayList.toArray(new PropertySpec[0]);
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }

    private static PropertySpec createPropertySpec(String[] stringArray, String string, Map<String, List<ParameterSpec>> map) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = string;
        propertySpec.propertyNames = stringArray;
        if (map != null && !map.isEmpty() && !ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            ArrayList arrayList = new ArrayList();
            for (String string2 : stringArray) {
                if (map.get(string2) == null) continue;
                arrayList.addAll(map.get(string2));
            }
            propertySpec.parameters = arrayList.toArray(new ParameterSpec[0]);
        }
        return propertySpec;
    }

    @Deprecated
    public static <T> T findPropertyValueIn(String string, List<ResultItem> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (ResultItem resultItem : list) {
            PropertyValue[] propertyValueArray = resultItem.properties;
            if (propertyValueArray == null || propertyValueArray.length == 0) continue;
            for (PropertyValue propertyValue : propertyValueArray) {
                if (!propertyValue.propertyName.equals(string)) continue;
                return (T)propertyValue.value;
            }
        }
        return null;
    }

    public static boolean validateQueryConstraint(Constraint constraint) {
        if (constraint == null) {
            _logger.warn((Object)"Invalid constraint: constraint is null");
            return false;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            boolean bl;
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            boolean bl2 = bl = objectIdentityConstraint.target != null;
            if (!bl) {
                _logger.warn((Object)"Invalid constraint: constraint target is null");
            }
            return bl;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            if (StringUtil.isNullOrEmpty((String)relationalConstraint.relation)) {
                _logger.warn((Object)"Invalid constraint: relational constraint's relation is null");
                return false;
            }
            return QueryUtil.validateQueryConstraint(relationalConstraint.constraintOnRelatedObject);
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (compositeConstraint.nestedConstraints == null) {
                _logger.warn((Object)"Invalid composite constraint: nested constraints are null");
                return false;
            }
            if (compositeConstraint.nestedConstraints.length == 0) {
                _logger.warn((Object)"Invalid composite constraint: nested constraints are empty");
                return false;
            }
            if (compositeConstraint.conjoiner == null) {
                _logger.warn((Object)"Invalid composite constraint: conjoiner is null");
                return false;
            }
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                if (QueryUtil.validateQueryConstraint(constraint2)) continue;
                return false;
            }
        } else if (constraint instanceof PropertyConstraint) {
            boolean bl;
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            boolean bl3 = bl = propertyConstraint.comparator != null;
            if (!bl) {
                _logger.warn((Object)"Invalid constraint: property constraint comparator is null");
            }
            return bl;
        }
        return true;
    }

    @Deprecated
    public static Boolean waitUntilSearchable(DataService dataService, Object object, String[] stringArray) {
        return QueryUtil.waitUntilStatusChange(dataService, object, stringArray, true);
    }

    @Deprecated
    public static Boolean waitUntilSearchable(DataService dataService, Object object) {
        return QueryUtil.waitUntilSearchable(dataService, object, new String[]{"name"});
    }

    @Deprecated
    public static Boolean waitUntilNotSearchable(DataService dataService, Object object, String[] stringArray) {
        return QueryUtil.waitUntilStatusChange(dataService, object, stringArray, false);
    }

    @Deprecated
    public static Boolean waitUntilNotSearchable(DataService dataService, Object object) {
        return QueryUtil.waitUntilNotSearchable(dataService, object, new String[]{"name"});
    }

    @Deprecated
    private static Boolean waitUntilStatusChange(DataService dataService, Object object, String[] stringArray, boolean bl) {
        PropertyValue[] propertyValueArray = null;
        boolean bl2 = false;
        for (int i = 0; i < 30; ++i) {
            try {
                propertyValueArray = QueryUtil.getProperties(dataService, object, stringArray);
                boolean bl3 = QueryUtil.checkProperties(propertyValueArray, stringArray);
                if (bl && bl3) {
                    bl2 = true;
                    break;
                }
                if (!bl && !bl3) {
                    bl2 = true;
                    break;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
            }
        }
        return bl2;
    }

    @Deprecated
    public static Boolean waitUntilPropertyChanged(DataService dataService, Object object, PropertyChangeInfo propertyChangeInfo) throws Exception {
        String string = propertyChangeInfo.getPropertyName();
        boolean bl = false;
        _logger.debug((Object)("Start waiting for change in property '" + string + "' on object " + QueryUtil.getReferenceUid(object)));
        for (int i = 0; i < 30; ++i) {
            Object t = QueryUtil.getProperty(dataService, object, string);
            bl = propertyChangeInfo.isChanged(t);
            if (bl) {
                _logger.debug((Object)("Property '" + string + "' on object " + QueryUtil.getReferenceUid(object) + " has changed!"));
                break;
            }
            _logger.debug((Object)("No change detected for property '" + string + "' on object " + QueryUtil.getReferenceUid(object)));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
            }
        }
        return bl;
    }

    public static RelationalConstraint createRelationalConstraint(String string, Constraint constraint, Boolean bl, String string2) {
        RelationalConstraint relationalConstraint = new RelationalConstraint();
        relationalConstraint.relation = string;
        relationalConstraint.hasInverseRelation = bl;
        relationalConstraint.constraintOnRelatedObject = constraint;
        relationalConstraint.targetType = string2;
        return relationalConstraint;
    }

    public static Constraint createConstraintForRelationship(Object object, String string, String string2) {
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint(string, objectIdentityConstraint, true, string2);
        return relationalConstraint;
    }

    public static PropertyConstraint createPropertyConstraint(String string, String string2, Comparator comparator, Object object) {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = string;
        propertyConstraint.propertyName = string2;
        propertyConstraint.comparator = comparator;
        propertyConstraint.comparableValue = object;
        return propertyConstraint;
    }

    public static Constraint combineIntoSingleConstraint(Constraint[] constraintArray, Conjoiner conjoiner) {
        if (constraintArray == null || constraintArray.length == 0) {
            return null;
        }
        if (constraintArray.length == 1) {
            return constraintArray[0];
        }
        return QueryUtil.createCompositeConstraint(constraintArray, conjoiner);
    }

    public static Constraint combineIntoSingleConstraint(Object[] objectArray, Conjoiner conjoiner) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        Constraint[] constraintArray = new Constraint[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint(objectArray[i]);
            constraintArray[i] = objectIdentityConstraint;
        }
        if (objectArray.length == 1) {
            return constraintArray[0];
        }
        return QueryUtil.createCompositeConstraint(constraintArray, conjoiner);
    }

    public static CompositeConstraint createCompositeConstraint(Constraint[] constraintArray, Conjoiner conjoiner) {
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.nestedConstraints = constraintArray;
        compositeConstraint.conjoiner = conjoiner;
        return compositeConstraint;
    }

    public static ObjectIdentityConstraint createObjectIdentityConstraint(Object object) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        return objectIdentityConstraint;
    }

    public static ResourceSpec createEmptyResourceSpec() {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[0];
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        return resourceSpec;
    }

    public static Object[] findMoRefsIn(ResultSet resultSet) {
        ResultItem[] resultItemArray;
        Object[] objectArray = null;
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0) {
            objectArray = (Object[])Array.newInstance(resultItemArray[0].resourceObject.getClass(), resultItemArray.length);
            for (int i = 0; i < resultItemArray.length; ++i) {
                objectArray[i] = resultItemArray[i].resourceObject;
            }
        }
        return objectArray;
    }

    private static boolean checkProperties(PropertyValue[] propertyValueArray, String[] stringArray) {
        if (propertyValueArray == null || stringArray == null || propertyValueArray.length < stringArray.length) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertyValue object : propertyValueArray) {
            if (object == null || object.value == null) {
                return false;
            }
            hashSet.add(object.propertyName);
        }
        for (String string : stringArray) {
            if (string == null || hashSet.contains(string)) continue;
            return false;
        }
        return true;
    }

    public static String getLocalizedString(String string) {
        return Utils.getLocalizedString(string);
    }

    public static boolean areEquivalent(QuerySpec querySpec, QuerySpec querySpec2) {
        if (querySpec == querySpec2) {
            return true;
        }
        if (querySpec == null || querySpec2 == null) {
            return false;
        }
        return ObjectUtil.objectsEqual((Object)querySpec.resourceSpec, (Object)querySpec2.resourceSpec) && ObjectUtil.objectsEqual((Object)querySpec.resultSpec, (Object)querySpec2.resultSpec) && ObjectUtil.objectsEqual(querySpec.options, querySpec2.options);
    }

    public static boolean objectExists(Object object, DataService dataService) {
        if (object == null || dataService == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        try {
            QuerySpec querySpec = QueryUtil.buildQuerySpec(object, new String[0]);
            ResultSet resultSet = QueryUtil.getData(dataService, querySpec);
            return resultSet.items.length != 0;
        }
        catch (Exception exception) {
            _logger.error((Object)("isValidObjectRef: Error in querying from data service, object reference = " + object), (Throwable)exception);
            return false;
        }
    }

    static {
        QueryUtil.EMPTY_RESULT_SET.items = EMPTY_RESULT_ITEM_ARRAY;
        QueryUtil.EMPTY_RESULT_SET.facets = EMPTY_FACET_INFO_ARRAY;
        _dataAdapterRegistry = null;
    }

    @Deprecated
    public static class PropertyValueMap {
        public Map<String, PropertyValue> data = new HashMap<String, PropertyValue>();

        public PropertyValueMap() {
        }

        public PropertyValueMap(PropertyValue[] propertyValueArray) {
            this.putProperties(propertyValueArray);
        }

        public void putProperty(PropertyValue propertyValue) {
            String string = QueryUtil.getReferenceUid(propertyValue.resourceObject) + "|" + propertyValue.propertyName;
            this.data.put(string, propertyValue);
        }

        public void putProperties(PropertyValue[] propertyValueArray) {
            for (PropertyValue propertyValue : propertyValueArray) {
                this.putProperty(propertyValue);
            }
        }

        public PropertyValue getProperty(Object object, String string) {
            if (object == null || string == null) {
                return null;
            }
            String string2 = QueryUtil.getReferenceUid(object) + "|" + string;
            PropertyValue propertyValue = this.data.get(string2);
            return propertyValue;
        }
    }

    public static interface PropertyChangeInfo {
        public String getPropertyName();

        public boolean isChanged(Object var1);
    }
}

