/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.NestedModel;
import com.vmware.vise.data.query.commands.Property;
import com.vmware.vise.data.query.commands.Relationship;
import com.vmware.vise.data.query.commands.impl.DataModelMetadata;
import com.vmware.vise.data.query.commands.impl.RelationshipMetadata;
import java.lang.reflect.Field;

public final class FieldMetadata {
    private static final String MULTI_HOP_RELATIONSHIP_REGEX = "[,;]";
    private final Field _field;
    private final DataModelMetadata<?> _nestedModel;
    private final String _propertyName;
    private final RelationshipMetadata[] _relationships;

    public FieldMetadata(Field field) {
        this._field = field;
        String string = FieldMetadata.getPropertyName(field);
        String string2 = FieldMetadata.getRelationships(field);
        Class<?> clazz = FieldMetadata.getNestedModelClass(field);
        String string3 = this._propertyName = string == null ? "" : string.trim();
        if (string2 != null) {
            String[] stringArray = string2.split(MULTI_HOP_RELATIONSHIP_REGEX);
            int n = 0;
            this._relationships = new RelationshipMetadata[stringArray.length];
            for (String string4 : stringArray) {
                this._relationships[n++] = new RelationshipMetadata(string4);
            }
        } else {
            this._relationships = null;
        }
        this._nestedModel = clazz != null ? new DataModelMetadata(clazz) : null;
    }

    public Field getField() {
        return this._field;
    }

    public DataModelMetadata<?> getNestedModel() {
        return this._nestedModel;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public RelationshipMetadata[] getRelationships() {
        return this._relationships;
    }

    private static String getPropertyName(Field field) {
        if (field.isAnnotationPresent(Property.class)) {
            Property property = field.getAnnotation(Property.class);
            return property.name();
        }
        return null;
    }

    private static Class<?> getNestedModelClass(Field field) {
        if (field.isAnnotationPresent(NestedModel.class)) {
            Class<?> clazz = field.getType();
            if (DataModel.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            if (clazz.isArray() && DataModel.class.isAssignableFrom(clazz.getComponentType())) {
                return clazz.getComponentType();
            }
        }
        return null;
    }

    private static String getRelationships(Field field) {
        if (field.isAnnotationPresent(Relationship.class)) {
            Relationship relationship = field.getAnnotation(Relationship.class);
            return relationship.name();
        }
        return null;
    }
}

