/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.impl.DataModelMetadataParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryGenerator<T extends DataModel> {
    public static final String DFC_AUTO_GENERATED = "dfc-auto-generated";
    public static final String RELATIONSHIPS = "relationships";

    protected List<QuerySpec> generateQuerySpecs(DataModelMetadataParser<T> dataModelMetadataParser, ResultSpec resultSpec) {
        ArrayList<QuerySpec> arrayList = new ArrayList<QuerySpec>(2);
        String string = "";
        QuerySpec querySpec = QueryGenerator.createNewQuerySpec(dataModelMetadataParser.getConstraintForRelationship(string), dataModelMetadataParser.getRelationshipProperties(string), dataModelMetadataParser.getDataModelMetadata().getTargetType(), null, dataModelMetadataParser.getParametersForRelationship(string), resultSpec);
        arrayList.add(querySpec);
        dataModelMetadataParser.removeRelationship(string);
        if (dataModelMetadataParser.getRelationshipCount() > 0) {
            QuerySpec querySpec2 = QueryGenerator.createNewQuerySpec(dataModelMetadataParser.getCompositeConstraint(), dataModelMetadataParser.getAllProperties(), null, RELATIONSHIPS, dataModelMetadataParser.getParameters(), null);
            arrayList.add(querySpec2);
        }
        return arrayList;
    }

    private static QuerySpec createNewQuerySpec(Constraint constraint, Object object, String string, String string2, Map<String, Object> map, ResultSpec resultSpec) {
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = DFC_AUTO_GENERATED;
        if (string2 != null) {
            querySpec.name = querySpec.name + "-" + string2;
        }
        querySpec.resourceSpec = QueryGenerator.createNewResourceSpec(constraint, object, string, map);
        querySpec.resultSpec = resultSpec == null ? QueryGenerator.createDefaultResultSpec() : resultSpec;
        return querySpec;
    }

    private static ResultSpec createDefaultResultSpec() {
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = -1;
        return resultSpec;
    }

    private static ResourceSpec createNewResourceSpec(Constraint constraint, Object object, String string, Map<String, Object> map) {
        Object object2;
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        if (object instanceof Map) {
            object2 = (Map)object;
            for (String string2 : object2.keySet()) {
                Set set = (Set)object2.get(string2);
                PropertySpec propertySpec = QueryGenerator.createPropertySpec(string2, set.toArray(new String[0]), map);
                arrayList.add(propertySpec);
            }
        } else if (object instanceof Set) {
            object2 = (Set)object;
            PropertySpec propertySpec = QueryGenerator.createPropertySpec(string, object2.toArray(new String[0]), map);
            arrayList.add(propertySpec);
        }
        object2 = new ResourceSpec();
        ((ResourceSpec)object2).constraint = constraint;
        ((ResourceSpec)object2).propertySpecs = arrayList.toArray(new PropertySpec[0]);
        return object2;
    }

    private static PropertySpec createPropertySpec(String string, String[] stringArray, Map<String, Object> map) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.relation = "";
        propertySpec.propertyNames = stringArray;
        String string2 = propertySpec.type = string == "" ? null : string;
        if (map != null) {
            ArrayList<ParameterSpec> arrayList = new ArrayList<ParameterSpec>();
            for (String string3 : stringArray) {
                if (!map.containsKey(string3)) continue;
                ParameterSpec parameterSpec = new ParameterSpec();
                parameterSpec.propertyName = string3;
                parameterSpec.parameter = map.get(string3);
                arrayList.add(parameterSpec);
            }
            propertySpec.parameters = arrayList.toArray(new ParameterSpec[0]);
        }
        return propertySpec;
    }
}

