/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.ComponentProperties;
import com.vmware.vise.data.query.ComputedPropertyInfo;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.PropertyProviderInfo;
import com.vmware.vise.data.query.impl.ServicePropertyProviderAdapter;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.IdentityHashSet;
import com.vmware.vise.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ComponentPropertyRetriever {
    private static final Set<String> EMPTY_PROPERTIES = new HashSet<String>(0);
    private final DataServiceExtensionRegistryInternal _dataAdapterRegistry;

    public ComponentPropertyRetriever(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal) {
        this._dataAdapterRegistry = dataServiceExtensionRegistryInternal;
    }

    public Set<String> getComponentProperties(String string, Set<String> set) {
        Object object;
        if (set == null) {
            return EMPTY_PROPERTIES;
        }
        if (StringUtil.isNullOrEmpty((String)string) || set.isEmpty()) {
            return set;
        }
        Collection<PropertyProviderInfo> collection = this._dataAdapterRegistry.getPropertyProviders(string, set);
        if (collection.isEmpty()) {
            return set;
        }
        IdentityHashSet identityHashSet = new IdentityHashSet();
        IdentityHashSet identityHashSet2 = new IdentityHashSet();
        for (PropertyProviderInfo object22 : collection) {
            if (object22.propertyProvider instanceof ServicePropertyProviderAdapter) {
                object = (ServicePropertyProviderAdapter)object22.propertyProvider;
                identityHashSet2.add(((ServicePropertyProviderAdapter)object).getPropertyProvider());
                continue;
            }
            identityHashSet.add(object22.propertyProvider);
        }
        HashMap hashMap = new HashMap();
        Map<String, Set<String>> map = ComponentPropertyRetriever.getComponentPropertiesFromPropertyBeans(set, (Set<PropertyProviderBean>)identityHashSet2);
        hashMap.putAll(map);
        object = this.getComponentPropertiesFromPropertyAdapters(set, (Set<PropertyProviderAdapter>)identityHashSet);
        hashMap.putAll(object);
        if (hashMap.isEmpty()) {
            return set;
        }
        Set<String> set2 = this.mergeComponentProperties(set, hashMap);
        return this.getComponentProperties(string, set2);
    }

    private static Map<String, Set<String>> getComponentPropertiesFromPropertyBeans(Set<String> set, Set<PropertyProviderBean> set2) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>(set.size());
        for (PropertyProviderBean propertyProviderBean : set2) {
            Method[] methodArray;
            for (Method method : methodArray = propertyProviderBean.getClass().getMethods()) {
                ComponentProperties componentProperties;
                String string = Utils.getPropertyName(method);
                if (StringUtil.isNullOrEmpty((String)string) || !set.contains(string) || (componentProperties = method.getAnnotation(ComponentProperties.class)) == null) continue;
                HashSet<String> hashSet = new HashSet<String>(componentProperties.value().length);
                for (String string2 : componentProperties.value()) {
                    hashSet.add(string2);
                }
                hashMap.put(string, hashSet);
            }
        }
        return hashMap;
    }

    private Map<String, Set<String>> getComponentPropertiesFromPropertyAdapters(Set<String> set, Set<PropertyProviderAdapter> set2) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>(set.size());
        if (set2 == null || set2.isEmpty()) {
            return hashMap;
        }
        for (PropertyProviderAdapter propertyProviderAdapter : set2) {
            TypeInfo[] typeInfoArray = this._dataAdapterRegistry.getProvidedTypeInfos(propertyProviderAdapter);
            if (typeInfoArray == null || typeInfoArray.length == 0) continue;
            for (TypeInfo typeInfo : typeInfoArray) {
                if (typeInfo.computedProperties == null) continue;
                for (ComputedPropertyInfo computedPropertyInfo : typeInfo.computedProperties) {
                    if (!set.contains(computedPropertyInfo.propertyName)) continue;
                    HashSet<String> hashSet = new HashSet<String>(computedPropertyInfo.componentProperties.length);
                    for (String string : computedPropertyInfo.componentProperties) {
                        hashSet.add(string);
                    }
                    hashMap.put(computedPropertyInfo.propertyName, hashSet);
                }
            }
        }
        return hashMap;
    }

    private Set<String> mergeComponentProperties(Set<String> set, Map<String, Set<String>> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            Set<String> set2 = map.get(string);
            if (set2 == null) {
                hashSet.add(string);
                continue;
            }
            hashSet.addAll(set2);
        }
        return hashSet;
    }
}

