/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataServiceException;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyDataInternal;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.DataAdapterExecutionDetails;
import com.vmware.vise.data.query.impl.DataAdapterInfo;
import com.vmware.vise.data.query.impl.DataAdapterRetriever;
import com.vmware.vise.data.query.impl.DataAdapterUtil;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.DerivedPropertyManager;
import com.vmware.vise.data.query.impl.DerivedPropertyProviderExecutionDetails;
import com.vmware.vise.data.query.impl.ProfiledTaskExecutor;
import com.vmware.vise.data.query.impl.PropertyProviderExecutionDetails;
import com.vmware.vise.data.query.impl.PropertyProviderInfo;
import com.vmware.vise.data.query.impl.PropertyProvidersExecutionResult;
import com.vmware.vise.data.query.impl.ResultDirectory;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.ResultsManager;
import com.vmware.vise.data.query.impl.ResultsMerger;
import com.vmware.vise.data.query.impl.SubTypeResolver;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.ViseDsLogConfigurator;
import com.vmware.vise.data.query.transform.DataTransformer;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.data.query.transform.impl.DataTransformerImpl;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.metadata.ObjectModelProviderRegistryInternal;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.Predicate;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataManager {
    private static final Logger _logger = LoggerFactory.getLogger(DataManager.class);
    private final DataServiceExtensionRegistryInternal _dataAdapterRegistry;
    private final MetadataServiceRegistryInternal _metadataRegistry;
    private final ResultsMerger _resultsMerger;
    private final DataTransformer _dataTransformer;
    private final DerivedPropertyManager _derivedPropertyManager;
    private final ProfiledTaskExecutor _taskExecutor;
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    private static final PropertySpec[] EMPTY_PROP_SPECS = new PropertySpec[0];
    private static final ParameterSpec[] EMPTY_PARAMETER_SPECS = new ParameterSpec[0];
    private static final QuerySpec[] EMPTY_QUERY_SPECS = new QuerySpec[0];
    private static final String DATA_MANAGER_PREFIX = "dataManager.";
    private static final String TRANSFORM_QUERY_SPECS_TIME_LABEL = "dataManager.transformQuerySpecs";
    private static final String DATA_RETRIEVE_TIME_LABEL = "dataManager.retrieveData";
    private static final String ORDERING_PROPERTY_TIME_LABEL = "dataManager.orderingProperties";
    private static final String PAGE_SORT_TIME_LABEL = "dataManager.pageSort";
    private static final String REMAINING_PROPERTY_TIME_LABEL = "dataManager.remainingProperties";

    DataManager(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal, MetadataServiceRegistryInternal metadataServiceRegistryInternal, ObjectModelProviderRegistryInternal objectModelProviderRegistryInternal, ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, SubTypeResolver subTypeResolver, long l) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataServiceExtensionRegistryInternal, metadataServiceRegistryInternal, querySpecBuilder});
        this._metadataRegistry = metadataServiceRegistryInternal;
        this._resultsMerger = new ResultsMerger(metadataServiceRegistryInternal, objectReferenceService);
        this._dataAdapterRegistry = dataServiceExtensionRegistryInternal;
        this._dataTransformer = new DataTransformerImpl(dataServiceExtensionRegistryInternal, metadataServiceRegistryInternal, objectModelProviderRegistryInternal);
        this._derivedPropertyManager = new DerivedPropertyManager(dataServiceExtensionRegistryInternal, querySpecBuilder, objectReferenceService, subTypeResolver);
        this._taskExecutor = new ProfiledTaskExecutor(l);
    }

    DataAdaptersExecutionResult getResultsFromDataAdapters(QuerySpec[] querySpecArray, ExecutionProfiler executionProfiler) throws InterruptedException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{querySpecArray});
        Object object = null;
        object = executionProfiler.startTimer(TRANSFORM_QUERY_SPECS_TIME_LABEL);
        Map<QuerySpec, QuerySpec> map = this.transformQueries(querySpecArray);
        executionProfiler.stopTimer(object);
        object = executionProfiler.startTimer(DATA_RETRIEVE_TIME_LABEL);
        DataAdapterRetriever dataAdapterRetriever = new DataAdapterRetriever(this._dataAdapterRegistry, this._taskExecutor);
        if (map.size() > 0) {
            dataAdapterRetriever.addQuerySpecs(map.keySet());
        }
        DataAdapterRetriever.AdapterInvocationResults adapterInvocationResults = dataAdapterRetriever.getResultsFromDataAdapters();
        Map<QuerySpec, List<ResultSetInfo>> map2 = this.remapResultsForTransformedByInputQuery(adapterInvocationResults.adapterResultsByQuery, map);
        if (map2 != null && map2.size() > 0) {
            adapterInvocationResults.adapterResultsByQuery = map2;
        }
        executionProfiler.stopTimer(object);
        Map<QuerySpec, Set<Object>> map3 = this.markDynamicAdapterObjects(adapterInvocationResults.adapterResultsByQuery);
        Map<QuerySpec, ResultSetInfo> map4 = this._resultsMerger.mergeResultsPerQuery(adapterInvocationResults.adapterResultsByQuery);
        DataAdaptersExecutionResult dataAdaptersExecutionResult = new DataAdaptersExecutionResult(map4, adapterInvocationResults.executionDetails, map3);
        return dataAdaptersExecutionResult;
    }

    DataAdaptersExecutionResult remapAndCollectResultsForEnrichedQueries(DataAdaptersExecutionResult dataAdaptersExecutionResult, Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> map) {
        Object object;
        if (map == null || map.isEmpty()) {
            return dataAdaptersExecutionResult;
        }
        HashMap<QuerySpec, QuerySpec> hashMap = new HashMap<QuerySpec, QuerySpec>();
        HashMap<QuerySpec, DerivedPropertyDataInternal> hashMap2 = new HashMap<QuerySpec, DerivedPropertyDataInternal>();
        for (QuerySpec object22 : map.keySet()) {
            object = map.get(object22);
            if (object != null && object.first != null) {
                hashMap.put(object22, (QuerySpec)object.first);
            } else {
                hashMap.put(object22, object22);
            }
            hashMap2.put(object22, (DerivedPropertyDataInternal)object.second);
        }
        this._derivedPropertyManager.collectDerivedPropertyData(dataAdaptersExecutionResult.getResultsPerQuery(), hashMap2);
        Map<QuerySpec, ResultSetInfo> map2 = this.remapEnrichedQueryResults(dataAdaptersExecutionResult.getResultsPerQuery(), hashMap);
        List<DataAdapterExecutionDetails> list = this.remapEnrichedAdapterExecDetails(dataAdaptersExecutionResult.getAdaptersExecutionDetails(), hashMap);
        object = new DataAdaptersExecutionResult(map2, list, dataAdaptersExecutionResult.getDynamicAdapterObjectsPerQuerySpec());
        return object;
    }

    private Map<QuerySpec, List<ResultSetInfo>> remapResultsForTransformedByInputQuery(Map<QuerySpec, List<ResultSetInfo>> map, Map<QuerySpec, QuerySpec> map2) {
        if (map == null || map.size() == 0) {
            return new IdentityHashMap<QuerySpec, List<ResultSetInfo>>();
        }
        if (map2 == null || map2.size() == 0) {
            return map;
        }
        IdentityHashMap<QuerySpec, List<ResultSetInfo>> identityHashMap = new IdentityHashMap<QuerySpec, List<ResultSetInfo>>();
        for (QuerySpec querySpec : map.keySet()) {
            QuerySpec querySpec2 = map2.get(querySpec);
            if (querySpec2 != null) {
                List<ResultSetInfo> list = map.get(querySpec);
                ArrayList<ResultSetInfo> arrayList = (ArrayList<ResultSetInfo>)identityHashMap.get(querySpec2);
                if (arrayList == null) {
                    arrayList = new ArrayList<ResultSetInfo>();
                    identityHashMap.put(querySpec2, arrayList);
                }
                arrayList.addAll(list);
                continue;
            }
            identityHashMap.put(querySpec, map.get(querySpec));
        }
        return identityHashMap;
    }

    private Map<QuerySpec, QuerySpec> transformQueries(QuerySpec[] querySpecArray) {
        HashMap<QuerySpec, QuerySpec> hashMap = new HashMap<QuerySpec, QuerySpec>();
        Map<QuerySpec, Transformer.Result<QuerySpec>> map = this._dataTransformer.transformQueries(new ArrayList<QuerySpec>(Arrays.asList(querySpecArray)));
        for (QuerySpec querySpec : map.keySet()) {
            Transformer.Result<QuerySpec> result = map.get(querySpec);
            if (result.isTransformed()) {
                QuerySpec querySpec2 = result.getData();
                hashMap.put(querySpec2, querySpec);
                continue;
            }
            hashMap.put(querySpec, querySpec);
        }
        return hashMap;
    }

    Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> enrichQueriesForDerivedProperties(QuerySpec[] querySpecArray) {
        return this._derivedPropertyManager.replaceDerivedWithSourcePropsInQueries(querySpecArray);
    }

    private Map<QuerySpec, ResultSetInfo> remapEnrichedQueryResults(Map<QuerySpec, ResultSetInfo> map, Map<QuerySpec, QuerySpec> map2) {
        if (map == null || map.isEmpty()) {
            return new IdentityHashMap<QuerySpec, ResultSetInfo>();
        }
        IdentityHashMap<QuerySpec, ResultSetInfo> identityHashMap = new IdentityHashMap<QuerySpec, ResultSetInfo>();
        for (QuerySpec querySpec : map.keySet()) {
            QuerySpec querySpec2 = map2.get(querySpec);
            ResultSetInfo resultSetInfo = map.get(querySpec);
            if (querySpec2 != null && !querySpec2.equals(querySpec)) {
                ResultSetInfo resultSetInfo2 = this._resultsMerger.mergeResults(querySpec2, new ArrayList<ResultSetInfo>(Arrays.asList(resultSetInfo)));
                identityHashMap.put(querySpec2, resultSetInfo2);
                continue;
            }
            identityHashMap.put(querySpec, resultSetInfo);
        }
        return identityHashMap;
    }

    private List<DataAdapterExecutionDetails> remapEnrichedAdapterExecDetails(List<DataAdapterExecutionDetails> list, Map<QuerySpec, QuerySpec> map) {
        if (ArrayUtil.isNullOrEmpty(list)) {
            return new ArrayList<DataAdapterExecutionDetails>();
        }
        ArrayList<DataAdapterExecutionDetails> arrayList = new ArrayList<DataAdapterExecutionDetails>();
        for (DataAdapterExecutionDetails dataAdapterExecutionDetails : list) {
            QuerySpec[] querySpecArray = dataAdapterExecutionDetails.getQuerySpecs();
            ArrayList<QuerySpec> arrayList2 = new ArrayList<QuerySpec>();
            boolean bl = false;
            for (QuerySpec querySpec : querySpecArray) {
                QuerySpec querySpec2 = map.get(querySpec);
                if (querySpec2 != null && !querySpec2.equals(querySpec)) {
                    arrayList2.add(querySpec2);
                    bl = true;
                    continue;
                }
                arrayList2.add(querySpec);
            }
            if (bl) {
                DataAdapterExecutionDetails dataAdapterExecutionDetails2 = new DataAdapterExecutionDetails(dataAdapterExecutionDetails.getDataAdapterInfo(), dataAdapterExecutionDetails.getInvocationId(), dataAdapterExecutionDetails.getElapsedTime(), arrayList2.toArray(new QuerySpec[arrayList2.size()]));
                arrayList.add(dataAdapterExecutionDetails2);
                continue;
            }
            arrayList.add(dataAdapterExecutionDetails);
        }
        return arrayList;
    }

    private Map<QuerySpec, Set<Object>> markDynamicAdapterObjects(Map<QuerySpec, List<ResultSetInfo>> map) {
        assert (map != null);
        HashMap<QuerySpec, Set<Object>> hashMap = new HashMap<QuerySpec, Set<Object>>();
        for (Map.Entry<QuerySpec, List<ResultSetInfo>> entry : map.entrySet()) {
            HashSet<Object> hashSet = new HashSet<Object>();
            for (ResultSetInfo resultSetInfo : entry.getValue()) {
                ResultSet resultSet = resultSetInfo.getResultSet();
                if (resultSet == null || resultSet.items == null || !(resultSet instanceof DynamicProviderResultSet)) continue;
                DynamicProviderResultSet dynamicProviderResultSet = (DynamicProviderResultSet)resultSet;
                if (dynamicProviderResultSet.allowFallbackRequest) continue;
                for (ResultItem resultItem : resultSet.items) {
                    hashSet.add(resultItem.resourceObject);
                }
            }
            QuerySpec querySpec = entry.getKey();
            hashMap.put(querySpec, hashSet);
        }
        return hashMap;
    }

    List<PropertyProvidersExecutionResult> getResultsFromPropertyProviders(DataAdaptersExecutionResult dataAdaptersExecutionResult, ExecutionProfiler executionProfiler) throws InterruptedException {
        return this.getResultsFromPropertyProviders(dataAdaptersExecutionResult, false, executionProfiler, null);
    }

    List<PropertyProvidersExecutionResult> getResultsFromDerivedPropertyProviders(DataAdaptersExecutionResult dataAdaptersExecutionResult, ExecutionProfiler executionProfiler, Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> map) throws InterruptedException {
        HashMap<QuerySpec, DerivedPropertyDataInternal> hashMap = new HashMap<QuerySpec, DerivedPropertyDataInternal>();
        if (map != null && !map.isEmpty()) {
            for (QuerySpec querySpec : map.keySet()) {
                Pair<QuerySpec, DerivedPropertyDataInternal> pair = map.get(querySpec);
                if (pair != null && pair.first != null) {
                    hashMap.put((QuerySpec)pair.first, (DerivedPropertyDataInternal)pair.second);
                    continue;
                }
                hashMap.put(querySpec, (DerivedPropertyDataInternal)pair.second);
            }
        }
        return this.getResultsFromPropertyProviders(dataAdaptersExecutionResult, true, executionProfiler, hashMap);
    }

    List<PropertyProvidersExecutionResult> getResultsFromPropertyProviders(DataAdaptersExecutionResult dataAdaptersExecutionResult, boolean bl, ExecutionProfiler executionProfiler, Map<QuerySpec, DerivedPropertyDataInternal> map) throws InterruptedException {
        Map<QuerySpec, ResultSetInfo> map2 = dataAdaptersExecutionResult.getResultsPerQuery();
        if (map2 == null || map2.isEmpty()) {
            return new ArrayList<PropertyProvidersExecutionResult>();
        }
        ArrayList<PropertyProvidersExecutionResult> arrayList = new ArrayList<PropertyProvidersExecutionResult>();
        Map<QuerySpec, ResultSetInfo> map3 = dataAdaptersExecutionResult.getResultsPerQuery();
        Set<QuerySpec> set = map2.keySet();
        Map<QuerySpec, QuerySpec> map4 = this.transformQueries(set.toArray(new QuerySpec[set.size()]));
        Object object = executionProfiler.startTimer(ORDERING_PROPERTY_TIME_LABEL);
        HashSet<QuerySpec> hashSet = null;
        if (!bl) {
            hashSet = new HashSet<QuerySpec>();
        }
        PropertyProvidersExecutionResult propertyProvidersExecutionResult = this.getResultsFromPropertyProviders(dataAdaptersExecutionResult, bl, map4, true, map, hashSet);
        arrayList.add(propertyProvidersExecutionResult);
        executionProfiler.stopTimer(object);
        object = executionProfiler.startTimer(PAGE_SORT_TIME_LABEL);
        map3 = ResultsManager.applyResultSpecsToResults(map3, hashSet != null ? hashSet : Collections.emptySet());
        executionProfiler.stopTimer(object);
        object = executionProfiler.startTimer(REMAINING_PROPERTY_TIME_LABEL);
        PropertyProvidersExecutionResult propertyProvidersExecutionResult2 = this.getResultsFromPropertyProviders(dataAdaptersExecutionResult, bl, map4, false, map, null);
        arrayList.add(propertyProvidersExecutionResult2);
        executionProfiler.stopTimer(object);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private PropertyProvidersExecutionResult getResultsFromPropertyProviders(DataAdaptersExecutionResult dataAdaptersExecutionResult, boolean bl, Map<QuerySpec, QuerySpec> map, boolean bl2, Map<QuerySpec, DerivedPropertyDataInternal> map2, Set<QuerySpec> set) throws InterruptedException {
        void var11_14;
        Object object;
        Map<QuerySpec, ResultSetInfo> map3 = dataAdaptersExecutionResult.getResultsPerQuery();
        IdentityHashMap<QuerySpec, PropertyProviderCallingInfo> identityHashMap = new IdentityHashMap<QuerySpec, PropertyProviderCallingInfo>(map3.size());
        LinkedList<PropertyProviderExecutionDetails> linkedList = new LinkedList<PropertyProviderExecutionDetails>();
        for (QuerySpec object22 : map.keySet()) {
            object = map.get(object22);
            DerivedPropertyDataInternal derivedPropertyDataInternal = map2 != null ? map2.get(object) : null;
            Set<String> set2 = null;
            if (bl2 && (set2 = DataManager.getOrderingProperties(object22)).isEmpty()) continue;
            this.processPropertyProviderQueryResult((QuerySpec)object, object22, map3, identityHashMap, linkedList, bl2, set2, bl, derivedPropertyDataInternal);
            if (set == null || set2 == null || set2.isEmpty()) continue;
            set.add((QuerySpec)object);
        }
        Map<QuerySpec, ResultSetInfo> map4 = map3;
        Object var11_12 = null;
        if (!bl) {
            object = this.getDataFromDynamicAdaptersForRemainingProperties(map3, identityHashMap, dataAdaptersExecutionResult.getDynamicAdapterObjectsPerQuerySpec());
            map4 = ((DataAdaptersExecutionResult)object).getResultsPerQuery();
            List<DataAdapterExecutionDetails> list = ((DataAdaptersExecutionResult)object).getAdaptersExecutionDetails();
        }
        return new PropertyProvidersExecutionResult(map4, linkedList, (List<DataAdapterExecutionDetails>)var11_14);
    }

    private void processPropertyProviderQueryResult(QuerySpec querySpec, QuerySpec querySpec2, Map<QuerySpec, ResultSetInfo> map, Map<QuerySpec, PropertyProviderCallingInfo> map2, List<PropertyProviderExecutionDetails> list, boolean bl, Set<String> set, boolean bl2, DerivedPropertyDataInternal derivedPropertyDataInternal) throws InterruptedException {
        ResultSetInfo resultSetInfo = map.get(querySpec);
        PropertyProviderSpec propertyProviderSpec = this.getPropertyProviderSpec(querySpec2, resultSetInfo, set, bl2, derivedPropertyDataInternal);
        Map<PropertyProviderAdapter, PropertyProviderCallingInfo> map3 = propertyProviderSpec.supportedProviderInfos;
        int n = map3.size();
        if (n > 0) {
            Set<String> set2;
            if (bl) {
                set2 = DataManager.getOrderingPropertiesForProviders(map3);
                set.removeAll(set2);
                _logger.warn("Sorting on property-provider properties: " + set2);
            }
            set2 = this.invokePropertyProviders(querySpec2, map3);
            List list2 = (List)((Pair)set2).first;
            ArrayList<ResultSetInfo> arrayList = new ArrayList<ResultSetInfo>(list2.size() + 1);
            arrayList.add(resultSetInfo);
            arrayList.addAll(list2);
            ResultSetInfo resultSetInfo2 = this._resultsMerger.mergeResults(querySpec, arrayList);
            map.put(querySpec, resultSetInfo2);
            List<PropertyProviderExecutionDetails> list3 = (List<PropertyProviderExecutionDetails>)((Pair)set2).second;
            if (list3 != null && list3.size() > 0) {
                if (bl2 && derivedPropertyDataInternal != null) {
                    list3 = DataManager.asDerivedPropProviderExecDetails(list3, derivedPropertyDataInternal.getSourcePropertyNamesByType());
                }
                list.addAll((Collection<PropertyProviderExecutionDetails>)list3);
            }
        }
        map2.put(querySpec, propertyProviderSpec.unsupportedProviderInfo);
    }

    private static List<PropertyProviderExecutionDetails> asDerivedPropProviderExecDetails(List<PropertyProviderExecutionDetails> list, Map<String, List<String>> map) {
        ArrayList<PropertyProviderExecutionDetails> arrayList = new ArrayList<PropertyProviderExecutionDetails>(list.size());
        for (PropertyProviderExecutionDetails propertyProviderExecutionDetails : list) {
            arrayList.add(DerivedPropertyProviderExecutionDetails.copyOf(propertyProviderExecutionDetails, map));
        }
        return arrayList;
    }

    private static Set<String> getOrderingProperties(QuerySpec querySpec) {
        assert (querySpec != null);
        if (querySpec.resultSpec == null || querySpec.resultSpec.order == null || ArrayUtil.isNullOrEmpty((Object[])querySpec.resultSpec.order.orderingProperties)) {
            return Collections.emptySet();
        }
        OrderingPropertySpec[] orderingPropertySpecArray = querySpec.resultSpec.order.orderingProperties;
        HashSet<String> hashSet = new HashSet<String>();
        for (OrderingPropertySpec orderingPropertySpec : orderingPropertySpecArray) {
            String[] stringArray;
            if (orderingPropertySpec == null || orderingPropertySpec.propertyNames == null) continue;
            for (String string : stringArray = orderingPropertySpec.propertyNames) {
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private static Set<String> getOrderingPropertiesForProviders(Map<PropertyProviderAdapter, PropertyProviderCallingInfo> map) {
        if (map == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertyProviderAdapter propertyProviderAdapter : map.keySet()) {
            PropertyProviderCallingInfo propertyProviderCallingInfo = map.get(propertyProviderAdapter);
            if (propertyProviderCallingInfo == null) continue;
            Set<PropertySpec> set = propertyProviderCallingInfo.propertySet;
            DataManager.extractPropertyNames(set, hashSet);
        }
        return hashSet;
    }

    private static void extractPropertyNames(Set<PropertySpec> set, Set<String> set2) {
        if (set == null) {
            return;
        }
        for (PropertySpec propertySpec : set) {
            String[] stringArray;
            if (propertySpec == null) continue;
            for (String string : stringArray = propertySpec.propertyNames) {
                if (string == null) continue;
                set2.add(string);
            }
        }
    }

    private Pair<List<ResultSetInfo>, List<PropertyProviderExecutionDetails>> invokePropertyProviders(final QuerySpec querySpec, Map<PropertyProviderAdapter, PropertyProviderCallingInfo> map) throws InterruptedException {
        PropertySpec[] propertySpecArray;
        Object object;
        Object object2;
        int n = map.size();
        assert (n > 0) : "There should be at least one property provider";
        ArrayList<Callable<PropertyProviderExecutionResult>> arrayList = new ArrayList<Callable<PropertyProviderExecutionResult>>(n);
        ArrayList<PropertyProviderAdapter> arrayList2 = new ArrayList<PropertyProviderAdapter>(n);
        for (final PropertyProviderAdapter object32 : map.keySet()) {
            arrayList2.add(object32);
            object2 = map.get(object32);
            object = ((PropertyProviderCallingInfo)object2).objectSet.toArray(EMPTY_OBJECTS);
            propertySpecArray = ((PropertyProviderCallingInfo)object2).propertySet.toArray(EMPTY_PROP_SPECS);
            DerivedPropertyData derivedPropertyData = ((PropertyProviderCallingInfo)object2).derivedPropertyData;
            Callable<PropertyProviderExecutionResult> callable = new Callable<PropertyProviderExecutionResult>((Object[])object, propertySpecArray, derivedPropertyData){
                final /* synthetic */ Object[] val$objectSet;
                final /* synthetic */ PropertySpec[] val$propSpecForRemainingProps;
                final /* synthetic */ DerivedPropertyData val$derivedPropertyData;
                {
                    this.val$objectSet = objectArray;
                    this.val$propSpecForRemainingProps = propertySpecArray;
                    this.val$derivedPropertyData = derivedPropertyData;
                }

                @Override
                public PropertyProviderExecutionResult call() {
                    ExecutionProfiler executionProfiler = SessionUtil.getExecutionProfiler();
                    PropertyProviderExecutionResult propertyProviderExecutionResult = DataManager.getResultFromPropertyProvider(querySpec, object32, this.val$objectSet, this.val$propSpecForRemainingProps, this.val$derivedPropertyData);
                    propertyProviderExecutionResult.result.getResultSet().queryName = querySpec.name;
                    executionProfiler.putExecutionTime(this.toString(), Long.valueOf(propertyProviderExecutionResult.details.getElapsedTime()));
                    return propertyProviderExecutionResult;
                }

                public String toString() {
                    return "Property provider " + object32;
                }
            };
            arrayList.add(callable);
        }
        List<PropertyProviderExecutionResult> list = this.executeProperyProviderTasks(arrayList2, arrayList, querySpec);
        ArrayList<PropertyProviderExecutionDetails> arrayList3 = new ArrayList<PropertyProviderExecutionDetails>(n);
        object2 = new ArrayList(n);
        object = list.iterator();
        while (object.hasNext()) {
            propertySpecArray = (PropertyProviderExecutionResult)object.next();
            object2.add(propertySpecArray.result);
            arrayList3.add(propertySpecArray.details);
        }
        return new Pair(object2, arrayList3);
    }

    private List<PropertyProviderExecutionResult> executeProperyProviderTasks(List<PropertyProviderAdapter> list, List<Callable<PropertyProviderExecutionResult>> list2, QuerySpec querySpec) throws InterruptedException {
        assert (list != null && list2 != null);
        assert (list.size() == list2.size());
        List list3 = this._taskExecutor.executeTasks(list2);
        ArrayList<PropertyProviderExecutionResult> arrayList = new ArrayList<PropertyProviderExecutionResult>(list3.size());
        for (int i = 0; i < list3.size(); ++i) {
            PropertyProviderExecutionResult propertyProviderExecutionResult;
            ExecutorUtil.TaskResult taskResult = list3.get(i);
            Exception exception = taskResult.getException();
            if (exception != null) {
                PropertyProviderAdapter propertyProviderAdapter = list.get(i);
                exception = this.processPropertyProviderTaskException(propertyProviderAdapter, exception);
                ResultSetInfo resultSetInfo = ResultSetInfo.createErrorResult(exception);
                propertyProviderExecutionResult = new PropertyProviderExecutionResult(resultSetInfo, null);
            } else {
                propertyProviderExecutionResult = (PropertyProviderExecutionResult)taskResult.getResult();
            }
            arrayList.add(propertyProviderExecutionResult);
        }
        return arrayList;
    }

    private Exception processPropertyProviderTaskException(PropertyProviderAdapter propertyProviderAdapter, Exception exception) {
        if (!(exception instanceof TimeoutException)) {
            return exception;
        }
        String string = Utils.renderPropertyProvider(propertyProviderAdapter);
        String string2 = String.format(Utils.getLocalizedString("error.propertyProviderTimeout"), string, this._taskExecutor.getTaskTimeoutInSecs());
        return new DataServiceException(string2, exception);
    }

    private Map<QuerySpec, QuerySpec> createQueryForRemainingProperties(Map<QuerySpec, PropertyProviderCallingInfo> map) {
        HashMap<QuerySpec, QuerySpec> hashMap = new HashMap<QuerySpec, QuerySpec>();
        for (Map.Entry<QuerySpec, PropertyProviderCallingInfo> entry : map.entrySet()) {
            QuerySpec querySpec = entry.getKey();
            PropertyProviderCallingInfo propertyProviderCallingInfo = entry.getValue();
            QuerySpec querySpec2 = this.createQueryForRemainingProperties(propertyProviderCallingInfo.objectSet, propertyProviderCallingInfo.propertySet);
            if (querySpec2 == null) continue;
            querySpec2.name = "remaining-property-" + querySpec.name;
            hashMap.put(querySpec2, querySpec);
        }
        return hashMap;
    }

    private QuerySpec createQueryForRemainingProperties(Set<Object> set, Set<PropertySpec> set2) {
        Cloneable cloneable;
        Object object2;
        if (set.isEmpty()) {
            return null;
        }
        if (set2.isEmpty()) {
            return null;
        }
        Set set3 = CollectionUtil.filter(set2, (Predicate)new Predicate<PropertySpec>(){

            public boolean evaluate(PropertySpec propertySpec) {
                return !ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames);
            }
        });
        if (set3.isEmpty()) {
            return null;
        }
        ArrayList<ObjectIdentityConstraint> arrayList = new ArrayList<ObjectIdentityConstraint>();
        for (Object object2 : set) {
            cloneable = new ObjectIdentityConstraint();
            cloneable.target = object2;
            arrayList.add((ObjectIdentityConstraint)cloneable);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = arrayList.toArray(EMPTY_CONSTRAINTS);
        object2 = new ResourceSpec();
        ((ResourceSpec)object2).propertySpecs = set3.toArray(EMPTY_PROP_SPECS);
        ((ResourceSpec)object2).constraint = compositeConstraint;
        cloneable = new QuerySpec();
        ((QuerySpec)cloneable).resourceSpec = object2;
        ((QuerySpec)cloneable).resultSpec = new ResultSpec();
        ((QuerySpec)cloneable).options = new HashMap<String, Object>();
        return cloneable;
    }

    private PropertyProviderSpec getPropertyProviderSpec(QuerySpec querySpec, ResultSetInfo resultSetInfo, Set<String> set, boolean bl, DerivedPropertyData derivedPropertyData) {
        assert (querySpec != null && querySpec.resourceSpec != null);
        assert (resultSetInfo != null && resultSetInfo.getResultSet() != null);
        PropertyProviderSpec propertyProviderSpec = new PropertyProviderSpec();
        ResultDirectory resultDirectory = new ResultDirectory(this._metadataRegistry, querySpec, resultSetInfo);
        if (!resultDirectory.hasRemainingProperties()) {
            return propertyProviderSpec;
        }
        Map<String, Set<Object>> map = resultDirectory.getEnumeratedObjects();
        if (map.isEmpty()) {
            return propertyProviderSpec;
        }
        for (String string : map.keySet()) {
            Set<Object> set2 = map.get(string);
            if (set2.isEmpty()) continue;
            Set<String> set3 = resultDirectory.getRemainingPropertiesFor(string);
            if (set != null) {
                set3.retainAll(set);
            }
            if (set3.isEmpty()) continue;
            Collection<PropertyProviderInfo> collection = null;
            collection = !bl ? this._dataAdapterRegistry.getPropertyProviders(string, set3) : this._dataAdapterRegistry.getDerivedPropertyProviders(string, set3);
            HashSet<String> hashSet = new HashSet<String>(set3);
            for (PropertyProviderInfo propertyProviderInfo : collection) {
                PropertyProviderAdapter propertyProviderAdapter = propertyProviderInfo.propertyProvider;
                PropertyProviderCallingInfo propertyProviderCallingInfo = propertyProviderSpec.supportedProviderInfos.get(propertyProviderAdapter);
                if (propertyProviderCallingInfo == null) {
                    propertyProviderCallingInfo = new PropertyProviderCallingInfo();
                    propertyProviderSpec.supportedProviderInfos.put(propertyProviderAdapter, propertyProviderCallingInfo);
                }
                propertyProviderCallingInfo.objectSet.addAll(set2);
                Set<String> set4 = propertyProviderInfo.providedProperties;
                PropertySpec propertySpec = DataManager.getPropertySpec(resultDirectory, string, propertyProviderInfo.providedProperties);
                propertyProviderCallingInfo.propertySet.add(propertySpec);
                propertyProviderCallingInfo.derivedPropertyData = derivedPropertyData;
                hashSet.removeAll(set4);
            }
            if (hashSet.isEmpty()) continue;
            PropertyProviderCallingInfo propertyProviderCallingInfo = propertyProviderSpec.unsupportedProviderInfo;
            propertyProviderCallingInfo.objectSet.addAll(set2);
            PropertySpec propertySpec = DataManager.getPropertySpec(resultDirectory, string, hashSet);
            propertyProviderCallingInfo.propertySet.add(propertySpec);
            propertyProviderCallingInfo.derivedPropertyData = derivedPropertyData;
        }
        return propertyProviderSpec;
    }

    private static PropertySpec getPropertySpec(ResultDirectory resultDirectory, String string, Set<String> set) {
        ParameterSpec[] parameterSpecArray = resultDirectory.getParametersFor(set).toArray(EMPTY_PARAMETER_SPECS);
        String[] stringArray = set.toArray(EMPTY_STRINGS);
        return Utils.newPropertySpec(string, stringArray, parameterSpecArray);
    }

    private DataAdaptersExecutionResult getDataFromDynamicAdaptersForRemainingProperties(Map<QuerySpec, ResultSetInfo> map, Map<QuerySpec, PropertyProviderCallingInfo> map2, Map<QuerySpec, Set<Object>> map3) throws InterruptedException {
        if (map2.isEmpty()) {
            DataAdaptersExecutionResult dataAdaptersExecutionResult = new DataAdaptersExecutionResult(map, null);
            return dataAdaptersExecutionResult;
        }
        if (map.isEmpty()) {
            DataAdaptersExecutionResult dataAdaptersExecutionResult = new DataAdaptersExecutionResult(map, null);
            return dataAdaptersExecutionResult;
        }
        Collection<DataAdapterInfo> collection = this._dataAdapterRegistry.getDynamicAdapters();
        int n = collection.size();
        if (n == 0) {
            DataAdaptersExecutionResult dataAdaptersExecutionResult = new DataAdaptersExecutionResult(map, null);
            return dataAdaptersExecutionResult;
        }
        this.filterDynamicAdapterRetrievedObjects(map2, map3);
        Map<QuerySpec, QuerySpec> map4 = this.createQueryForRemainingProperties(map2);
        if (map4.isEmpty()) {
            DataAdaptersExecutionResult dataAdaptersExecutionResult = new DataAdaptersExecutionResult(map, null);
            return dataAdaptersExecutionResult;
        }
        Set<QuerySpec> set = map4.keySet();
        QuerySpec[] querySpecArray = this.getQueriesAppropriateForDynamicAdapters(set);
        if (querySpecArray.length == 0) {
            DataAdaptersExecutionResult dataAdaptersExecutionResult = new DataAdaptersExecutionResult(map, null);
            return dataAdaptersExecutionResult;
        }
        ArrayList<Callable<DataAdaptersExecutionResult>> arrayList = new ArrayList<Callable<DataAdaptersExecutionResult>>(collection.size());
        ArrayList<DataAdapterUtil.DataAdapterQueryBatch> arrayList2 = new ArrayList<DataAdapterUtil.DataAdapterQueryBatch>(collection.size());
        for (DataAdapterInfo object2 : collection) {
            Callable<DataAdaptersExecutionResult> callable = DataAdapterUtil.createAdapterTask(object2, querySpecArray, "Dynamic adapter");
            arrayList.add(callable);
            arrayList2.add(new DataAdapterUtil.DataAdapterQueryBatch(object2, querySpecArray));
        }
        List<DataAdaptersExecutionResult> list = DataAdapterUtil.executeAdapterTasks(this._taskExecutor, arrayList2, arrayList);
        DataAdaptersExecutionResult dataAdaptersExecutionResult = this.mergeDataAdapterResults(map, map4, list);
        return dataAdaptersExecutionResult;
    }

    private void filterDynamicAdapterRetrievedObjects(Map<QuerySpec, PropertyProviderCallingInfo> map, Map<QuerySpec, Set<Object>> map2) {
        if (map2 == null) {
            return;
        }
        for (Map.Entry<QuerySpec, PropertyProviderCallingInfo> entry : map.entrySet()) {
            QuerySpec querySpec = entry.getKey();
            Set<Object> set = map2.get(querySpec);
            PropertyProviderCallingInfo propertyProviderCallingInfo = entry.getValue();
            if (set == null) continue;
            propertyProviderCallingInfo.objectSet.removeAll(set);
        }
    }

    private QuerySpec[] getQueriesAppropriateForDynamicAdapters(Collection<? extends QuerySpec> collection) {
        assert (collection != null);
        if (collection.isEmpty()) {
            return EMPTY_QUERY_SPECS;
        }
        ArrayList<QuerySpec> arrayList = null;
        for (QuerySpec querySpec : collection) {
            if (!Utils.containsNonExplicitType(querySpec, this._metadataRegistry)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<QuerySpec>(collection.size());
            }
            arrayList.add(querySpec);
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return EMPTY_QUERY_SPECS;
        }
        QuerySpec[] querySpecArray = arrayList.toArray(new QuerySpec[arrayList.size()]);
        return querySpecArray;
    }

    private DataAdaptersExecutionResult mergeDataAdapterResults(Map<QuerySpec, ResultSetInfo> map, Map<QuerySpec, QuerySpec> map2, List<DataAdaptersExecutionResult> list) {
        LinkedList<DataAdapterExecutionDetails> linkedList = new LinkedList<DataAdapterExecutionDetails>();
        for (DataAdaptersExecutionResult dataAdaptersExecutionResult : list) {
            Map<QuerySpec, ResultSetInfo> map3 = dataAdaptersExecutionResult.getResultsPerQuery();
            if (map3 == null) {
                _logger.info("resultsForRemainingProperties is null.");
                continue;
            }
            for (QuerySpec querySpec : map3.keySet()) {
                QuerySpec querySpec2 = map2.get(querySpec);
                ArrayList<ResultSetInfo> arrayList = new ArrayList<ResultSetInfo>();
                ResultSetInfo resultSetInfo = map.get(querySpec2);
                arrayList.add(resultSetInfo);
                ResultSetInfo resultSetInfo2 = map3.get(querySpec);
                if (resultSetInfo2.getResultSet().error != null) {
                    DataManager.logInabilityToRetrieveRemainingProperties(querySpec);
                    resultSetInfo2.getResultSet().error = null;
                }
                resultSetInfo2.getResultSet().totalMatchedObjectCount = 0;
                arrayList.add(resultSetInfo2);
                ResultSetInfo resultSetInfo3 = this._resultsMerger.mergeResults(querySpec2, arrayList);
                map.put(querySpec2, resultSetInfo3);
            }
            List<DataAdapterExecutionDetails> list2 = dataAdaptersExecutionResult.getAdaptersExecutionDetails();
            if (list2 == null || list2.size() <= 0) continue;
            linkedList.addAll((Collection<DataAdapterExecutionDetails>)list2);
        }
        return new DataAdaptersExecutionResult(map, linkedList);
    }

    private static void logInabilityToRetrieveRemainingProperties(QuerySpec querySpec) {
        if (querySpec == null || querySpec.resourceSpec == null || querySpec.resourceSpec.propertySpecs == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot retrieve remaining properties: [");
        for (PropertySpec propertySpec : querySpec.resourceSpec.propertySpecs) {
            for (int i = 0; i < propertySpec.propertyNames.length; ++i) {
                String string = propertySpec.propertyNames[i];
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string);
            }
        }
        stringBuilder.append("] from dynamic-adpater");
        _logger.warn(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyProviderExecutionResult getResultFromPropertyProvider(QuerySpec querySpec, PropertyProviderAdapter propertyProviderAdapter, Object[] objectArray, PropertySpec[] propertySpecArray, DerivedPropertyData derivedPropertyData) {
        try (ViseDsLogConfigurator.ViseDsLogContext viseDsLogContext = ViseDsLogConfigurator.onPropertyProviderStart(querySpec, propertyProviderAdapter);){
            long l = System.currentTimeMillis();
            ResultSetInfo resultSetInfo = DataManager.getDataFromPropertyProvider(propertyProviderAdapter, objectArray, propertySpecArray, derivedPropertyData);
            long l2 = System.currentTimeMillis() - l;
            PropertyProviderExecutionDetails propertyProviderExecutionDetails = new PropertyProviderExecutionDetails(propertyProviderAdapter, viseDsLogContext.getInvocationId(), l2, querySpec, propertySpecArray);
            PropertyProviderExecutionResult propertyProviderExecutionResult = new PropertyProviderExecutionResult(resultSetInfo, propertyProviderExecutionDetails);
            return propertyProviderExecutionResult;
        }
    }

    private static ResultSetInfo getDataFromPropertyProvider(PropertyProviderAdapter propertyProviderAdapter, Object[] objectArray, PropertySpec[] propertySpecArray, DerivedPropertyData derivedPropertyData) {
        ResultSetInfo resultSetInfo = null;
        PropertyRequestSpec propertyRequestSpec = new PropertyRequestSpec();
        propertyRequestSpec.objects = objectArray;
        propertyRequestSpec.properties = propertySpecArray;
        propertyRequestSpec.derivedPropertyData = derivedPropertyData;
        try {
            ResultSet resultSet = propertyProviderAdapter.getProperties(propertyRequestSpec);
            if (resultSet != null) {
                resultSet.totalMatchedObjectCount = 0;
                resultSetInfo = ResultSetInfo.getResultSetInfo(resultSet, true);
            } else {
                resultSetInfo = ResultSetInfo.newEmptyResultSetInfo();
            }
        }
        catch (Exception exception) {
            resultSetInfo = ResultSetInfo.createErrorResult(exception);
        }
        catch (AssertionError assertionError) {
            IllegalStateException illegalStateException = new IllegalStateException(String.format("Property provider adapter [%s] failed with internal assertion error with message `%s'.", propertyProviderAdapter, ((Throwable)((Object)assertionError)).getMessage()), (Throwable)((Object)assertionError));
            resultSetInfo = ResultSetInfo.createErrorResult(illegalStateException);
        }
        return resultSetInfo;
    }

    void shutdown() {
        this._taskExecutor.shutdown();
    }

    private static class PropertyProviderExecutionResult {
        final ResultSetInfo result;
        final PropertyProviderExecutionDetails details;

        PropertyProviderExecutionResult(ResultSetInfo resultSetInfo, PropertyProviderExecutionDetails propertyProviderExecutionDetails) {
            assert (resultSetInfo != null);
            this.result = resultSetInfo;
            this.details = propertyProviderExecutionDetails;
        }
    }

    private static class PropertyProviderSpec {
        final Map<PropertyProviderAdapter, PropertyProviderCallingInfo> supportedProviderInfos = new HashMap<PropertyProviderAdapter, PropertyProviderCallingInfo>();
        final PropertyProviderCallingInfo unsupportedProviderInfo = new PropertyProviderCallingInfo();

        private PropertyProviderSpec() {
        }
    }

    private static class PropertyProviderCallingInfo {
        final Set<Object> objectSet = new HashSet<Object>();
        final Set<PropertySpec> propertySet = new HashSet<PropertySpec>();
        DerivedPropertyData derivedPropertyData;

        private PropertyProviderCallingInfo() {
        }
    }
}

