/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.common.PathTemplate;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.DataAdapterInfo;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.PropertyProviderInfo;
import com.vmware.vise.data.query.impl.SubTypeResolver;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.IdentityHashSet;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataServiceExtensionRegistryImpl
implements DataServiceExtensionRegistryInternal {
    private static final Log _logger = LogFactory.getLog(DataServiceExtensionRegistryImpl.class);
    private final ReadWriteLock _dataAdapterLock = new ReentrantReadWriteLock();
    private final ReadWriteLock _propertyProviderLock = new ReentrantReadWriteLock();
    private final ReadWriteLock _derivedPropertyProviderLock = new ReentrantReadWriteLock();
    private final Map<String, List<DataAdapterInfo>> _dataAdaptersByTypeName;
    private final IdentityHashSet<DataProviderAdapter> _dynamicTypedAdapter;
    private final IdentityHashSet<DataAdapterInfo> _dynamicDataAdapterInfo;
    private final IdentityHashMap<PropertyProviderAdapter, TypeInfo[]> _providerTypeInfoMap;
    private final TypePropertyTupleMap<PropertyProviderAdapter> _typePropertyTupleProviderMap;
    private final IdentityHashMap<DerivedPropertyProviderAdapter, TypeInfo[]> _derivedProviderTypeInfoMap;
    private final TypePropertyTupleMap<DerivedPropertyProviderAdapter> _typePropertyTupleDerivedProviderMap;
    private final IdentityHashMap<DataProviderAdapter, DataAdapterInfo> _adapterToInfoMap;
    private final ReadWriteLock _refAdapterLock = new ReentrantReadWriteLock();
    private final Map<Class<?>, ResourceObjectReferenceAdapter> _refAdapterByType;
    private final Map<String, ResourceObjectReferenceAdapter> _refAdapterByUidPrefix;
    private final Map<Class<?>, Set<String>> _uidPrefixSetByType;
    private final MetadataServiceRegistryInternal _metadataServiceRegistry;
    private final SubTypeResolver _subTypeResolver;

    public DataServiceExtensionRegistryImpl(MetadataServiceRegistryInternal metadataServiceRegistryInternal, SubTypeResolver subTypeResolver) {
        if (metadataServiceRegistryInternal == null) {
            throw new IllegalArgumentException("metadataServiceRegistry shouldn't be null");
        }
        this._metadataServiceRegistry = metadataServiceRegistryInternal;
        this._subTypeResolver = subTypeResolver;
        this._dataAdaptersByTypeName = new HashMap<String, List<DataAdapterInfo>>();
        this._dynamicTypedAdapter = new IdentityHashSet();
        this._dynamicDataAdapterInfo = new IdentityHashSet();
        this._providerTypeInfoMap = new IdentityHashMap();
        this._typePropertyTupleProviderMap = new TypePropertyTupleMap();
        this._derivedProviderTypeInfoMap = new IdentityHashMap();
        this._typePropertyTupleDerivedProviderMap = new TypePropertyTupleMap();
        this._adapterToInfoMap = new IdentityHashMap();
        this._refAdapterByType = new HashMap();
        this._refAdapterByUidPrefix = new HashMap<String, ResourceObjectReferenceAdapter>();
        this._uidPrefixSetByType = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDataAdapter(DataProviderAdapter dataProviderAdapter, String[] stringArray) {
        if (dataProviderAdapter == null) {
            return;
        }
        String string = dataProviderAdapter.getClass().getName();
        if (_logger.isDebugEnabled()) {
            DataServiceExtensionRegistryImpl.logAdapterRegistration(string, stringArray);
        }
        this._dataAdapterLock.writeLock().lock();
        try {
            if (stringArray == null || stringArray.length == 0) {
                DataServiceExtensionRegistryImpl.registerDynamicAdapter(this._dynamicTypedAdapter, this._dynamicDataAdapterInfo, dataProviderAdapter, string);
                return;
            }
            DataAdapterInfo dataAdapterInfo = DataServiceExtensionRegistryImpl.toDataAdapterInfo(dataProviderAdapter, DataServiceExtensionRegistryImpl.toTypeInfos(stringArray), this._adapterToInfoMap);
            for (String string2 : stringArray) {
                if (string2 == null || string2.length() == 0) {
                    _logger.error((Object)("Invalid null/empty type provided by adapter: " + string));
                    continue;
                }
                List<DataAdapterInfo> list = this._dataAdaptersByTypeName.get(string2);
                if (list == null) {
                    list = new ArrayList<DataAdapterInfo>();
                    this._dataAdaptersByTypeName.put(string2, list);
                }
                this._adapterToInfoMap.put(dataProviderAdapter, dataAdapterInfo);
                boolean bl = list.add(dataAdapterInfo);
                if (bl) continue;
                _logger.error((Object)("Adapter already registered: " + string + ", for type: " + string2));
            }
        }
        finally {
            this._dataAdapterLock.writeLock().unlock();
        }
    }

    private static void registerDynamicAdapter(IdentityHashSet<DataProviderAdapter> identityHashSet, IdentityHashSet<DataAdapterInfo> identityHashSet2, DataProviderAdapter dataProviderAdapter, String string) {
        boolean bl = identityHashSet.add((Object)dataProviderAdapter);
        if (bl) {
            DataAdapterInfo dataAdapterInfo = new DataAdapterInfo();
            dataAdapterInfo.adapter = dataProviderAdapter;
            identityHashSet2.add((Object)dataAdapterInfo);
        } else {
            _logger.error((Object)("Dynamic adapter already registered! " + string));
        }
    }

    @Override
    public void registerDataAdapter(PropertyProviderAdapter propertyProviderAdapter, TypeInfo[] typeInfoArray) {
        if (propertyProviderAdapter == null) {
            return;
        }
        String string = propertyProviderAdapter.getClass().getName();
        if (typeInfoArray == null || typeInfoArray.length == 0) {
            _logger.error((Object)("Invalid null or empty types from provider " + string));
            return;
        }
        if (_logger.isDebugEnabled()) {
            DataServiceExtensionRegistryImpl.logProviderRegistration(string, typeInfoArray);
        }
        if (propertyProviderAdapter instanceof DerivedPropertyProviderAdapter) {
            this.registerDerivedPropertyProviderAdapter((DerivedPropertyProviderAdapter)propertyProviderAdapter, typeInfoArray);
        } else {
            this.registerPropertyProviderAdapter(propertyProviderAdapter, typeInfoArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reRegisterDataAdapter(PropertyProviderAdapter propertyProviderAdapter, TypeInfo[] typeInfoArray) {
        Lock lock = this._propertyProviderLock.writeLock();
        if (propertyProviderAdapter instanceof DerivedPropertyProviderAdapter) {
            lock = this._derivedPropertyProviderLock.writeLock();
        }
        lock.lock();
        try {
            this.unregisterDataAdapter(propertyProviderAdapter);
            this.registerDataAdapter(propertyProviderAdapter, typeInfoArray);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPropertyProviderAdapter(PropertyProviderAdapter propertyProviderAdapter, TypeInfo[] typeInfoArray) {
        this._propertyProviderLock.writeLock().lock();
        try {
            if (this._providerTypeInfoMap.put(propertyProviderAdapter, typeInfoArray) != null) {
                _logger.error((Object)("The PropertyProviderAdapter '" + Utils.renderPropertyProvider(propertyProviderAdapter) + "' was already registered and the properties for which it was registered are replaced with [" + Arrays.toString(typeInfoArray) + "]"));
                return;
            }
            for (TypeInfo typeInfo : typeInfoArray) {
                for (String string : typeInfo.properties) {
                    PropertyProviderAdapter propertyProviderAdapter2 = this._typePropertyTupleProviderMap.addTupleValue(typeInfo.type, string, propertyProviderAdapter);
                    if (propertyProviderAdapter2 == null) continue;
                    _logger.warn((Object)("The PropertyProviderAdapter '" + Utils.renderPropertyProvider(propertyProviderAdapter2) + "' was already registered for type '" + typeInfo.type + "' and property '" + string + "' and was replaced by '" + Utils.renderPropertyProvider(propertyProviderAdapter) + "'"));
                }
            }
        }
        finally {
            this._propertyProviderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDerivedPropertyProviderAdapter(DerivedPropertyProviderAdapter derivedPropertyProviderAdapter, TypeInfo[] typeInfoArray) {
        this._derivedPropertyProviderLock.writeLock().lock();
        try {
            if (this._derivedProviderTypeInfoMap.put(derivedPropertyProviderAdapter, typeInfoArray) != null) {
                _logger.error((Object)("The DerivedPropertyProviderAdapter '" + derivedPropertyProviderAdapter.getClass().getCanonicalName() + "' was already registered and the properties for which it was registered are replaced with [" + Arrays.toString(typeInfoArray) + "]"));
                return;
            }
            for (TypeInfo typeInfo : typeInfoArray) {
                for (String string : typeInfo.properties) {
                    DerivedPropertyProviderAdapter derivedPropertyProviderAdapter2 = this._typePropertyTupleDerivedProviderMap.addTupleValue(typeInfo.type, string, derivedPropertyProviderAdapter);
                    if (derivedPropertyProviderAdapter2 == null) continue;
                    _logger.warn((Object)("The DerivedPropertyProviderAdapter '" + derivedPropertyProviderAdapter2.getClass().getCanonicalName() + "' was already registered for type '" + typeInfo.type + "' and property '" + string + "' and was replaced by '" + derivedPropertyProviderAdapter.getClass().getCanonicalName() + "'"));
                }
                this._subTypeResolver.updateSubTypes(typeInfo.type);
            }
        }
        finally {
            this._derivedPropertyProviderLock.writeLock().unlock();
        }
    }

    @Override
    public void unregisterDataAdapter(DataProviderAdapter dataProviderAdapter) {
        if (dataProviderAdapter == null) {
            return;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Unregistering DataProviderAdapter: " + dataProviderAdapter.getClass().getName()));
        }
        this._dataAdapterLock.writeLock().lock();
        try {
            if (this._dynamicTypedAdapter.contains((Object)dataProviderAdapter)) {
                this._dynamicTypedAdapter.remove((Object)dataProviderAdapter);
                DataServiceExtensionRegistryImpl.removeAdapterFromDynamicAdapterInfo(dataProviderAdapter, this._dynamicDataAdapterInfo);
                return;
            }
            DataServiceExtensionRegistryImpl.removeFromTypeDataAdapterMap(dataProviderAdapter, this._adapterToInfoMap, this._dataAdaptersByTypeName);
            this._adapterToInfoMap.remove(dataProviderAdapter);
        }
        finally {
            this._dataAdapterLock.writeLock().unlock();
        }
    }

    @Override
    public void unregisterDataAdapter(PropertyProviderAdapter propertyProviderAdapter) {
        if (propertyProviderAdapter == null) {
            return;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Unregistering PropertyProviderAdapter: " + propertyProviderAdapter.getClass().getName()));
        }
        if (propertyProviderAdapter instanceof DerivedPropertyProviderAdapter) {
            this.unregisterDerivedPropertyProviderAdapter((DerivedPropertyProviderAdapter)propertyProviderAdapter);
        } else {
            this.unregisterPropertyProviderAdapter(propertyProviderAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterPropertyProviderAdapter(PropertyProviderAdapter propertyProviderAdapter) {
        this._propertyProviderLock.writeLock().lock();
        try {
            TypeInfo[] typeInfoArray = this._providerTypeInfoMap.get(propertyProviderAdapter);
            if (typeInfoArray != null) {
                for (int i = 0; i < typeInfoArray.length; ++i) {
                    TypeInfo typeInfo = typeInfoArray[i];
                    for (String string : typeInfo.properties) {
                        this._typePropertyTupleProviderMap.removeTuple(typeInfo.type, string);
                    }
                }
                this._providerTypeInfoMap.remove(propertyProviderAdapter);
            }
        }
        finally {
            this._propertyProviderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterDerivedPropertyProviderAdapter(DerivedPropertyProviderAdapter derivedPropertyProviderAdapter) {
        this._derivedPropertyProviderLock.writeLock().lock();
        try {
            TypeInfo[] typeInfoArray = this._derivedProviderTypeInfoMap.get(derivedPropertyProviderAdapter);
            if (typeInfoArray != null) {
                for (int i = 0; i < typeInfoArray.length; ++i) {
                    TypeInfo typeInfo = typeInfoArray[i];
                    for (String string : typeInfo.properties) {
                        this._typePropertyTupleDerivedProviderMap.removeTuple(typeInfo.type, string);
                    }
                }
                this._derivedProviderTypeInfoMap.remove(derivedPropertyProviderAdapter);
            }
        }
        finally {
            this._derivedPropertyProviderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObjectRefTypeAdapter(ResourceObjectReferenceAdapter resourceObjectReferenceAdapter, Class<?> clazz, String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{clazz, resourceObjectReferenceAdapter});
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("uidPrefix cannot be null or emtpy");
        }
        if (Object.class.equals(clazz)) {
            throw new IllegalArgumentException("Cannot register an adapter for Object.");
        }
        this._refAdapterLock.writeLock().lock();
        try {
            if (!this._refAdapterByType.containsKey(clazz)) {
                this._refAdapterByType.put(clazz, resourceObjectReferenceAdapter);
                _logger.debug((Object)("Registering ResourceObjectReferenceAdapter for type: " + clazz.getName() + ", adapter: " + resourceObjectReferenceAdapter.getClass().getName()));
            } else {
                _logger.debug((Object)("RefTypeAdapter already registered for " + clazz + ", ignroing."));
            }
            if (!this._refAdapterByUidPrefix.containsKey(string)) {
                this._refAdapterByUidPrefix.put(string, resourceObjectReferenceAdapter);
                _logger.debug((Object)("Registering ResourceObjectReferenceAdapter for uidPrefix: " + string + ", adapter: " + resourceObjectReferenceAdapter.getClass().getName()));
            } else {
                _logger.debug((Object)("RefTypeAdapter already registered for " + string + ", ignroing."));
            }
            if (!this._uidPrefixSetByType.containsKey(clazz)) {
                this._uidPrefixSetByType.put(clazz, new HashSet());
            }
            Set<String> set = this._uidPrefixSetByType.get(clazz);
            set.add(string);
        }
        finally {
            this._refAdapterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterObjectRefTypeAdapter(Class<?> clazz) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{clazz});
        this._refAdapterLock.writeLock().lock();
        try {
            this._refAdapterByType.remove(clazz);
            Set<String> set = this._uidPrefixSetByType.get(clazz);
            for (String string : set) {
                this._refAdapterByUidPrefix.remove(string);
            }
        }
        finally {
            this._refAdapterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceObjectReferenceAdapter getObjectRefTypeAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        this._refAdapterLock.readLock().lock();
        try {
            ResourceObjectReferenceAdapter resourceObjectReferenceAdapter = this._refAdapterByType.get(clazz);
            if (resourceObjectReferenceAdapter != null) {
                ResourceObjectReferenceAdapter resourceObjectReferenceAdapter2 = resourceObjectReferenceAdapter;
                return resourceObjectReferenceAdapter2;
            }
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                ResourceObjectReferenceAdapter resourceObjectReferenceAdapter3 = null;
                return resourceObjectReferenceAdapter3;
            }
            ResourceObjectReferenceAdapter resourceObjectReferenceAdapter4 = resourceObjectReferenceAdapter = this.getObjectRefTypeAdapter(clazz2);
            return resourceObjectReferenceAdapter4;
        }
        finally {
            this._refAdapterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceObjectReferenceAdapter getObjectRefTypeAdapter(String string) {
        if (string == null) {
            return null;
        }
        this._refAdapterLock.readLock().lock();
        try {
            ResourceObjectReferenceAdapter resourceObjectReferenceAdapter;
            String string2 = DataServiceExtensionRegistryImpl.findUidPrefix(string, this._refAdapterByUidPrefix);
            ResourceObjectReferenceAdapter resourceObjectReferenceAdapter2 = resourceObjectReferenceAdapter = this._refAdapterByUidPrefix.get(string2);
            return resourceObjectReferenceAdapter2;
        }
        finally {
            this._refAdapterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DataAdapterInfo> getDataAdapters(QuerySpec querySpec) {
        IdentityHashSet identityHashSet = new IdentityHashSet();
        if (querySpec == null || querySpec.resourceSpec == null) {
            return identityHashSet;
        }
        Constraint constraint = querySpec.resourceSpec.constraint;
        String[] stringArray = Utils.getTypeNamesFromConstraint(constraint);
        this._dataAdapterLock.readLock().lock();
        try {
            boolean bl;
            if (stringArray != null) {
                for (String string : stringArray) {
                    List<DataAdapterInfo> list;
                    if (string == null || (list = this._dataAdaptersByTypeName.get(string)) == null) continue;
                    for (DataAdapterInfo dataAdapterInfo : list) {
                        if (dataAdapterInfo == null) continue;
                        identityHashSet.add(dataAdapterInfo);
                    }
                }
            }
            if (identityHashSet.isEmpty() && _logger.isDebugEnabled()) {
                _logger.debug((Object)("No specific adapters found for query : " + querySpec.name));
            }
            if (bl = Utils.containsNonExplicitType(stringArray, this._metadataServiceRegistry)) {
                identityHashSet.addAll(this._dynamicDataAdapterInfo);
            }
        }
        finally {
            this._dataAdapterLock.readLock().unlock();
        }
        return identityHashSet;
    }

    @Override
    public Collection<DataAdapterInfo> getDynamicAdapters() {
        this._dataAdapterLock.readLock().lock();
        try {
            ArrayList<DataAdapterInfo> arrayList;
            ArrayList<DataAdapterInfo> arrayList2 = arrayList = new ArrayList<DataAdapterInfo>((Collection<DataAdapterInfo>)this._dynamicDataAdapterInfo);
            return arrayList2;
        }
        finally {
            this._dataAdapterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PropertyProviderInfo> getPropertyProviders(String string, Set<String> set) {
        IdentityHashMap<PropertyProviderAdapter, PropertyProviderInfo> identityHashMap = new IdentityHashMap<PropertyProviderAdapter, PropertyProviderInfo>();
        this._propertyProviderLock.readLock().lock();
        try {
            if (set.isEmpty()) {
                List<PropertyProviderAdapter> list = this._typePropertyTupleProviderMap.lookupTupleValue(string, "*");
                DataServiceExtensionRegistryImpl.addPropertyProviderInfo(identityHashMap, list, "*");
            } else {
                for (String string2 : set) {
                    List<PropertyProviderAdapter> list = this._typePropertyTupleProviderMap.lookupTupleValue(string, string2);
                    DataServiceExtensionRegistryImpl.addPropertyProviderInfo(identityHashMap, list, string2);
                }
            }
        }
        finally {
            this._propertyProviderLock.readLock().unlock();
        }
        return identityHashMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PropertyProviderInfo> getDerivedPropertyProviders(String string, Set<String> set) {
        IdentityHashMap<PropertyProviderAdapter, PropertyProviderInfo> identityHashMap = new IdentityHashMap<PropertyProviderAdapter, PropertyProviderInfo>();
        this._derivedPropertyProviderLock.readLock().lock();
        try {
            if (set.isEmpty()) {
                List<DerivedPropertyProviderAdapter> list = this._typePropertyTupleDerivedProviderMap.lookupTupleValue(string, "*");
                DataServiceExtensionRegistryImpl.addPropertyProviderInfo(identityHashMap, list, "*");
            } else {
                for (String string2 : set) {
                    List<DerivedPropertyProviderAdapter> list = this._typePropertyTupleDerivedProviderMap.lookupTupleValue(string, string2);
                    DataServiceExtensionRegistryImpl.addPropertyProviderInfo(identityHashMap, list, string2);
                }
            }
        }
        finally {
            this._derivedPropertyProviderLock.readLock().unlock();
        }
        return identityHashMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDerivedPropertyProvidersRegisteredTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        this._derivedPropertyProviderLock.readLock().lock();
        try {
            Collection<TypeInfo[]> collection = this._derivedProviderTypeInfoMap.values();
            for (TypeInfo[] typeInfoArray : collection) {
                for (TypeInfo typeInfo : typeInfoArray) {
                    if ("*".equals(typeInfo.type)) continue;
                    hashSet.add(typeInfo.type);
                }
            }
        }
        finally {
            this._derivedPropertyProviderLock.readLock().unlock();
        }
        return hashSet;
    }

    @Override
    public TypeInfo[] getProvidedTypeInfos(PropertyProviderAdapter propertyProviderAdapter) {
        if (propertyProviderAdapter == null) {
            return null;
        }
        if (propertyProviderAdapter instanceof DerivedPropertyProviderAdapter) {
            return this.getProvidedTypeInfosForDerivedPropertyProvider((DerivedPropertyProviderAdapter)propertyProviderAdapter);
        }
        return this.getProvidedTypeInfosForPropertyProvider(propertyProviderAdapter);
    }

    private TypeInfo[] getProvidedTypeInfosForPropertyProvider(PropertyProviderAdapter propertyProviderAdapter) {
        TypeInfo[] typeInfoArray = null;
        this._propertyProviderLock.readLock().lock();
        try {
            typeInfoArray = this._providerTypeInfoMap.get(propertyProviderAdapter);
        }
        finally {
            this._propertyProviderLock.readLock().unlock();
        }
        if (typeInfoArray == null) {
            typeInfoArray = new TypeInfo[]{};
        }
        TypeInfo[] typeInfoArray2 = Arrays.copyOf(typeInfoArray, typeInfoArray.length);
        return typeInfoArray2;
    }

    private TypeInfo[] getProvidedTypeInfosForDerivedPropertyProvider(DerivedPropertyProviderAdapter derivedPropertyProviderAdapter) {
        TypeInfo[] typeInfoArray = null;
        this._derivedPropertyProviderLock.readLock().lock();
        try {
            typeInfoArray = this._derivedProviderTypeInfoMap.get(derivedPropertyProviderAdapter);
        }
        finally {
            this._derivedPropertyProviderLock.readLock().unlock();
        }
        if (typeInfoArray == null) {
            typeInfoArray = new TypeInfo[]{};
        }
        TypeInfo[] typeInfoArray2 = Arrays.copyOf(typeInfoArray, typeInfoArray.length);
        return typeInfoArray2;
    }

    private static DataAdapterInfo toDataAdapterInfo(DataProviderAdapter dataProviderAdapter, TypeInfo[] typeInfoArray, IdentityHashMap<DataProviderAdapter, DataAdapterInfo> identityHashMap) {
        DataAdapterInfo dataAdapterInfo = identityHashMap.get(dataProviderAdapter);
        if (dataAdapterInfo == null) {
            dataAdapterInfo = new DataAdapterInfo();
            dataAdapterInfo.adapter = dataProviderAdapter;
            dataAdapterInfo.typeInfo = typeInfoArray;
        } else {
            int n;
            ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
            boolean bl = false;
            int n2 = 0;
            for (n = 0; n < dataAdapterInfo.typeInfo.length; ++n) {
                for (n2 = 0; n2 < typeInfoArray.length; ++n2) {
                    if (typeInfoArray[n2] == dataAdapterInfo.typeInfo[n]) continue;
                    arrayList.add(typeInfoArray[n2]);
                }
                if (!bl) continue;
                bl = false;
                arrayList.add(typeInfoArray[n2]);
            }
            n = arrayList.size() + dataAdapterInfo.typeInfo.length;
            TypeInfo[] typeInfoArray2 = new TypeInfo[n];
            int n3 = 0;
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                typeInfoArray2[n3] = (TypeInfo)arrayList.get(n3);
            }
            int n4 = 0;
            for (int i = n3; i < dataAdapterInfo.typeInfo.length; ++i) {
                typeInfoArray2[i] = dataAdapterInfo.typeInfo[n4];
                ++n4;
            }
            dataAdapterInfo.typeInfo = typeInfoArray2;
        }
        return dataAdapterInfo;
    }

    private static TypeInfo[] toTypeInfos(String[] stringArray) {
        assert (stringArray != null);
        TypeInfo[] typeInfoArray = new TypeInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            TypeInfo typeInfo;
            String string = stringArray[i];
            typeInfoArray[i] = typeInfo = DataServiceExtensionRegistryImpl.toTypeInfo(string);
        }
        return typeInfoArray;
    }

    private static TypeInfo toTypeInfo(String string) {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = string;
        typeInfo.properties = new String[]{"*"};
        return typeInfo;
    }

    private static void addPropertyProviderInfo(Map<PropertyProviderAdapter, PropertyProviderInfo> map, List<? extends PropertyProviderAdapter> list, String string) {
        for (PropertyProviderAdapter propertyProviderAdapter : list) {
            PropertyProviderInfo propertyProviderInfo = map.get(propertyProviderAdapter);
            if (propertyProviderInfo == null) {
                propertyProviderInfo = new PropertyProviderInfo();
                propertyProviderInfo.propertyProvider = propertyProviderAdapter;
                map.put(propertyProviderAdapter, propertyProviderInfo);
            }
            propertyProviderInfo.providedProperties.add(string);
        }
    }

    private static void logProviderRegistration(String string, TypeInfo[] typeInfoArray) {
        String string2 = " for types & properties: ";
        for (TypeInfo typeInfo : typeInfoArray) {
            string2 = string2 + "\n- " + typeInfo;
        }
        _logger.debug((Object)("Registering property provider " + string + string2));
    }

    private static void removeAdapterFromDynamicAdapterInfo(DataProviderAdapter dataProviderAdapter, IdentityHashSet<DataAdapterInfo> identityHashSet) {
        for (DataAdapterInfo dataAdapterInfo : identityHashSet) {
            if (dataAdapterInfo.adapter != dataProviderAdapter) continue;
            identityHashSet.remove((Object)dataAdapterInfo);
            return;
        }
    }

    private static void removeFromTypeDataAdapterMap(DataProviderAdapter dataProviderAdapter, IdentityHashMap<DataProviderAdapter, DataAdapterInfo> identityHashMap, Map<String, List<DataAdapterInfo>> map) {
        if (dataProviderAdapter == null) {
            return;
        }
        DataAdapterInfo dataAdapterInfo = identityHashMap.get(dataProviderAdapter);
        if (dataAdapterInfo == null) {
            return;
        }
        TypeInfo[] typeInfoArray = dataAdapterInfo.typeInfo;
        for (int i = 0; i < typeInfoArray.length; ++i) {
            String string;
            List<DataAdapterInfo> list;
            TypeInfo typeInfo = typeInfoArray[i];
            if (typeInfo == null || (list = map.get(string = typeInfo.type)) == null) continue;
            boolean bl = list.remove(dataAdapterInfo);
            if (_logger.isDebugEnabled()) {
                String string2 = bl ? ") removed for type: " : ") ALREADY REMOVED for type: ";
                _logger.debug((Object)("Adapter (" + dataProviderAdapter.getClass().getName() + string2 + string));
            }
            if (list.size() != 0) continue;
            map.remove(string);
        }
    }

    private static String createTypePropertyTuple(String string, String string2) {
        if (string == null || string2 == null) {
            return "";
        }
        return string + ":" + string2;
    }

    private static String findUidPrefix(String string, Map<String, ResourceObjectReferenceAdapter> map) {
        assert (string != null);
        String string2 = "";
        for (String string3 : map.keySet()) {
            if (!string.startsWith(string3) || string3.length() <= string2.length()) continue;
            string2 = string3;
        }
        return string2;
    }

    private static void logAdapterRegistration(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            _logger.debug((Object)("Registering dynamic adapter : " + string));
        } else {
            String string2 = " for types: ";
            for (String string3 : stringArray) {
                string2 = string2 + string3 + ", ";
            }
            _logger.debug((Object)("Registering data adapter " + string + string2));
        }
    }

    private static class TypePropertyTupleMap<T> {
        private final Map<Pair<String, String>, T> _typePropertyTupleMap = new HashMap<Pair<String, String>, T>();
        private final Map<Pair<String, String>, T> _templateTupleMap = new HashMap<Pair<String, String>, T>();

        private void assertTypePropertyArgsAreValid(String string, String string2) {
            if (StringUtil.isNullOrEmpty((String)string)) {
                throw new IllegalArgumentException("The 'type' argument shouldn't be empty");
            }
            if (StringUtil.isNullOrEmpty((String)string2)) {
                throw new IllegalArgumentException("The 'property' argument shouldn't be empty");
            }
        }

        public T addTupleValue(String string, String string2, T t) {
            this.assertTypePropertyArgsAreValid(string, string2);
            Pair pair = new Pair((Object)string, (Object)string2, true);
            if (PathTemplate.isTemplate(string2) || PathTemplate.isTemplate(string)) {
                return this._templateTupleMap.put((Pair<String, String>)pair, t);
            }
            return this._typePropertyTupleMap.put((Pair<String, String>)pair, t);
        }

        public void removeTuple(String string, String string2) {
            this.assertTypePropertyArgsAreValid(string, string2);
            Pair pair = new Pair((Object)string, (Object)string2, true);
            T t = this._typePropertyTupleMap.remove(pair);
            if (t == null) {
                this._templateTupleMap.remove(pair);
            }
        }

        public List<T> lookupTupleValue(String string, String string2) {
            Object object;
            this.assertTypePropertyArgsAreValid(string, string2);
            ArrayList<T> arrayList = new ArrayList<T>();
            Pair pair = new Pair((Object)string, (Object)string2, true);
            T t = this._typePropertyTupleMap.get(pair);
            if (t != null) {
                arrayList.add(t);
                return arrayList;
            }
            if (!"*".equals(string2) && (t = this._typePropertyTupleMap.get(object = new Pair((Object)string, (Object)"*"))) != null) {
                arrayList.add(t);
                return arrayList;
            }
            if (!"*".equals(string) && (t = this._typePropertyTupleMap.get(object = new Pair((Object)"*", (Object)string2))) != null) {
                arrayList.add(t);
                return arrayList;
            }
            for (Pair pair2 : this._templateTupleMap.keySet()) {
                if (!PathTemplate.matches((String)pair2.first, (String)pair.first) || !PathTemplate.matches((String)pair2.second, (String)pair.second)) continue;
                T t2 = this._templateTupleMap.get(pair2);
                arrayList.add(t2);
            }
            return arrayList;
        }
    }
}

