/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.impl.DataServiceThreadPoolDecorator;
import com.vmware.vise.data.query.util.Config;
import com.vmware.vise.util.concurrent.ThreadPoolManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataServiceThreadPoolFactory {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceThreadPoolFactory.class);
    private static final long KEEP_ALIVE_TIME_SECONDS = 60L;

    public static ExecutorService newCachedThreadPool(String string, int n, int n2, RejectedExecutionHandler rejectedExecutionHandler) {
        Validate.notEmpty((String)string);
        Validate.isTrue((n >= 0 ? 1 : 0) != 0);
        Validate.isTrue((n2 > 0 ? 1 : 0) != 0);
        Validate.notNull((Object)rejectedExecutionHandler);
        DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory(string);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), defaultThreadFactory, rejectedExecutionHandler);
        ThreadPoolManager.getInstance().register((ExecutorService)threadPoolExecutor);
        int n3 = Config.THREAD_POOL_LOGGABLE_SIZE_CHANGE;
        _logger.info("Created cached thread pool '{}' with core size {} and max size {}. Will log if pool size changes with more than {} threads", new Object[]{string, n, n2, n3});
        return new DataServiceThreadPoolDecorator(threadPoolExecutor, string, n3);
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger createdThreadCount = new AtomicInteger();
        private final String _threadPoolName;

        DefaultThreadFactory(String string) {
            assert (!StringUtils.isEmpty((String)string));
            this._threadPoolName = string;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String string = this._threadPoolName + "-" + this.createdThreadCount.incrementAndGet();
            Thread thread = new Thread(runnable, string);
            return thread;
        }
    }
}

