/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataServiceThreadPoolStats {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceThreadPoolStats.class);
    private final ThreadPoolExecutor _threadPool;
    private final String _threadPoolName;
    private final int _loggableSizeChange;
    private volatile int _sizeSnapshot;

    DataServiceThreadPoolStats(ThreadPoolExecutor threadPoolExecutor, String string, int n) {
        assert (threadPoolExecutor != null);
        assert (string != null);
        this._threadPool = threadPoolExecutor;
        this._threadPoolName = string;
        this._loggableSizeChange = n;
        this._sizeSnapshot = 0;
    }

    void logUsageIfChanged() {
        int n = this._sizeSnapshot;
        int n2 = this._threadPool.getPoolSize();
        if (n2 - this._loggableSizeChange >= n || n - this._loggableSizeChange >= n2) {
            this._sizeSnapshot = n2;
            _logger.info("Thread pool: {}, Core: {}, Max: {}, Size: {}, Active: {}", new Object[]{this._threadPoolName, this._threadPool.getCorePoolSize(), this._threadPool.getMaximumPoolSize(), this._threadPool.getPoolSize(), this._threadPool.getActiveCount()});
        }
    }
}

