/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.IdentifiableGenerationNumber;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.FacetItemComparator;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResultsMerger {
    private static final Logger _logger = LoggerFactory.getLogger(ResultsMerger.class);
    private final MetadataServiceRegistryInternal _metadataServiceRegistry;
    private final ObjectReferenceService _objectReferenceService;
    private final Comparator<PropertyValue> _propertyValueComparator;

    public ResultsMerger(MetadataServiceRegistryInternal metadataServiceRegistryInternal, ObjectReferenceService objectReferenceService) {
        this._metadataServiceRegistry = metadataServiceRegistryInternal;
        this._objectReferenceService = objectReferenceService;
        this._propertyValueComparator = new PropertyValueComparator(objectReferenceService);
    }

    Map<QuerySpec, ResultSetInfo> mergeResultsPerQuery(Map<QuerySpec, List<ResultSetInfo>> map) {
        if (map == null) {
            return null;
        }
        IdentityHashMap<QuerySpec, ResultSetInfo> identityHashMap = new IdentityHashMap<QuerySpec, ResultSetInfo>();
        for (QuerySpec querySpec : map.keySet()) {
            List<ResultSetInfo> list = map.get(querySpec);
            ResultSetInfo resultSetInfo = this.mergeResults(querySpec, list);
            identityHashMap.put(querySpec, resultSetInfo);
        }
        return identityHashMap;
    }

    ResultSetInfo mergeResults(QuerySpec querySpec, List<ResultSetInfo> list) {
        Object object3;
        ArrayList<ResultItem> arrayList;
        Object object2;
        Set<String> set;
        if (list == null || list.size() == 0) {
            return ResultSetInfo.newEmptyResultSetInfo();
        }
        LinkedHashMap<String, ArrayList<ResultItem>> linkedHashMap = new LinkedHashMap<String, ArrayList<ResultItem>>();
        int n = 0;
        ArrayList<Exception> arrayList2 = new ArrayList<Exception>();
        HashSet<ResultSetInfo> hashSet = new HashSet<ResultSetInfo>();
        LinkedHashMap<PropertySpec, Set<FacetValue>> linkedHashMap2 = new LinkedHashMap<PropertySpec, Set<FacetValue>>();
        for (ResultSetInfo object42 : list) {
            if (object42 == null) continue;
            set = object42.getResultSet();
            if (((ResultSet)((Object)set)).error != null) {
                this.addException(((ResultSet)((Object)set)).error, arrayList2);
            }
            this.addToFacetsByPropSpec(linkedHashMap2, ((ResultSet)((Object)set)).facets);
            if (((ResultSet)((Object)set)).totalMatchedObjectCount == null) {
                ((ResultSet)((Object)set)).totalMatchedObjectCount = ((ResultSet)((Object)set)).items != null ? ((ResultSet)((Object)set)).items.length : 0;
            }
            n += ((ResultSet)((Object)set)).totalMatchedObjectCount.intValue();
            if (((ResultSet)((Object)set)).items == null) continue;
            for (ResultItem resultItem : ((ResultSet)((Object)set)).items) {
                object2 = this._objectReferenceService.getUid(resultItem.resourceObject);
                arrayList = (ArrayList<ResultItem>)linkedHashMap.get(object2);
                if (arrayList == null) {
                    arrayList = new ArrayList<ResultItem>();
                    linkedHashMap.put((String)object2, arrayList);
                    hashSet.add(object42);
                }
                arrayList.add(resultItem);
            }
        }
        ResultSet resultSet = new ResultSet();
        resultSet.totalMatchedObjectCount = n;
        resultSet.queryName = querySpec.name;
        List<FacetInfo> list2 = this.getAggregatedFacets(linkedHashMap2);
        for (Object object3 : list2) {
            Arrays.sort(((FacetInfo)object3).facetValues, new FacetItemComparator());
        }
        resultSet.facets = list2.toArray(new FacetInfo[0]);
        if (arrayList2.size() > 0) {
            resultSet.error = arrayList2.size() > 1 ? new CompositeException(arrayList2) : (Exception)arrayList2.get(0);
        }
        set = this.getPrimaryPropertyOrder(querySpec.resourceSpec.propertySpecs);
        object3 = new ArrayList();
        for (String bl2 : linkedHashMap.keySet()) {
            List list3 = (List)linkedHashMap.get(bl2);
            if (list3 == null || list3.size() == 0) continue;
            object2 = (ResultItem)list3.get(0);
            arrayList = ((ResultItem)object2).resourceObject;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = arrayList;
            resultItem.currentGenerations = this.getLowestGeneration(list3);
            resultItem.properties = this.mergeProperties(list3, set);
            object3.add(resultItem);
        }
        resultSet.items = object3.toArray(new ResultItem[0]);
        boolean bl = this.isSorted(hashSet);
        boolean bl2 = this.isPaged(hashSet);
        ResultSetInfo resultSetInfo = ResultSetInfo.getResultSetInfo(resultSet, bl, bl2);
        return resultSetInfo;
    }

    private Set<String> getPrimaryPropertyOrder(PropertySpec[] propertySpecArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (PropertySpec propertySpec : propertySpecArray) {
            if (!StringUtil.isNullOrEmpty((String)propertySpec.relation)) continue;
            for (String string : propertySpec.propertyNames) {
                string = Utils.stripIfEndsWith(string, ".@formatted");
                linkedHashSet.add(string);
            }
        }
        return linkedHashSet;
    }

    private List<FacetInfo> getAggregatedFacets(Map<PropertySpec, Set<FacetValue>> map) {
        ArrayList<FacetInfo> arrayList = new ArrayList<FacetInfo>();
        for (Map.Entry<PropertySpec, Set<FacetValue>> entry : map.entrySet()) {
            FacetInfo facetInfo = new FacetInfo();
            facetInfo.propSpec = entry.getKey();
            facetInfo.facetValues = entry.getValue().toArray(new FacetValue[0]);
            arrayList.add(facetInfo);
        }
        return arrayList;
    }

    private void addToFacetsByPropSpec(Map<PropertySpec, Set<FacetValue>> map, FacetInfo[] facetInfoArray) {
        if (facetInfoArray == null) {
            return;
        }
        for (FacetInfo facetInfo : facetInfoArray) {
            if (map.containsKey(facetInfo.propSpec)) {
                map.get(facetInfo.propSpec).addAll(Arrays.asList(facetInfo.facetValues));
                continue;
            }
            map.put(facetInfo.propSpec, new HashSet<FacetValue>(Arrays.asList(facetInfo.facetValues)));
        }
    }

    private boolean isSorted(Collection<ResultSetInfo> collection) {
        assert (collection != null);
        if (collection.isEmpty()) {
            return true;
        }
        if (collection.size() > 1) {
            return false;
        }
        ResultSetInfo resultSetInfo = collection.iterator().next();
        boolean bl = resultSetInfo.isSorted();
        return bl;
    }

    private boolean isPaged(Collection<ResultSetInfo> collection) {
        assert (collection != null);
        if (collection.isEmpty()) {
            return true;
        }
        if (collection.size() > 1) {
            return false;
        }
        ResultSetInfo resultSetInfo = collection.iterator().next();
        boolean bl = resultSetInfo.isPaged();
        return bl;
    }

    private void addException(Exception exception, List<Exception> list) {
        if (exception instanceof CompositeException) {
            for (Exception exception2 : ((CompositeException)exception).getExceptions()) {
                this.addException(exception2, list);
            }
            return;
        }
        list.add(exception);
    }

    private PropertyValue[] mergeProperties(List<ResultItem> list, Set<String> set) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object object = null;
        HashMap<String, PropertyValue> hashMap = new HashMap<String, PropertyValue>();
        ArrayList<PropertyValue> arrayList = null;
        for (ResultItem resultItem : list) {
            if (object == null) {
                object = resultItem.resourceObject;
            }
            assert (this._objectReferenceService.getUid(object) == null || this._objectReferenceService.getUid(object).equals(this._objectReferenceService.getUid(resultItem.resourceObject)));
            if (resultItem.properties == null) continue;
            for (PropertyValue propertyValue : resultItem.properties) {
                if (propertyValue == null) continue;
                Object object2 = propertyValue.resourceObject;
                String string = propertyValue.propertyName;
                if (object2 == null || object2.equals(object)) {
                    PropertyValue propertyValue2 = (PropertyValue)hashMap.get(string);
                    if (propertyValue2 == null) {
                        hashMap.put(string, propertyValue);
                        continue;
                    }
                    if (!_logger.isDebugEnabled() || propertyValue2.equals(propertyValue)) continue;
                    _logger.debug("Property '{}' for resource '{}' was already provided with value '{}' and the new value '{}' will be ignored.", new Object[]{string, object, propertyValue2, propertyValue});
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<PropertyValue>();
                    arrayList.add(propertyValue);
                    continue;
                }
                int n = Collections.binarySearch(arrayList, propertyValue, this._propertyValueComparator);
                if (n >= 0) continue;
                int n2 = -(n + 1);
                if (n2 >= arrayList.size()) {
                    arrayList.add(propertyValue);
                    continue;
                }
                arrayList.add(n2, propertyValue);
            }
        }
        return this.getOrderedProperties(set, hashMap, arrayList);
    }

    private PropertyValue[] getOrderedProperties(Set<String> set, Map<String, PropertyValue> map, List<PropertyValue> list) {
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (list != null) {
            for (PropertyValue object : list) {
                arrayList.add(object);
            }
        }
        for (String string : set) {
            PropertyValue propertyValue = map.get(string);
            if (propertyValue == null) continue;
            arrayList.add(propertyValue);
        }
        return arrayList.toArray(new PropertyValue[arrayList.size()]);
    }

    private IdentifiableGenerationNumber[] getLowestGeneration(List<ResultItem> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
        for (ResultItem resultItem : list) {
            if (resultItem.currentGenerations == null) continue;
            for (int i = 0; i < resultItem.currentGenerations.length; ++i) {
                Long object;
                if (resultItem.currentGenerations[i].key == null || (object = (Long)hashtable.get(resultItem.currentGenerations[i].key)) != null && (object == null || resultItem.currentGenerations[i].value >= object)) continue;
                hashtable.put(resultItem.currentGenerations[i].key, resultItem.currentGenerations[i].value);
            }
        }
        IdentifiableGenerationNumber[] identifiableGenerationNumberArray = new IdentifiableGenerationNumber[hashtable.size()];
        int n = 0;
        for (Map.Entry entry : hashtable.entrySet()) {
            identifiableGenerationNumberArray[n] = IdentifiableGenerationNumber.newInstance((String)((String)entry.getKey()), (Long)((Long)entry.getValue()));
            ++n;
        }
        return identifiableGenerationNumberArray;
    }

    private class PropertyValueComparator
    implements Comparator<PropertyValue> {
        private final ObjectReferenceService _objectReferenceService;

        public PropertyValueComparator(ObjectReferenceService objectReferenceService) {
            this._objectReferenceService = objectReferenceService;
        }

        @Override
        public int compare(PropertyValue propertyValue, PropertyValue propertyValue2) {
            int n = propertyValue.propertyName.compareTo(propertyValue2.propertyName);
            if (n == 0) {
                String string = this._objectReferenceService.getUid(propertyValue);
                String string2 = this._objectReferenceService.getUid(propertyValue2);
                if (string == null && string2 == null) {
                    return 0;
                }
                if (string == null) {
                    return -1;
                }
                if (string2 == null) {
                    return 1;
                }
                return string.compareTo(string2);
            }
            return n;
        }
    }

    public class ResultsMergerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ResultsMergerException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ResultsMergerException(String string) {
            super(string);
        }
    }
}

