/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.vmware.vise.metadata.ObjectModelProvider;
import com.vmware.vise.metadata.ObjectModelProviderRegistryInternal;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class SubTypeResolver {
    private final ObjectModelProviderRegistryInternal _objectModelProviderRegistry;
    private static final String MANAGED_ENTITY_TYPE = "ManagedEntity";
    private final SetMultimap<String, String> _subTypesByType;

    public SubTypeResolver(ObjectModelProviderRegistryInternal objectModelProviderRegistryInternal) {
        if (objectModelProviderRegistryInternal == null) {
            throw new IllegalArgumentException("objectModelProviderRegistry shouldn't be null");
        }
        this._objectModelProviderRegistry = objectModelProviderRegistryInternal;
        this._subTypesByType = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }

    public Set<String> getSubTypes(String string) {
        Set set = this._subTypesByType.get((Object)string);
        if (set != null) {
            set = Collections.unmodifiableSet(set);
        }
        return set;
    }

    public void updateSubTypes(String string) {
        assert (string != null);
        String[] stringArray = this.getSuperTypes(string);
        if (stringArray == null) {
            return;
        }
        this.updateSubTypes(string, stringArray);
    }

    private void updateSubTypes(String string, String[] stringArray) {
        int n;
        assert (string != null);
        assert (stringArray != null);
        int n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            if (!MANAGED_ENTITY_TYPE.equals(stringArray[n])) continue;
            n2 = n;
            break;
        }
        for (n = n2 - 1; n >= 0; --n) {
            String string2 = stringArray[n];
            for (int i = n - 1; i >= 0; --i) {
                this._subTypesByType.put((Object)string2, (Object)stringArray[i]);
            }
            this._subTypesByType.put((Object)string2, (Object)string);
        }
    }

    private String[] getSuperTypes(String string) {
        List<ObjectModelProvider> list = this._objectModelProviderRegistry.getAllObjectModelProviders();
        if (list == null) {
            return null;
        }
        for (ObjectModelProvider objectModelProvider : list) {
            String[] stringArray = objectModelProvider.getSuperTypes(string);
            if (stringArray == null) continue;
            return stringArray;
        }
        return null;
    }
}

