/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform;

import com.vmware.vise.data.query.transform.TransformationException;
import com.vmware.vise.data.query.transform.Transformer;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TransformUtil {
    private static final Log _logger = LogFactory.getLog(TransformUtil.class);

    private TransformUtil() {
    }

    public static <T> Transformer.Result<T> executeTransformers(Collection<Transformer<T, T>> collection, T t) {
        Transformer.Result<Object> result = new Transformer.Result<T>(t);
        for (Transformer<T, T> transformer : collection) {
            TransformationException transformationException = null;
            Transformer.Result<T> result2 = null;
            boolean bl = false;
            try {
                result2 = transformer.transform(result.getData());
                bl = result.isTransformed() || result2.isTransformed();
                transformationException = TransformUtil.getCompositeError(result.getError(), result2.getError());
            }
            catch (Exception exception) {
                transformationException = TransformUtil.getCompositeError(result.getError(), exception);
                String string = String.format("Invalid transformation for: %1$s", transformer.getClass().getName());
                _logger.error((Object)string, (Throwable)exception);
            }
            Object T2 = result2 == null ? null : (Object)result2.getData();
            result = new Transformer.Result<Object>(T2, bl, transformationException);
        }
        return result;
    }

    public static TransformationException getCompositeError(Exception exception, Exception exception2) {
        if (exception == null) {
            return TransformUtil.newTransformationException(exception2);
        }
        if (exception2 == null) {
            return TransformUtil.newTransformationException(exception);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(exception.getMessage()).append(';').append(exception2.getMessage());
        TransformationException transformationException = new TransformationException(stringBuilder.toString());
        return transformationException;
    }

    private static TransformationException newTransformationException(Exception exception) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof TransformationException) {
            return (TransformationException)exception;
        }
        return new TransformationException(exception);
    }
}

