/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform;

import com.vmware.vise.data.query.transform.TransformUtil;
import com.vmware.vise.data.query.transform.TransformationException;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import com.vmware.vise.util.collection.TreeIterator;

public class TreeTransformer<T>
implements Transformer<Tree<T>, Tree<T>> {
    private final Transformer<Node<T>, Node<T>> _transformer;

    public TreeTransformer(Transformer<Node<T>, Node<T>> transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Invalid transformer.");
        }
        this._transformer = transformer;
    }

    @Override
    public Transformer.Result<Tree<T>> transform(Tree<T> tree) {
        boolean bl = false;
        TransformationException transformationException = null;
        TreeIterator treeIterator = tree.iterator();
        while (treeIterator.hasNext()) {
            Node node = (Node)treeIterator.next();
            Transformer.Result<Node<T>> result = this.transformNode(treeIterator, node);
            bl = bl || result.isTransformed();
            transformationException = TransformUtil.getCompositeError(transformationException, result.getError());
        }
        return new Transformer.Result<Tree<T>>(tree, bl, transformationException);
    }

    private Transformer.Result<Node<T>> transformNode(TreeIterator<T> treeIterator, Node<T> node) {
        Transformer.Result<Node<T>> result = this._transformer.transform(node);
        Node<T> node2 = result.getData();
        if (result.isTransformed()) {
            treeIterator.set(node2);
        }
        return result;
    }
}

