/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.impl.ComponentPropertyRetriever;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.util.ArrayUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class CustomPropertyOrderTransformer
implements Transformer<OrderingCriteria, OrderingCriteria> {
    private final ComponentPropertyRetriever _componentPropertyRetriever;

    public CustomPropertyOrderTransformer(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal) {
        this._componentPropertyRetriever = new ComponentPropertyRetriever(dataServiceExtensionRegistryInternal);
    }

    @Override
    public Transformer.Result<OrderingCriteria> transform(OrderingCriteria orderingCriteria) {
        if (orderingCriteria == null) {
            return new Transformer.Result<OrderingCriteria>(orderingCriteria, false, null);
        }
        OrderingCriteria orderingCriteria2 = this.getModifiedOrderingCriteria(orderingCriteria);
        boolean bl = !orderingCriteria2.equals(orderingCriteria);
        return new Transformer.Result<OrderingCriteria>(orderingCriteria2, bl, null);
    }

    private OrderingCriteria getModifiedOrderingCriteria(OrderingCriteria orderingCriteria) {
        if (ArrayUtil.isNullOrEmpty((Object[])orderingCriteria.orderingProperties)) {
            return orderingCriteria;
        }
        OrderingPropertySpec[] orderingPropertySpecArray = new OrderingPropertySpec[orderingCriteria.orderingProperties.length];
        boolean bl = false;
        int n = 0;
        for (OrderingPropertySpec orderingPropertySpec : orderingCriteria.orderingProperties) {
            String string = orderingPropertySpec.type;
            HashSet<String> hashSet = new HashSet<String>(orderingPropertySpec.propertyNames.length);
            Collections.addAll(hashSet, orderingPropertySpec.propertyNames);
            Set<String> set = this._componentPropertyRetriever.getComponentProperties(orderingPropertySpec.type, hashSet);
            OrderingPropertySpec orderingPropertySpec2 = orderingPropertySpec;
            if (!hashSet.containsAll(set)) {
                bl = true;
                orderingPropertySpec2 = Utils.newOrderingPropertySpec(string, set.toArray(new String[0]), null, orderingPropertySpec.orderingType);
            }
            orderingPropertySpecArray[n++] = orderingPropertySpec2;
        }
        if (!bl) {
            return orderingCriteria;
        }
        OrderingCriteria orderingCriteria2 = new OrderingCriteria();
        orderingCriteria2.orderingProperties = orderingPropertySpecArray;
        return orderingCriteria2;
    }
}

