/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EnumPropertyConstraintTransformer
implements Transformer<Constraint, Constraint> {
    private static final Log _logger = LogFactory.getLog(EnumPropertyConstraintTransformer.class);
    private final MetadataServiceRegistryInternal _metadataRegistry;

    public EnumPropertyConstraintTransformer(MetadataServiceRegistryInternal metadataServiceRegistryInternal) {
        this._metadataRegistry = metadataServiceRegistryInternal;
    }

    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof PropertyConstraint)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
        if (StringUtil.isNullOrEmpty((String)propertyConstraint.targetType) || StringUtil.isNullOrEmpty((String)propertyConstraint.propertyName)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        Constraint constraint2 = this.getEquivalentConstraint(propertyConstraint);
        boolean bl = !constraint2.equals(constraint);
        return new Transformer.Result<Constraint>(constraint2, bl, null);
    }

    private PropertyDescriptor getPropertyDescriptor(PropertyConstraint propertyConstraint) {
        PropertyDescriptor[] propertyDescriptorArray;
        String string = propertyConstraint.targetType;
        String string2 = propertyConstraint.propertyName;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = this._metadataRegistry.lookUpPropertyDescriptors(string)) {
            if (!propertyDescriptor.name.equals(string2) && !ArrayUtil.contains((Object)string2, (Object[])propertyDescriptor.aliases).booleanValue()) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private Constraint getEquivalentConstraint(PropertyConstraint propertyConstraint) {
        if (!EnumPropertyConstraintTransformer.isContainsTypeComparator(propertyConstraint.comparator) || propertyConstraint.comparableValue == null) {
            return propertyConstraint;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyConstraint);
        if (propertyDescriptor == null) {
            return propertyConstraint;
        }
        EnumTranslator enumTranslator = new EnumTranslator(propertyDescriptor);
        String string = propertyConstraint.comparableValue.toString();
        List<String> list = enumTranslator.getMatchingValues(string);
        if (list.isEmpty()) {
            return propertyConstraint;
        }
        ArrayList<PropertyConstraint> arrayList = new ArrayList<PropertyConstraint>(list.size());
        for (String object2 : list) {
            PropertyConstraint propertyConstraint2 = EnumPropertyConstraintTransformer.newPropertyConstraint(propertyConstraint, object2);
            propertyConstraint2.comparator = Comparator.EQUALS;
            arrayList.add(propertyConstraint2);
        }
        if (arrayList.size() == 1) {
            return (Constraint)arrayList.get(0);
        }
        Constraint[] constraintArray = arrayList.toArray(new Constraint[arrayList.size()]);
        Constraint constraint = QueryUtil.combineIntoSingleConstraint(constraintArray, Conjoiner.OR);
        return constraint;
    }

    private static boolean isContainsTypeComparator(Comparator comparator) {
        return comparator == Comparator.TEXTUALLY_MATCHES || comparator == Comparator.CONTAINS;
    }

    private static PropertyConstraint newPropertyConstraint(PropertyConstraint propertyConstraint, String string) {
        PropertyConstraint propertyConstraint2 = (PropertyConstraint)ObjectUtil.shallowCopy((Object)propertyConstraint, PropertyConstraint.class);
        propertyConstraint2.comparableValue = string;
        return propertyConstraint2;
    }

    private static class EnumTranslator {
        private final PropertyDescriptor _propertyDescriptor;

        public EnumTranslator(PropertyDescriptor propertyDescriptor) {
            this._propertyDescriptor = propertyDescriptor;
        }

        public List<String> getMatchingValues(String string) {
            if (StringUtil.isNullOrEmpty((String)string)) {
                return Collections.emptyList();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            XSFacet[] xSFacetArray = this._propertyDescriptor.staticValueSpace;
            if (xSFacetArray != null) {
                for (XSFacet xSFacet : xSFacetArray) {
                    String string2;
                    if (xSFacet.type != XSFacetType.ENUMERATION || !(xSFacet.value instanceof NameValuePair)) continue;
                    NameValuePair nameValuePair = (NameValuePair)xSFacet.value;
                    if (nameValuePair.value == null || StringUtil.isNullOrEmpty((String)(string2 = nameValuePair.name))) continue;
                    Locale locale = ResourceUtil.getLocale();
                    if (locale == null) {
                        _logger.warn((Object)("Null locale while getting matching values for: " + string));
                        continue;
                    }
                    if (!string2.toLowerCase(locale).contains(string.toLowerCase(locale))) continue;
                    arrayList.add(nameValuePair.value.toString());
                }
            }
            return arrayList;
        }
    }
}

