/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.ConstraintTree;
import com.vmware.vise.data.query.transform.TransformUtil;
import com.vmware.vise.data.query.transform.TransformationException;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.data.query.transform.TreeTransformer;
import com.vmware.vise.data.query.transform.impl.DataTransformerImpl;
import com.vmware.vise.data.query.transform.impl.PropertyValueSubstitutionTransformer;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuerySpecTransformer
implements Transformer<QuerySpec, QuerySpec> {
    private final Logger _logger = LoggerFactory.getLogger(DataTransformerImpl.class);
    private final PropertyValueSubstitutionTransformer _propertyValueSubstitutionTransformer = new PropertyValueSubstitutionTransformer();
    private final Set<Transformer<Constraint, Constraint>> _constraintTransformers = new LinkedHashSet<Transformer<Constraint, Constraint>>();
    private final Set<Transformer<PropertySpec, PropertySpec>> _propertySpecTransformers = new LinkedHashSet<Transformer<PropertySpec, PropertySpec>>();
    private final Set<Transformer<OrderingCriteria, OrderingCriteria>> _orderingCriteriaTransformers = new LinkedHashSet<Transformer<OrderingCriteria, OrderingCriteria>>();

    public void registerConstraintTransformer(Transformer<Constraint, Constraint> transformer) {
        this._constraintTransformers.add(transformer);
    }

    public void unregisterConstraintTransformer(Transformer<Constraint, Constraint> transformer) {
        this._constraintTransformers.remove(transformer);
    }

    public void registerPropertySpecTransformer(Transformer<PropertySpec, PropertySpec> transformer) {
        this._propertySpecTransformers.add(transformer);
    }

    public void unregisterPropertySpecTransformer(Transformer<PropertySpec, PropertySpec> transformer) {
        this._propertySpecTransformers.remove(transformer);
    }

    public void registerOrderingTransformer(Transformer<OrderingCriteria, OrderingCriteria> transformer) {
        this._orderingCriteriaTransformers.add(transformer);
    }

    public void unregisterOrderingTransformer(Transformer<OrderingCriteria, OrderingCriteria> transformer) {
        this._orderingCriteriaTransformers.remove(transformer);
    }

    @Override
    public Transformer.Result<QuerySpec> transform(QuerySpec querySpec) {
        try {
            QuerySpec querySpec2 = querySpec.clone();
            ResourceSpecTransformer resourceSpecTransformer = new ResourceSpecTransformer();
            Transformer.Result result = resourceSpecTransformer.transform(querySpec2.resourceSpec);
            ResultSpecTransformer resultSpecTransformer = new ResultSpecTransformer();
            Transformer.Result result2 = resultSpecTransformer.transform(querySpec2.resultSpec);
            boolean bl = result.isTransformed() || result2.isTransformed();
            TransformationException transformationException = TransformUtil.getCompositeError(result.getError(), result2.getError());
            QuerySpec querySpec3 = querySpec;
            if (bl) {
                ResourceSpec resourceSpec = (ResourceSpec)result.getData();
                querySpec3 = new QuerySpec(querySpec2);
                querySpec3.name = "transformed-" + querySpec2.name;
                querySpec3.resourceSpec = resourceSpec;
                querySpec3.resultSpec = (ResultSpec)result2.getData();
            }
            return new Transformer.Result<QuerySpec>(querySpec3, bl, transformationException);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this._logger.warn("Error has occurred while transforming query: " + querySpec.name, (Throwable)cloneNotSupportedException);
            return new Transformer.Result<QuerySpec>(querySpec);
        }
    }

    public class ResultSpecTransformer
    implements Transformer<ResultSpec, ResultSpec> {
        @Override
        public Transformer.Result<ResultSpec> transform(ResultSpec resultSpec) {
            if (resultSpec == null) {
                return new Transformer.Result<Object>(null, false);
            }
            Transformer.Result<OrderingCriteria> result = TransformUtil.executeTransformers(QuerySpecTransformer.this._orderingCriteriaTransformers, resultSpec.order);
            Transformer.Result<FacetSpec[]> result2 = this.transformFacetSpecs(resultSpec.facets);
            ResultSpec resultSpec2 = resultSpec;
            boolean bl = result.isTransformed() || result2.isTransformed();
            TransformationException transformationException = TransformUtil.getCompositeError(result.getError(), result2.getError());
            if (bl) {
                resultSpec2 = new ResultSpec();
                resultSpec2.offset = resultSpec.offset;
                resultSpec2.maxResultCount = resultSpec.maxResultCount;
                resultSpec2.order = result.getData();
                resultSpec2.facets = result2.getData();
            }
            return new Transformer.Result<ResultSpec>(resultSpec2, bl, transformationException);
        }

        private Transformer.Result<FacetSpec[]> transformFacetSpecs(FacetSpec[] facetSpecArray) {
            FacetSpec[] facetSpecArray2 = null;
            boolean bl = false;
            TransformationException transformationException = null;
            if (facetSpecArray != null && facetSpecArray.length > 0) {
                facetSpecArray2 = new FacetSpec[facetSpecArray.length];
                for (int i = 0; i < facetSpecArray.length; ++i) {
                    Transformer.Result<PropertySpec> result = TransformUtil.executeTransformers(QuerySpecTransformer.this._propertySpecTransformers, facetSpecArray[i].propSpec);
                    transformationException = TransformUtil.getCompositeError(transformationException, result.getError());
                    if (result.isTransformed()) {
                        FacetSpec facetSpec = new FacetSpec();
                        facetSpec.propSpec = result.getData();
                        facetSpecArray2[i] = facetSpec;
                        bl = true;
                        continue;
                    }
                    facetSpecArray2[i] = facetSpecArray[i];
                }
            }
            if (!bl) {
                facetSpecArray2 = facetSpecArray;
            }
            return new Transformer.Result<FacetSpec[]>(facetSpecArray2, bl, transformationException);
        }
    }

    public class ResourceSpecTransformer
    implements Transformer<ResourceSpec, ResourceSpec> {
        @Override
        public Transformer.Result<ResourceSpec> transform(ResourceSpec resourceSpec) {
            boolean bl;
            if (resourceSpec == null || resourceSpec.constraint == null) {
                throw new IllegalArgumentException("Invalid input query.");
            }
            Transformer.Result<Constraint> result = this.transformConstraint(resourceSpec.constraint);
            Transformer.Result<PropertySpec[]> result2 = this.transformPropertySpecs(resourceSpec.propertySpecs);
            ResourceSpec resourceSpec2 = resourceSpec;
            TransformationException transformationException = TransformUtil.getCompositeError(result.getError(), result2.getError());
            boolean bl2 = bl = result.isTransformed() || result2.isTransformed();
            if (bl) {
                resourceSpec2 = new ResourceSpec();
                resourceSpec2.constraint = result.getData();
                resourceSpec2.propertySpecs = result2.getData();
            }
            return new Transformer.Result<ResourceSpec>(resourceSpec2, bl, transformationException);
        }

        private Transformer.Result<Constraint> transformConstraint(Constraint constraint) {
            if (constraint == null) {
                return new Transformer.Result<Object>(null);
            }
            Transformer.Result<Tree<Constraint>> result = this.executePerNodeTransformers(constraint);
            Constraint constraint2 = (Constraint)result.getData().getRoot().getData();
            Transformer.Result<Constraint> result2 = this.executePerTreeTransformers(constraint2);
            boolean bl = result.isTransformed() || result2.isTransformed();
            TransformationException transformationException = TransformUtil.getCompositeError(result.getError(), result2.getError());
            return new Transformer.Result<Constraint>(result2.getData(), bl, transformationException);
        }

        private Transformer.Result<Constraint> executePerTreeTransformers(Constraint constraint) {
            return QuerySpecTransformer.this._propertyValueSubstitutionTransformer.transform(constraint);
        }

        private Transformer.Result<Tree<Constraint>> executePerNodeTransformers(Constraint constraint) {
            ConstraintTree constraintTree = new ConstraintTree(constraint);
            Transformer<Node<Constraint>, Node<Constraint>> transformer = new Transformer<Node<Constraint>, Node<Constraint>>(){

                @Override
                public Transformer.Result<Node<Constraint>> transform(Node<Constraint> node) {
                    Transformer.Result<Object> result = TransformUtil.executeTransformers(QuerySpecTransformer.this._constraintTransformers, node.getData());
                    Constraint constraint = (Constraint)result.getData();
                    ConstraintTree.ConstraintNode constraintNode = new ConstraintTree.ConstraintNode(constraint);
                    return new Transformer.Result<Node<Constraint>>(constraintNode, result.isTransformed(), result.getError());
                }
            };
            TreeTransformer<Constraint> treeTransformer = new TreeTransformer<Constraint>(transformer);
            Transformer.Result<Tree<Constraint>> result = treeTransformer.transform(constraintTree);
            return result;
        }

        private Transformer.Result<PropertySpec[]> transformPropertySpecs(PropertySpec[] propertySpecArray) {
            PropertySpec[] propertySpecArray2 = null;
            TransformationException transformationException = null;
            boolean bl = false;
            if (!ArrayUtil.isNullOrEmpty((Object[])propertySpecArray)) {
                propertySpecArray2 = new PropertySpec[propertySpecArray.length];
                for (int i = 0; i < propertySpecArray.length; ++i) {
                    Transformer.Result<PropertySpec> result = TransformUtil.executeTransformers(QuerySpecTransformer.this._propertySpecTransformers, propertySpecArray[i]);
                    transformationException = TransformUtil.getCompositeError(transformationException, result.getError());
                    if (result.isTransformed()) {
                        propertySpecArray2[i] = result.getData();
                        bl = true;
                        continue;
                    }
                    propertySpecArray2[i] = propertySpecArray[i];
                }
            }
            if (!bl) {
                propertySpecArray2 = propertySpecArray;
            }
            return new Transformer.Result<PropertySpec[]>(propertySpecArray2, bl, transformationException);
        }
    }
}

