/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    public static final int THREAD_POOL_CORE_SIZE;
    public static final int THREAD_POOL_MAXIMUM_SIZE;
    public static final int THREAD_POOL_LOGGABLE_SIZE_CHANGE;
    public static final long QUERY_BATCH_TIME_THRESHOLD;
    public static final long DATA_PROVIDER_ADAPTER_TIME_THRESHOLD;
    public static final long PROPERTY_PROVIDER_ADAPTER_TIME_THRESHOLD;
    public static final long PROPERTY_PROVIDER_BEAN_METHOD_TIME_THRESHOLD;

    private static int getIntProperty(Properties properties, String string, int n) {
        int n2 = n;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                _logger.error((Object)("The property " + string + " cannot be parsed to int. Will use the default value: " + n), (Throwable)numberFormatException);
            }
        }
        return n2;
    }

    private static long getLongProperty(Properties properties, String string, long l) {
        long l2 = l;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                l2 = Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                _logger.error((Object)("The property " + string + " cannot be parsed to long. Will use the default value: " + l), (Throwable)numberFormatException);
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties properties = new Properties();
        ClassLoader classLoader = Config.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("data-services-framework.properties");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                _logger.error((Object)"Failed to load the Data Service configuration properties", (Throwable)iOException);
            }
            finally {
                StreamUtil.close((Closeable)inputStream);
            }
        } else {
            _logger.warn((Object)"Data Service config.properties file not found. Will use defaults.");
        }
        THREAD_POOL_CORE_SIZE = Config.getIntProperty(properties, "adapters.threadPool.coreSize", 200);
        THREAD_POOL_MAXIMUM_SIZE = Config.getIntProperty(properties, "adapters.threadPool.maximumSize", 500);
        THREAD_POOL_LOGGABLE_SIZE_CHANGE = Config.getIntProperty(properties, "adapters.threadPool.loggableSizeChange", 100);
        QUERY_BATCH_TIME_THRESHOLD = Config.getLongProperty(properties, "profiling.queryBatchTimeThreshold", 5000L);
        DATA_PROVIDER_ADAPTER_TIME_THRESHOLD = Config.getLongProperty(properties, "profiling.dataAdapterTimeThreshold", 4000L);
        PROPERTY_PROVIDER_ADAPTER_TIME_THRESHOLD = Config.getLongProperty(properties, "profiling.propertyProviderAdapterTimeThreshold", 4000L);
        PROPERTY_PROVIDER_BEAN_METHOD_TIME_THRESHOLD = Config.getLongProperty(properties, "profiling.propertyProviderBeanMethodTimeThreshold", 4000L);
    }
}

