/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.Pair;

public class PropertyConstraintCompUtil {
    public static boolean matchValues(Object object, Object object2, Comparator comparator) {
        switch (comparator) {
            case EQUALS: {
                return ObjectUtil.objectsEqual((Object)object, (Object)object2);
            }
            case NOT_EQUALS: {
                return !ObjectUtil.objectsEqual((Object)object, (Object)object2);
            }
            case EQUALS_ANY_OF: {
                return ObjectUtil.equalsAnyOf((Object)object, (Object)object2);
            }
            case GREATER: {
                return PropertyConstraintCompUtil.greaterThan(object, object2);
            }
            case SMALLER: {
                return PropertyConstraintCompUtil.smallerThan(object, object2);
            }
            case STARTS_WITH: {
                return ObjectUtil.startsWith((Object)object, (Object)object2);
            }
            case ENDS_WITH: {
                return ObjectUtil.endsWith((Object)object, (Object)object2);
            }
            case CONTAINS: {
                return ObjectUtil.contains((Object)object, (Object)object2);
            }
            case CONTAINS_ANY_OF: {
                return ObjectUtil.containsAnyOf((Object)object, (Object)object2);
            }
            case MATCHES: 
            case TEXTUALLY_MATCHES: {
                return ObjectUtil.matches((Object)object, (Object)object2);
            }
            case RANGES_BETWEEN: {
                return PropertyConstraintCompUtil.rangesBetween(object, object2);
            }
        }
        throw new UnsupportedOperationException("Unsupported comparator: " + (Object)((Object)comparator));
    }

    private static boolean greaterThan(Object object, Object object2) {
        try {
            int n = ObjectUtil.compare((Object)object, (Object)object2);
            return n > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean smallerThan(Object object, Object object2) {
        try {
            int n = ObjectUtil.compare((Object)object, (Object)object2);
            return n < 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean rangesBetween(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        if (object2 instanceof Pair) {
            Pair pair = (Pair)object2;
            Object object3 = pair.first;
            Object object4 = pair.second;
            if (object3 != null) {
                if (object.equals(object3)) {
                    return true;
                }
                if (PropertyConstraintCompUtil.smallerThan(object, object3)) {
                    return false;
                }
            }
            if (object4 != null) {
                if (object.equals(object4)) {
                    return true;
                }
                if (PropertyConstraintCompUtil.greaterThan(object, object4)) {
                    return false;
                }
            }
            return true;
        }
        throw new UnsupportedOperationException("The range operation works only if the range is specified with a " + Pair.class.getName());
    }
}

