/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import java.util.Comparator;

public final class ResultItemComparator
implements Comparator<ResultItem> {
    private final OrderingCriteria _orderingCriteria;

    public ResultItemComparator(OrderingCriteria orderingCriteria) {
        this._orderingCriteria = orderingCriteria;
    }

    @Override
    public int compare(ResultItem resultItem, ResultItem resultItem2) {
        if (this._orderingCriteria == null || ArrayUtil.isNullOrEmpty((Object[])this._orderingCriteria.orderingProperties)) {
            return 0;
        }
        for (OrderingPropertySpec orderingPropertySpec : this._orderingCriteria.orderingProperties) {
            boolean bl = this.isOrderingAscending(orderingPropertySpec);
            for (String string : orderingPropertySpec.propertyNames) {
                int n = 0;
                n = Utils.isObjectIdProperty(orderingPropertySpec.type, string) ? this.compareResourceObjects(resultItem, resultItem2) : this.compareOrderingProperties(resultItem, resultItem2, string);
                if (n == 0) continue;
                return bl ? n : -n;
            }
        }
        return 0;
    }

    private int compareResourceObjects(ResultItem resultItem, ResultItem resultItem2) {
        boolean bl = this.isResourceObjectNull(resultItem);
        boolean bl2 = this.isResourceObjectNull(resultItem2);
        if (bl || bl2) {
            return bl == bl2 ? 0 : (bl ? -1 : 1);
        }
        return this.compareTo(resultItem.resourceObject, resultItem2.resourceObject);
    }

    private int compareOrderingProperties(ResultItem resultItem, ResultItem resultItem2, String string) {
        PropertyValue propertyValue = ResultUtil.getPropertyValue(resultItem, string);
        PropertyValue propertyValue2 = ResultUtil.getPropertyValue(resultItem2, string);
        boolean bl = this.isValueNull(propertyValue);
        boolean bl2 = this.isValueNull(propertyValue2);
        if (bl || bl2) {
            return bl == bl2 ? 0 : (bl ? -1 : 1);
        }
        return this.compareTo(propertyValue.value, propertyValue2.value);
    }

    private int compareTo(Object object, Object object2) {
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
        if (object instanceof Comparable && ResultItemComparator.areOfSameClass(object, object2)) {
            return ((Comparable)object).compareTo(object2);
        }
        return object.toString().compareToIgnoreCase(object2.toString());
    }

    private static boolean areOfSameClass(Object object, Object object2) {
        return object.getClass().equals(object2.getClass());
    }

    private boolean isValueNull(PropertyValue propertyValue) {
        return propertyValue == null || propertyValue.value == null;
    }

    private boolean isResourceObjectNull(ResultItem resultItem) {
        return resultItem == null || resultItem.resourceObject == null;
    }

    private boolean isOrderingAscending(OrderingPropertySpec orderingPropertySpec) {
        return orderingPropertySpec.orderingType == null || orderingPropertySpec.orderingType == SortType.ASCENDING;
    }
}

