/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.PropertyChangeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.ResultAnalyzer;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryExecutorImpl
implements QueryExecutor {
    private static final Logger _logger = LoggerFactory.getLogger(QueryExecutorImpl.class);
    public static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    public static final ResultSet[] EMPTYSET = new ResultSet[0];
    private final DataService _dataService;
    private final ObjectReferenceService _objectReferenceService;
    private final QuerySpecBuilder _querySpecBuilder;
    private final ResultAnalyzer _resultAnalyzer;

    public QueryExecutorImpl(DataService dataService, ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, ResultAnalyzer resultAnalyzer) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataService, objectReferenceService, querySpecBuilder, resultAnalyzer});
        this._dataService = dataService;
        this._objectReferenceService = objectReferenceService;
        this._querySpecBuilder = querySpecBuilder;
        this._resultAnalyzer = resultAnalyzer;
    }

    @Override
    public <T> T getProperty(Object object, String string) throws Exception {
        PropertyValue[] propertyValueArray;
        if (object == null || StringUtil.isNullOrEmpty((String)string)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        for (PropertyValue propertyValue : propertyValueArray = this.getProperties(object, new String[]{string})) {
            if (propertyValue == null || propertyValue.propertyName == null || !propertyValue.propertyName.equals(string)) continue;
            return (T)propertyValue.value;
        }
        return null;
    }

    @Override
    public PropertyValue[] getProperty(Object[] objectArray, String string) throws Exception {
        return this.getProperties(objectArray, new String[]{string});
    }

    @Override
    public PropertyValue[] getProperties(Object object, String[] stringArray) throws Exception {
        return this.getProperties(new Object[]{object}, stringArray);
    }

    @Override
    public PropertyValue[] getProperties(Object[] objectArray, String[] stringArray) throws Exception {
        ResultItem[] resultItemArray;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        Object object = objectArray[0];
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(objectArray, stringArray);
        querySpec.name = this._objectReferenceService.getUid(object) + ".properties";
        ResultSet resultSet = this.getData(querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0 && resultItemArray[0] != null) {
            for (ResultItem resultItem : resultItemArray) {
                for (PropertyValue propertyValue : resultItem.properties) {
                    propertyValue.resourceObject = resultItem.resourceObject;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(arrayList, PropertyValue.class);
    }

    @Override
    public PropertyValue[] getPropertyForRelatedObjects(Object object, String string, String string2, String string3) throws Exception {
        return this.getPropertiesForRelatedObjects(object, string, string2, new String[]{string3});
    }

    @Override
    public PropertyValue[] getPropertiesForRelatedObjects(Object object, String string, String string2, String[] stringArray) throws Exception {
        if (object == null || ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            return this.getProperties(object, stringArray);
        }
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = this._querySpecBuilder.createRelationalConstraint(string, objectIdentityConstraint, true, string2);
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(relationalConstraint, stringArray);
        querySpec.name = this._objectReferenceService.getUid(object) + "." + string + ".properties";
        ResultSet resultSet = this.getData(querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem == null || resultItem.properties == null) continue;
                for (PropertyValue propertyValue : resultItem.properties) {
                    if (propertyValue == null) continue;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(arrayList, PropertyValue.class);
    }

    @Override
    public ResultSet getData(QuerySpec querySpec) throws Exception {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = new Response();
        response = this._dataService.getData(requestSpec);
        Object[] objectArray = response.resultSet;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || objectArray[0] == null) {
            throw new Exception(Utils.getLocalizedString("error.emptyResult"));
        }
        return objectArray[0];
    }

    @Override
    public Boolean waitUntilSearchable(Object object, String[] stringArray) {
        return this.waitUntilStatusChange(object, stringArray, true);
    }

    @Override
    public Boolean waitUntilSearchable(Object object) {
        return this.waitUntilSearchable(object, new String[]{"name"});
    }

    @Override
    public Boolean waitUntilNotSearchable(Object object, String[] stringArray) {
        return this.waitUntilStatusChange(object, stringArray, false);
    }

    @Override
    public Boolean waitUntilNotSearchable(Object object) {
        return this.waitUntilNotSearchable(object, new String[]{"name"});
    }

    @Override
    public Boolean waitUntilStatusChange(Object object, String[] stringArray, boolean bl) {
        PropertyValue[] propertyValueArray = null;
        boolean bl2 = false;
        for (int i = 0; i < 30; ++i) {
            try {
                propertyValueArray = this.getProperties(object, stringArray);
                boolean bl3 = this._resultAnalyzer.checkProperties(propertyValueArray, stringArray);
                if (bl && bl3) {
                    bl2 = true;
                    break;
                }
                if (!bl && !bl3) {
                    bl2 = true;
                    break;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                _logger.error(exception.getLocalizedMessage());
            }
        }
        return bl2;
    }

    @Override
    public Boolean waitUntilPropertyChanged(Object object, PropertyChangeInfo propertyChangeInfo) throws Exception {
        String string = propertyChangeInfo.getPropertyName();
        boolean bl = false;
        _logger.debug("Start waiting for change in property '" + string + "' on object " + this._objectReferenceService.getUid(object));
        for (int i = 0; i < 30; ++i) {
            Object t = this.getProperty(object, string);
            bl = propertyChangeInfo.isChanged(t);
            if (bl) {
                _logger.debug("Property '" + string + "' on object " + this._objectReferenceService.getUid(object) + " has changed!");
                break;
            }
            _logger.debug("No change detected for property '" + string + "' on object " + this._objectReferenceService.getUid(object));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                _logger.error(exception.getLocalizedMessage());
            }
        }
        return bl;
    }
}

