/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.uri;

import com.vmware.vise.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;

public final class DefaultUriSchemeUtil {
    static final String PREFIX = "urn:vri";
    private static final char TYPE_DELIMITER = ':';
    private static final char NSS_DELIMITER = ':';
    private static final String PREFIX_PLUS_NSS_DELIMITER = "urn:vri:";
    private static final String ID_SEGMENT_DELIMITER = "/";
    static final char ESCAPE_CHAR = '!';
    static final char ESCAPE_CHAR_FOR_DELIMITER = '_';

    public static URI createUri(String string, String string2) {
        URI uRI;
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("The type of the resource that the URI identifies should be specified!");
        }
        if (StringUtil.isNullOrEmpty((String)string2)) {
            throw new IllegalArgumentException("The resource identification part of the URI should be specified!");
        }
        string2 = DefaultUriSchemeUtil.escapeUriComponent(string2);
        try {
            uRI = new URI(PREFIX, string + ':' + string2, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        return uRI;
    }

    public static URI createUri(String string, String[] stringArray) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("The type of the URI should be specified!");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("The idSegments of the URI should be specified!");
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray.length);
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(ID_SEGMENT_DELIMITER);
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        URI uRI = DefaultUriSchemeUtil.createUri(string, stringBuffer.toString());
        return uRI;
    }

    public static String getType(URI uRI) {
        return DefaultUriSchemeUtil.parseSchemeSpecificPart(uRI, true);
    }

    public static String getId(URI uRI) {
        String string = DefaultUriSchemeUtil.parseSchemeSpecificPart(uRI, false);
        string = DefaultUriSchemeUtil.unescapeUriComponent(string);
        return string;
    }

    public static String[] getIdSegments(URI uRI) {
        String string = DefaultUriSchemeUtil.getId(uRI);
        int n = string.indexOf(ID_SEGMENT_DELIMITER);
        if (n == -1) {
            return new String[]{string};
        }
        return string.split(ID_SEGMENT_DELIMITER);
    }

    private static String parseSchemeSpecificPart(URI uRI, boolean bl) {
        DefaultUriSchemeUtil.checkValid(uRI);
        String string = uRI.getSchemeSpecificPart();
        string = string.substring(string.indexOf(58) + 1);
        int n = string.lastIndexOf(58);
        if (n == -1) {
            throw new IllegalArgumentException("The provided URI does not contain valid type delimiter.");
        }
        String string2 = bl ? string.substring(0, n) : string.substring(n + 1);
        return string2;
    }

    private static void checkValid(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("The provided URI is null");
        }
        if (!uRI.toString().startsWith(PREFIX_PLUS_NSS_DELIMITER)) {
            throw new IllegalArgumentException("The provided URI doesn't use the default scheme: urn:vri:");
        }
    }

    static String escapeUriComponent(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        if (string.indexOf(33) < 0 && string.indexOf(58) < 0) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 10);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                stringBuilder.append('!').append('_');
                continue;
            }
            if (c == '!') {
                stringBuilder.append('!').append('!');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static String unescapeUriComponent(String string) {
        int n;
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        if (string.indexOf(33) < 0) {
            return string;
        }
        int n2 = string.length() - 1;
        StringBuilder stringBuilder = new StringBuilder(n2 + 10);
        block4: for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c != '!') {
                stringBuilder.append(c);
                continue;
            }
            char c2 = string.charAt(++n);
            switch (c2) {
                case '_': {
                    stringBuilder.append(':');
                    continue block4;
                }
                case '!': {
                    stringBuilder.append('!');
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported escape sequence: " + c + c2);
                }
            }
        }
        if (n == n2) {
            stringBuilder.append(string.charAt(n2));
        }
        return stringBuilder.toString();
    }
}

