/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search;

import com.vmware.vise.metadata.ObjectModelProvider;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.reflection.ClassDirectory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class ReflectionObjectModelProvider
implements ObjectModelProvider {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final int PACKAGE_BINDINGS_CACHE_SIZE = 100;
    private final ClassDirectory _packageBindingsDirectory;

    public ReflectionObjectModelProvider(Collection<String> collection, ClassLoader classLoader) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{collection, classLoader});
        this._packageBindingsDirectory = new ClassDirectory(collection, classLoader, Integer.valueOf(100));
    }

    public String[] getSuperTypes(String string) {
        if (string == null) {
            return EMPTY_ARRAY;
        }
        Class clazz = this._packageBindingsDirectory.getClass(string);
        List<Class<?>> list = ReflectionObjectModelProvider.getSuperTypesFromClassDef(clazz);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).getSimpleName();
        }
        return stringArray;
    }

    public String getImmediateSuperType(String string) {
        if (string == null) {
            return null;
        }
        Class clazz = this._packageBindingsDirectory.getClass(string);
        if (clazz == null || Object.class.equals((Object)clazz)) {
            return null;
        }
        Class clazz2 = clazz.getSuperclass();
        String string2 = clazz2.getSimpleName();
        return string2;
    }

    private static List<Class<?>> getSuperTypesFromClassDef(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        LinkedList linkedList = new LinkedList();
        Class<?> clazz2 = clazz;
        while (!Object.class.equals(clazz2)) {
            Class<?> clazz3 = clazz2.getSuperclass();
            linkedList.add(clazz3);
            clazz2 = clazz3;
        }
        return linkedList;
    }
}

