/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.auth;

import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;

public final class AuthData {
    private final SamlToken _token;
    private final PrivateKey _privateKey;
    private volatile int _cachedHashCode;

    public AuthData(SamlToken samlToken, PrivateKey privateKey) {
        if (samlToken == null) {
            throw new IllegalArgumentException("The token shouldn't be null");
        }
        if (samlToken.getConfirmationType() == ConfirmationType.HOLDER_OF_KEY && privateKey == null) {
            throw new IllegalArgumentException("For HoK tokens, a non-null privateKey must be specified");
        }
        this._token = samlToken;
        this._privateKey = privateKey;
    }

    public SamlToken getToken() {
        return this._token;
    }

    public PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (AuthData.class.equals(object.getClass())) {
            AuthData authData = (AuthData)object;
            boolean bl = this._token.equals((Object)authData._token) && (this._privateKey == null ? authData._privateKey == null : this._privateKey.equals(authData._privateKey));
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = this._cachedHashCode;
        if (n == 0) {
            n = 17;
            n = 31 * n + this._token.hashCode();
            this._cachedHashCode = n = 31 * n + (this._privateKey != null ? this._privateKey.hashCode() : 0);
        }
        return n;
    }
}

