/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.util.collection.DepthFirstTreeIterator;
import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import com.vmware.vise.util.collection.TreeIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class ConstraintTree
implements Tree<ConstraintInternal> {
    private Node<ConstraintInternal> _root;

    ConstraintTree(ConstraintInternal constraintInternal) {
        this._root = new ConstraintNode(constraintInternal);
    }

    public Node<ConstraintInternal> getRoot() {
        return this._root;
    }

    public void setRoot(Node<ConstraintInternal> node) {
        this._root = node;
    }

    public TreeIterator<ConstraintInternal> iterator() {
        return new DepthFirstTreeIterator((Tree)this);
    }

    public static class ConstraintNode
    implements Node<ConstraintInternal> {
        private final ConstraintInternal _constraint;

        ConstraintNode(ConstraintInternal constraintInternal) {
            this._constraint = constraintInternal;
        }

        public ConstraintInternal getData() {
            return this._constraint;
        }

        public Node<ConstraintInternal> getParent() {
            ConstraintInternal constraintInternal = this._constraint.getParentConstraint();
            if (constraintInternal == null) {
                return null;
            }
            return new ConstraintNode(constraintInternal);
        }

        public void setParent(Node<ConstraintInternal> node) {
            ConstraintInternal constraintInternal = node == null ? null : (ConstraintInternal)node.getData();
            this._constraint.setParentConstraint(constraintInternal);
        }

        public void appendChild(Node<ConstraintInternal> node) {
            this._constraint.addChild((ConstraintInternal)node.getData());
        }

        public void removeChild(Node<ConstraintInternal> node) {
            this._constraint.removeChild((ConstraintInternal)node.getData());
        }

        public Node<ConstraintInternal> getChild(int n) {
            List<Node<ConstraintInternal>> list = this.getChildren();
            return list.get(n);
        }

        public void setChild(int n, Node<ConstraintInternal> node) {
            this._constraint.setChild(n, (ConstraintInternal)node.getData());
        }

        public List<Node<ConstraintInternal>> getChildren() {
            ConstraintInternal[] constraintInternalArray = this._constraint.getChildren();
            return ConstraintNode.toConstraintNodes(constraintInternalArray);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ConstraintNode)) {
                return false;
            }
            ConstraintInternal constraintInternal = ((ConstraintNode)object).getData();
            return this._constraint.equals(constraintInternal);
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this._constraint.hashCode();
            return n;
        }

        private static List<Node<ConstraintInternal>> toConstraintNodes(ConstraintInternal[] constraintInternalArray) {
            ArrayList<ConstraintNode> arrayList = new ArrayList<ConstraintNode>(constraintInternalArray.length);
            for (ConstraintInternal constraintInternal : constraintInternalArray) {
                arrayList.add(new ConstraintNode(constraintInternal));
            }
            return Collections.unmodifiableList(arrayList);
        }
    }
}

