/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.impl.ConstraintVisitorBase;
import com.vmware.vise.search.impl.ConstraintVisitorUtils;
import com.vmware.vise.search.impl.EntitySetDescriptor;
import com.vmware.vise.search.impl.ExpressionTreeApplyOptimizationVisitor;
import com.vmware.vise.search.impl.ExpressionTreeBuilderVisitor;
import com.vmware.vise.search.impl.ExpressionTreeOptimizerVisitor;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.render.RendererFactory;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ConstraintTreeExprBuilder {
    private final TypeRefDirectory _typeRefDirectory;
    private final MetadataDirectory _metadataDirectory;
    private final RendererFactory _rendererFactory;
    private final String _targetId;
    private final Map<ConstraintInternal, ConstraintVisitorBase.VisitContext> _contextByConstraint = new HashMap<ConstraintInternal, ConstraintVisitorBase.VisitContext>();
    private final List<EntitySetDescriptor> _entitySetDescriptors;
    private final ConstraintInternal _rootConstraint;

    ConstraintTreeExprBuilder(Constraint constraint, TypeRefDirectory typeRefDirectory, MetadataDirectory metadataDirectory, RendererFactory rendererFactory) {
        this(constraint, typeRefDirectory, metadataDirectory, rendererFactory, "target");
    }

    ConstraintTreeExprBuilder(Constraint constraint, TypeRefDirectory typeRefDirectory, MetadataDirectory metadataDirectory, RendererFactory rendererFactory, String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeRefDirectory, metadataDirectory, rendererFactory});
        if (!(constraint instanceof ConstraintInternal)) {
            throw new IllegalArgumentException("Constraint is illegal.");
        }
        this._rootConstraint = (ConstraintInternal)constraint;
        this._typeRefDirectory = typeRefDirectory;
        this._metadataDirectory = metadataDirectory;
        this._rendererFactory = rendererFactory;
        this._entitySetDescriptors = new ArrayList<EntitySetDescriptor>();
        this._targetId = !StringUtil.isNullOrEmpty((String)string) ? string : "target";
    }

    public String toExprString() {
        this.buildExprTree();
        String[] stringArray = EntitySetDescriptor.toSetDefnClauses(this._entitySetDescriptors, "Set");
        String string = Strings.join("\n", stringArray);
        return string;
    }

    private List<EntitySetDescriptor> buildExprTree() {
        this.buildTree(this._rootConstraint);
        this.optimizeTree(this._rootConstraint);
        return this._entitySetDescriptors;
    }

    private void buildTree(ConstraintInternal constraintInternal) {
        ExpressionTreeBuilderVisitor expressionTreeBuilderVisitor = new ExpressionTreeBuilderVisitor(this._entitySetDescriptors, this._metadataDirectory, this._rendererFactory, this._contextByConstraint, this._targetId);
        ConstraintVisitorUtils.acceptVisitorInPreorderTraversal(constraintInternal, expressionTreeBuilderVisitor);
    }

    private void optimizeTree(ConstraintInternal constraintInternal) {
        if (this._contextByConstraint.size() == 0) {
            return;
        }
        HashMap<ConstraintInternal, ConstraintVisitorBase.SimplificationType> hashMap = new HashMap<ConstraintInternal, ConstraintVisitorBase.SimplificationType>();
        ConstraintVisitorUtils.acceptVisitorInPostorderTraversal(constraintInternal, new ExpressionTreeOptimizerVisitor(this._typeRefDirectory, hashMap, this._contextByConstraint));
        ConstraintVisitorUtils.acceptVisitorInPostorderTraversal(constraintInternal, new ExpressionTreeApplyOptimizationVisitor(this._metadataDirectory, this._typeRefDirectory, hashMap, this._contextByConstraint));
    }
}

