/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.search.PropertyInfo;
import com.vmware.vise.search.PropertyUnmarshaller;
import com.vmware.vise.search.ValueEx;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.impl.UnmarshallingUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.xml.XmlStreamUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class CustomPropertyUnmarshaller
implements PropertyUnmarshaller {
    private static Log _logger = LogFactory.getLog(CustomPropertyUnmarshaller.class);

    CustomPropertyUnmarshaller() {
    }

    @Override
    public ValueEx<Object> getValue(PropertyInfo propertyInfo, XMLStreamReader xMLStreamReader) throws XMLStreamException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyInfo, xMLStreamReader});
        Object object = null;
        int n = xMLStreamReader.getEventType();
        if (n == 1) {
            ResultContainer resultContainer = this.processProperty(propertyInfo, xMLStreamReader);
            object = resultContainer.isReferenceValue ? this.toValue(resultContainer.referenceValues, propertyInfo) : this.toValue(resultContainer.primitiveValues, propertyInfo);
        }
        return new ValueEx<Object>(object);
    }

    private ResultContainer processProperty(PropertyInfo propertyInfo, XMLStreamReader xMLStreamReader) throws XMLStreamException {
        assert (propertyInfo != null);
        assert (xMLStreamReader != null);
        String string = xMLStreamReader.getLocalName();
        String string2 = null;
        ResultContainer resultContainer = new ResultContainer();
        resultContainer.isReferenceValue = UnmarshallingUtil.isReferenceProperty(xMLStreamReader);
        do {
            Object object;
            boolean bl;
            if (resultContainer.isReferenceValue != (bl = UnmarshallingUtil.isReferenceProperty(xMLStreamReader))) {
                this.throwIllegalStateException(bl, string);
            }
            if (resultContainer.isReferenceValue) {
                object = UnmarshallingUtil.processReferenceProperty(xMLStreamReader, propertyInfo);
                if (object != null) {
                    resultContainer.referenceValues.add(object);
                }
            } else {
                object = this.processPrimitiveProperty(xMLStreamReader, propertyInfo);
                resultContainer.primitiveValues.add(object);
            }
            string2 = null;
            if (!xMLStreamReader.hasNext()) continue;
            if (xMLStreamReader.getEventType() == 2 && string.equals(xMLStreamReader.getLocalName())) {
                UnmarshallingUtil.moveReaderUntilStartOrEndElement(xMLStreamReader);
            }
            if (!xMLStreamReader.isStartElement()) continue;
            string2 = xMLStreamReader.getLocalName();
        } while (string.equals(string2));
        return resultContainer;
    }

    private Object toValue(List<Object> list, PropertyInfo propertyInfo) {
        assert (list != null);
        assert (propertyInfo != null);
        if (propertyInfo.isMultiCardinality()) {
            return this.toArrayValue(list, propertyInfo.getArrayType());
        }
        if (list.size() > 0) {
            Object object = list.get(0);
            return object;
        }
        return null;
    }

    private Object toArrayValue(List<Object> list, PropertyInfo.ArrayType arrayType) {
        switch (arrayType) {
            case ManagedObjectReference: {
                return list.toArray(new ManagedObjectReference[list.size()]);
            }
            case Uri: {
                return list.toArray(new URI[list.size()]);
            }
            case String: {
                return list.toArray(new String[list.size()]);
            }
        }
        return list.toArray();
    }

    private Object processPrimitiveProperty(XMLStreamReader xMLStreamReader, PropertyInfo propertyInfo) throws XMLStreamException {
        assert (xMLStreamReader != null);
        assert (propertyInfo != null);
        Object object = null;
        String string = propertyInfo.getType();
        try {
            int n = xMLStreamReader.getEventType();
            if (n == 1) {
                if (TypeRefUtils.XML_TYPEREF.getName().equals(string)) {
                    object = XmlStreamUtils.getNodeContentFromXmlStream((XMLStreamReader)xMLStreamReader);
                } else {
                    String string2 = xMLStreamReader.getElementText();
                    object = TypeRefUtils.toPrimitiveType(string, string2);
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            String string3 = propertyInfo.getName();
            String string4 = "";
            if (propertyInfo.getProvider() != null) {
                string4 = propertyInfo.getProvider();
            }
            String string5 = String.format("Error reading primitive property: (providerType=%1$s, propName=%2$s).", string4, string3);
            _logger.error((Object)string5, (Throwable)xMLStreamException);
            throw xMLStreamException;
        }
        return object;
    }

    private String throwIllegalStateException(boolean bl, String string) {
        String string2 = bl ? String.format("Illegal xlink:href attribute in tag: %1$s", string) : String.format("Missed xlink:href attribute in tag: %1$s", string);
        throw new IllegalStateException(string2);
    }

    private static class ResultContainer {
        final List<Object> referenceValues = new ArrayList<Object>();
        final List<Object> primitiveValues = new ArrayList<Object>();
        boolean isReferenceValue = false;

        private ResultContainer() {
        }
    }
}

