/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.core.model.IdentifiableGenerationNumber;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class GenerationNumberUtil {
    private static final String GENERATION_VALUE_ATTRIB_NAME = "value";
    private static final QName GENERATION_QNAME = new QName("query", "generation");
    private static final Log _logger = LogFactory.getLog(GenerationNumberUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<IdentifiableGenerationNumber> readGenerationNumbers(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{xMLStreamReader});
        if (xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
        }
        while (!xMLStreamReader.isStartElement() && !xMLStreamReader.isEndElement() && xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
        }
        if (xMLStreamReader.isEndElement()) {
            return Collections.emptyList();
        }
        ArrayList<IdentifiableGenerationNumber> arrayList = new ArrayList<IdentifiableGenerationNumber>();
        boolean bl = false;
        while (!bl && xMLStreamReader.hasNext()) {
            if (xMLStreamReader.isStartElement()) {
                if (!GENERATION_QNAME.equals(xMLStreamReader.getName())) throw new IllegalStateException("Unexpected nested tag " + xMLStreamReader.getName());
                String string = xMLStreamReader.getAttributeValue("query", "docProvider");
                String string2 = xMLStreamReader.getAttributeValue("query", GENERATION_VALUE_ATTRIB_NAME);
                long l = GenerationNumberUtil.parseGeneration(string2);
                arrayList.add(IdentifiableGenerationNumber.newInstance((String)string, (Long)l));
            } else if (xMLStreamReader.isEndElement() && !GENERATION_QNAME.equals(xMLStreamReader.getName())) {
                bl = true;
            }
            xMLStreamReader.next();
        }
        return arrayList;
    }

    public static long parseGeneration(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return 0L;
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error parsing generation number '" + string + "'."), (Throwable)exception);
        }
        return l;
    }

    private GenerationNumberUtil() {
    }
}

