/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NamespaceUtils {
    private static final Log LOGGER = LogFactory.getLog(NamespaceUtils.class);
    public static volatile String DEFAULT_NAMESPACE;
    public static final String URN_NAMESPACE_PREFIX = "urn";

    private NamespaceUtils() {
    }

    public static String getNamespace(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        int n = string.lastIndexOf(58);
        if (n == -1) {
            return DEFAULT_NAMESPACE;
        }
        if (n == 0 || n == string.length() - 1) {
            LOGGER.warn((Object)("Fully qualified name cannot start or end with ':' which is reserved as a namespace delimiter: " + string));
            return null;
        }
        return string.substring(0, n);
    }

    public static String getSimpleName(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        int n = string.lastIndexOf(58);
        if (n == -1) {
            return string;
        }
        if (n == 0 || n == string.length() - 1) {
            throw new IllegalArgumentException("Fully qualified name cannot start or end with ':' which is reserved as a namespace delimiter: " + string);
        }
        return string.substring(n + 1);
    }
}

