/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.CompositeConstraint;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.ConstraintFactory;
import com.vmware.vise.search.RelationSpec;
import com.vmware.vise.search.RelationalConstraint;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.transform.Transformer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class OptimizeConstraintTransformer
implements Transformer<Constraint> {
    private static final Log _logger = LogFactory.getLog(OptimizeConstraintTransformer.class);
    private final ConstraintFactory _constraintFactory;

    OptimizeConstraintTransformer(ConstraintFactory constraintFactory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{constraintFactory});
        this._constraintFactory = constraintFactory;
    }

    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof CompositeConstraint)) {
            return new Transformer.Result((Object)constraint);
        }
        CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
        if (compositeConstraint.getConjoiner() != ConstraintConjoiner.OR) {
            return new Transformer.Result((Object)constraint);
        }
        Constraint constraint2 = this.normalizeCompositeConstraint(compositeConstraint);
        boolean bl = constraint2 != compositeConstraint;
        return new Transformer.Result((Object)constraint2, bl);
    }

    private Constraint normalizeCompositeConstraint(CompositeConstraint compositeConstraint) {
        Constraint[] constraintArray;
        LinkedHashMap<RelationSpec, Set<RelationalConstraint>> linkedHashMap = new LinkedHashMap<RelationSpec, Set<RelationalConstraint>>();
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        for (Constraint constraint : constraintArray = compositeConstraint.getNestedConstraints()) {
            if (constraint instanceof RelationalConstraint) {
                OptimizeConstraintTransformer.addToConstraintMap(linkedHashMap, constraint);
                continue;
            }
            arrayList.add(constraint);
        }
        Constraint constraint = this.tryToSimplifyConstraint(compositeConstraint, linkedHashMap, arrayList);
        return constraint;
    }

    private static void addToConstraintMap(Map<RelationSpec, Set<RelationalConstraint>> map, Constraint constraint) {
        RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
        RelationSpec relationSpec = relationalConstraint.getRelationSpec();
        Set<RelationalConstraint> set = map.get(relationSpec);
        if (set == null) {
            set = new LinkedHashSet<RelationalConstraint>();
            map.put(relationSpec, set);
        }
        set.add(relationalConstraint);
    }

    private Constraint tryToSimplifyConstraint(CompositeConstraint compositeConstraint, Map<RelationSpec, Set<RelationalConstraint>> map, List<Constraint> list) {
        boolean bl = false;
        Object object = compositeConstraint;
        for (RelationSpec relationSpec : map.keySet()) {
            if (relationSpec == null) {
                _logger.error((Object)"Null RelationDescriptor.");
                continue;
            }
            Set<RelationalConstraint> set = map.get(relationSpec);
            if (set.size() > 1) {
                CompositeConstraint compositeConstraint2 = this._constraintFactory.newCompositeConstraint();
                compositeConstraint2.setConjoiner(compositeConstraint.getConjoiner());
                for (RelationalConstraint relationalConstraint : set) {
                    compositeConstraint2.add(relationalConstraint.getNestedConstraint());
                }
                RelationalConstraint relationalConstraint = this._constraintFactory.newRelationalConstraint();
                relationalConstraint.setNestedConstraint(compositeConstraint2);
                relationalConstraint.setRelationSpec(relationSpec);
                list.add(relationalConstraint);
                bl = true;
                continue;
            }
            list.addAll(set);
        }
        if (bl) {
            if (list.size() == 1) {
                object = list.get(0);
            } else if (list.size() > 1) {
                CompositeConstraint compositeConstraint3 = this._constraintFactory.newCompositeConstraint();
                compositeConstraint3.setConjoiner(compositeConstraint.getConjoiner());
                compositeConstraint3.setNestedConstraints(list.toArray(new Constraint[0]));
                object = compositeConstraint3;
            }
        }
        return object;
    }
}

