/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.impl.CompositeConstraintInternal;
import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.impl.ConstraintVisitor;
import com.vmware.vise.search.impl.ConstraintVisitorUtils;
import com.vmware.vise.search.impl.ObjectIdentityConstraintInternal;
import com.vmware.vise.search.impl.QueryRequest;
import com.vmware.vise.search.impl.RelationalConstraintInternal;
import com.vmware.vise.search.impl.SimplePropertyConstraintInternal;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.TypeDescriptor;
import java.util.HashSet;
import java.util.Set;

public class QueryAnalyzer {
    private final QueryRequest _queryRequest;
    private final QueryConstraintTargetVisitor _queryVisitor;
    private Boolean _targetOnlyGlobalResources;

    public QueryAnalyzer(MetadataDirectory metadataDirectory, QueryRequest queryRequest) {
        this._queryRequest = queryRequest;
        this._queryVisitor = new QueryConstraintTargetVisitor(metadataDirectory);
        this._targetOnlyGlobalResources = null;
    }

    public boolean constraintsOnlyGlobalResources() {
        if (this._targetOnlyGlobalResources != null) {
            return this._targetOnlyGlobalResources;
        }
        if (this._queryRequest == null || this._queryRequest.querySpec == null || this._queryRequest.querySpec.constraint == null) {
            this._targetOnlyGlobalResources = false;
            return this._targetOnlyGlobalResources;
        }
        Constraint constraint = this._queryRequest.querySpec.constraint;
        ConstraintVisitorUtils.acceptVisitorInPreorderTraversal((ConstraintInternal)constraint, this._queryVisitor);
        this._targetOnlyGlobalResources = this._queryVisitor.constraintsOnlyGlobalResources();
        return this._targetOnlyGlobalResources;
    }

    private static class QueryConstraintTargetVisitor
    implements ConstraintVisitor {
        private final MetadataDirectory _metadataDirectory;
        private final Set<String> _targets = new HashSet<String>();

        public QueryConstraintTargetVisitor(MetadataDirectory metadataDirectory) {
            this._metadataDirectory = metadataDirectory;
        }

        public boolean constraintsOnlyGlobalResources() {
            if (this._targets.isEmpty()) {
                return false;
            }
            for (String string : this._targets) {
                TypeDescriptor typeDescriptor = this._metadataDirectory.getTypeDescriptor(string);
                if (typeDescriptor.isGlobalResource()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void visitSimplePropertyConstraint(SimplePropertyConstraintInternal simplePropertyConstraintInternal) {
            this._targets.add(simplePropertyConstraintInternal.getSearchTarget());
        }

        @Override
        public void visitObjectIdentityConstraint(ObjectIdentityConstraintInternal objectIdentityConstraintInternal) {
            this._targets.add(objectIdentityConstraintInternal.getSearchTarget());
        }

        @Override
        public void visitRelationalConstraint(RelationalConstraintInternal relationalConstraintInternal) {
            this._targets.add(relationalConstraintInternal.getSearchTarget());
        }

        @Override
        public void visitCompositeConstraint(CompositeConstraintInternal compositeConstraintInternal) {
        }

        @Override
        public void visitDefaultConstraint(ConstraintInternal constraintInternal) {
            this._targets.add(constraintInternal.getSearchTarget());
        }
    }
}

