/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.ctc.wstx.stax.WstxInputFactory;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vise.core.model.IdentifiableGenerationNumber;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.search.Match;
import com.vmware.vise.search.PropertyUnmarshaller;
import com.vmware.vise.search.PropertyValue;
import com.vmware.vise.search.ResultSet;
import com.vmware.vise.search.ValueEx;
import com.vmware.vise.search.impl.GenerationNumberUtil;
import com.vmware.vise.search.impl.MatchImpl;
import com.vmware.vise.search.impl.PropertyValueImpl;
import com.vmware.vise.search.impl.QueryAnalyzer;
import com.vmware.vise.search.impl.QueryRequest;
import com.vmware.vise.search.impl.ResponseSpecificUnmarshallerDirectory;
import com.vmware.vise.search.impl.ResultSetDataImpl;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.util.xml.XmlStreamUtils;
import com.vmware.vise.vim.commons.MixedUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResultSetProcessor {
    private static final Logger _logger = LoggerFactory.getLogger(ResultSetProcessor.class);
    private final MetadataDirectory _metadataDirectory;
    private final ResponseSpecificUnmarshallerDirectory _unmarshallerFactory;
    private final QueryAnalyzer _queryAnalyzer;
    private static final String PROPERTY_PATH_SEPARATOR = ";";
    private static final FacetValue[] EMPTY_FACET_VALUE_ARRAY = new FacetValue[0];
    private static final QName GENERATIONS_QNAME = new QName("query", "generations");
    private static final QName PROPERTIES_QNAME = new QName("query", "properties");
    private boolean _hasMultipleResults = false;

    ResultSetProcessor(MetadataDirectory metadataDirectory, ResponseSpecificUnmarshallerDirectory responseSpecificUnmarshallerDirectory, QueryRequest queryRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataDirectory, responseSpecificUnmarshallerDirectory});
        this._metadataDirectory = metadataDirectory;
        this._unmarshallerFactory = responseSpecificUnmarshallerDirectory;
        this._queryAnalyzer = new QueryAnalyzer(this._metadataDirectory, queryRequest);
    }

    public ValueEx<ResultSet> getResultSet(InputStream inputStream, Collection<String> collection) {
        return this.getResultSet(Collections.singleton(inputStream), collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueEx<ResultSet> getResultSet(Collection<InputStream> collection, Collection<String> collection2) {
        Object object;
        int n;
        InputStream inputStream2;
        Validate.notEmpty(collection, (String)"At least one response stream is required.");
        if (collection2 == null) {
            collection2 = Collections.emptySet();
        }
        ResultContainer resultContainer = new ResultContainer();
        String string = null;
        XMLStreamReader xMLStreamReader = null;
        LinkedList<Exception> linkedList = new LinkedList<Exception>();
        WstxInputFactory wstxInputFactory = new WstxInputFactory();
        wstxInputFactory.setProperty("javax.xml.stream.supportDTD", (Object)Boolean.FALSE);
        for (InputStream inputStream2 : collection) {
            try {
                n = _logger.isDebugEnabled();
                if (n != 0) {
                    StreamUtil.StreamResult streamResult = StreamUtil.fetchStreamIntoStringAndReturnEquivalentStream((InputStream)inputStream2, (String)"UTF8");
                    inputStream2 = streamResult.getInputStream();
                    string = streamResult.getStreamContent();
                    object = streamResult.getException();
                    if (object != null) {
                        throw object;
                    }
                }
                xMLStreamReader = wstxInputFactory.createXMLStreamReader(inputStream2, "UTF-8");
                while (xMLStreamReader.hasNext()) {
                    if (xMLStreamReader.isStartElement()) {
                        this.processStartElement(xMLStreamReader, resultContainer, linkedList);
                        continue;
                    }
                    xMLStreamReader.next();
                }
            }
            catch (Exception exception) {
                try {
                    _logger.error("Error processing result stream.", (Throwable)exception);
                    resultContainer.exceptions.add(exception);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(xMLStreamReader);
                    throw throwable;
                }
                StreamUtil.close((XMLStreamReader)xMLStreamReader);
                continue;
            }
            StreamUtil.close((XMLStreamReader)xMLStreamReader);
        }
        Set<Object> set = resultContainer.includedServices;
        if (set == null) {
            set = Collections.emptySet();
        }
        if (resultContainer.exceptions.size() > 0 || set.size() != collection2.size()) {
            if (string != null) {
                n = string.length();
                if (_logger.isTraceEnabled() || _logger.isDebugEnabled() && n <= 500) {
                    _logger.debug("The length of the response from the Inventory Service is: " + n + ". The response is:\n" + string);
                } else if (_logger.isDebugEnabled()) {
                    int n2 = Math.max(0, n - 500);
                    object = string.substring(n2);
                    _logger.debug("The length of the response from the Inventory Service is: " + n + ". The last " + 500 + " characters from the response are:\n" + (String)object);
                }
            } else {
                _logger.debug("The response from the Inventory Service was empty");
            }
        }
        inputStream2 = MixedUtil.constructCompositeException(resultContainer.exceptions);
        ResultSetDataImpl resultSetDataImpl = new ResultSetDataImpl(resultContainer.matches, resultContainer.matchCount, resultContainer.facetInfos, collection2, resultContainer.includedServices, resultContainer.resultSorted, resultContainer.resultPaged, (Exception)((Object)inputStream2));
        return new ValueEx<ResultSet>(resultSetDataImpl, linkedList);
    }

    private void processStartElement(XMLStreamReader xMLStreamReader, ResultContainer resultContainer, Collection<Exception> collection) throws XMLStreamException {
        assert (xMLStreamReader != null);
        assert (resultContainer != null);
        QName qName = xMLStreamReader.getName();
        if (XQueryUtils.RESULT_QNAME.equals(qName)) {
            String string = ResultSetProcessor.extractServiceUuid(xMLStreamReader);
            xMLStreamReader.next();
            if (!Strings.isNullOrEmpty(string)) {
                resultContainer.includedServices.add(string);
            } else {
                _logger.warn("No service UUID found in Query Service response");
            }
        } else if (XQueryUtils.ITEM_COUNT_QNAME.equals(qName)) {
            String string = xMLStreamReader.getElementText();
            int n = Integer.parseInt(string);
            if (resultContainer.matchCount > 0 && n > 0) {
                this._hasMultipleResults = true;
                resultContainer.resultSorted = false;
                resultContainer.resultPaged = false;
                if (this._queryAnalyzer.constraintsOnlyGlobalResources()) {
                    return;
                }
            }
            resultContainer.matchCount += n;
        } else if (XQueryUtils.ITEM_QNAME.equals(qName)) {
            try {
                Match match = this.processItem(xMLStreamReader, collection);
                if (match != null) {
                    resultContainer.matches.add(match);
                }
            }
            catch (UnmarshallException unmarshallException) {
                _logger.error("Error processing item.", (Throwable)unmarshallException);
                resultContainer.exceptions.add((Exception)((Object)unmarshallException));
            }
        } else if (XQueryUtils.FACET_QNAME.equals(qName)) {
            try {
                FacetInfo facetInfo = this.createFacetInfo(xMLStreamReader, collection);
                if (facetInfo != null) {
                    resultContainer.facetInfos.add(facetInfo);
                }
            }
            catch (UnmarshallException unmarshallException) {
                _logger.error("Error processing facet.", (Throwable)unmarshallException);
                resultContainer.exceptions.add((Exception)((Object)unmarshallException));
            }
        } else if (XQueryUtils.SORTED_QNAME.equals(qName) && !this._hasMultipleResults) {
            boolean bl;
            String string = xMLStreamReader.getElementText();
            resultContainer.resultSorted = bl = Boolean.parseBoolean(string);
            resultContainer.resultPaged = bl;
        } else {
            xMLStreamReader.next();
        }
    }

    private static String extractServiceUuid(XMLStreamReader xMLStreamReader) {
        assert (xMLStreamReader != null);
        QName qName = new QName("query", "serviceUuid");
        String string = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)qName);
        return string;
    }

    private Match processItem(XMLStreamReader xMLStreamReader, Collection<Exception> collection) throws XMLStreamException, UnmarshallException {
        Object object;
        assert (xMLStreamReader != null);
        String string = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.RESOURCE_ATTRIB_QNAME);
        String string2 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.PROVIDER_ATTRIB_QNAME);
        if (StringUtil.isNullOrEmpty((String)string)) {
            string = string2;
        }
        if ((object = QueryUtil.getReference((String)string)) == null) {
            return null;
        }
        ResultItemContent resultItemContent = this.processItemContent(xMLStreamReader, collection, string, string2);
        MatchImpl matchImpl = new MatchImpl(object, resultItemContent.properties(), resultItemContent.generations());
        return matchImpl;
    }

    private ResultItemContent processItemContent(XMLStreamReader xMLStreamReader, Collection<Exception> collection, String string, String string2) throws XMLStreamException, UnmarshallException {
        if (xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
        }
        while (!xMLStreamReader.isStartElement() && !xMLStreamReader.isEndElement() && xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
        }
        List<IdentifiableGenerationNumber> list = Collections.emptyList();
        List<PropertyValue> list2 = Collections.emptyList();
        if (xMLStreamReader.isEndElement()) {
            return new ResultItemContent(list2, list);
        }
        if (GENERATIONS_QNAME.equals(xMLStreamReader.getName())) {
            list = this.processGenerations(xMLStreamReader, string, string2, GENERATIONS_QNAME, collection);
            ResultSetProcessor.moveToEndOfElement(xMLStreamReader, GENERATIONS_QNAME);
        }
        if (PROPERTIES_QNAME.equals(xMLStreamReader.getName())) {
            list2 = this.processProperties(xMLStreamReader, string, string2, null, null, PROPERTIES_QNAME, collection);
        }
        ResultSetProcessor.moveToEndOfElement(xMLStreamReader, XQueryUtils.ITEM_QNAME);
        return new ResultItemContent(list2, list);
    }

    private PropertySpec createPropSpec(XMLStreamReader xMLStreamReader) {
        String string = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.PROP_PATH_ATTRIB_QNAME);
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("::");
        if (stringArray == null || stringArray.length != 3) {
            return null;
        }
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = stringArray[0];
        propertySpec.relation = "".equals(stringArray[1]) ? null : stringArray[1];
        propertySpec.propertyNames = new String[]{stringArray[2]};
        return propertySpec;
    }

    private FacetValue[] processFacetValues(XMLStreamReader xMLStreamReader, PropertySpec propertySpec, Collection<Exception> collection) throws XMLStreamException, UnmarshallException {
        FacetValue facetValue;
        ArrayList<FacetValue> arrayList = new ArrayList<FacetValue>();
        if (!ResultSetProcessor.isAtTagStart(xMLStreamReader, XQueryUtils.FACET_VALUE_QNAME)) {
            throw new IllegalStateException("Missing expected node: " + XQueryUtils.FACET_VALUE_QNAME);
        }
        while (ResultSetProcessor.isAtTagStart(xMLStreamReader, XQueryUtils.FACET_VALUE_QNAME) && xMLStreamReader.hasNext()) {
            facetValue = this.processFacetValue(xMLStreamReader, propertySpec, collection);
            arrayList.add(facetValue);
        }
        facetValue = arrayList.toArray(EMPTY_FACET_VALUE_ARRAY);
        return facetValue;
    }

    private FacetInfo createFacetInfo(XMLStreamReader xMLStreamReader, Collection<Exception> collection) throws XMLStreamException, UnmarshallException {
        PropertySpec propertySpec;
        assert (xMLStreamReader != null);
        FacetInfo facetInfo = new FacetInfo();
        facetInfo.propSpec = propertySpec = this.createPropSpec(xMLStreamReader);
        int n = this.getFacetValueTotalCount(xMLStreamReader);
        this.moveToNextElement(xMLStreamReader);
        if (n == 0) {
            facetInfo.facetValues = EMPTY_FACET_VALUE_ARRAY;
            return facetInfo;
        }
        facetInfo.facetValues = this.processFacetValues(xMLStreamReader, propertySpec, collection);
        if (facetInfo.facetValues.length < n) {
            throw new IllegalStateException("Expected " + n + " facetValues but found only " + facetInfo.facetValues.length);
        }
        return facetInfo;
    }

    private int getFacetValueTotalCount(XMLStreamReader xMLStreamReader) {
        String string = xMLStreamReader.getAttributeValue("query", "totalCount");
        int n = Integer.parseInt(string);
        return n;
    }

    private String retrievePropName(PropertySpec propertySpec) {
        if (propertySpec == null) {
            return null;
        }
        if (propertySpec.propertyNames == null || propertySpec.propertyNames.length == 0) {
            return null;
        }
        return propertySpec.propertyNames[0];
    }

    private PropertyConstraint createPropConstraint(Object object, String string, String string2) {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.propertyName = string2;
        propertyConstraint.targetType = string;
        propertyConstraint.comparableValue = object;
        propertyConstraint.comparator = Comparator.EQUALS;
        return propertyConstraint;
    }

    private FacetValue processFacetValue(XMLStreamReader xMLStreamReader, PropertySpec propertySpec, Collection<Exception> collection) throws XMLStreamException, UnmarshallException {
        if (propertySpec.propertyNames == null || propertySpec.propertyNames.length != 1) {
            throw new IllegalArgumentException("Expected exactly one property name in the propSpec: " + propertySpec);
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertySpec.type, propertySpec.relation, propertySpec.propertyNames[0]);
        Object var5_5 = null;
        PropertyUnmarshaller propertyUnmarshaller = this._unmarshallerFactory.getPropertyUnmarshaller(var5_5, propertyDescriptor, false, false);
        this.moveToNextElement(xMLStreamReader);
        ValueEx<Object> valueEx = propertyUnmarshaller.getValue(propertyDescriptor, xMLStreamReader);
        Object object = valueEx.getValue();
        collection.addAll(valueEx.getExceptions());
        FacetValue facetValue = new FacetValue();
        Constraint constraint = this.createConstraint(object, propertySpec);
        if (constraint != null) {
            facetValue.constraint = constraint;
            facetValue.value = object;
        }
        ResultSetProcessor.moveToEndOfElement(xMLStreamReader, XQueryUtils.FACET_VALUE_QNAME);
        this.moveToNextElement(xMLStreamReader);
        return facetValue;
    }

    private Constraint createConstraint(Object object, PropertySpec propertySpec) {
        PropertyConstraint propertyConstraint;
        if (StringUtil.isNullOrEmpty((String)propertySpec.relation)) {
            PropertyConstraint propertyConstraint2 = this.createPropConstraint(object, propertySpec.type, this.retrievePropName(propertySpec));
            return propertyConstraint2;
        }
        ArrayList<RelationalConstraint> arrayList = new ArrayList<RelationalConstraint>();
        String string = propertySpec.type;
        for (String string2 : propertyConstraint = propertySpec.relation.split("\\;")) {
            RelationalConstraint relationalConstraint = new RelationalConstraint();
            relationalConstraint.hasInverseRelation = false;
            relationalConstraint.relation = string2;
            relationalConstraint.targetType = string;
            arrayList.add(relationalConstraint);
            PropertyDescriptor propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string2, string);
            if (propertyDescriptor == null) {
                _logger.error("No property descriptor found for " + string + "::" + string2);
                return null;
            }
            RelationDescriptor relationDescriptor = this._metadataDirectory.getRelationDescriptor(propertyDescriptor);
            if (relationDescriptor == null) {
                _logger.error("No relation descriptor found for " + string + "::" + propertyDescriptor.getName());
                return null;
            }
            string = MetadataUtil.getTargetType(relationDescriptor, this._metadataDirectory);
        }
        PropertyConstraint propertyConstraint3 = this.createPropConstraint(object, string, this.retrievePropName(propertySpec));
        Collections.reverse(arrayList);
        RelationalConstraint object2 = (RelationalConstraint)arrayList.remove(0);
        object2.constraintOnRelatedObject = propertyConstraint3;
        for (RelationalConstraint relationalConstraint : arrayList) {
            relationalConstraint.constraintOnRelatedObject = object2;
            object2 = relationalConstraint;
        }
        return object2;
    }

    private RelationDescriptor[] getRelationshipHops(String string, String string2) {
        String[] stringArray;
        ArrayList<RelationDescriptor> arrayList = new ArrayList<RelationDescriptor>();
        for (String string3 : stringArray = string2.split("\\;")) {
            PropertyDescriptor propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string3, string);
            RelationDescriptor relationDescriptor = this._metadataDirectory.getRelationDescriptor(propertyDescriptor);
            arrayList.add(relationDescriptor);
            string = MetadataUtil.getTargetType(relationDescriptor, this._metadataDirectory);
        }
        return arrayList.toArray(new RelationDescriptor[0]);
    }

    private PropertyDescriptor getPropertyDescriptor(String string, String string2, String string3) {
        Object object;
        if (!Strings.isNullOrEmpty(string2)) {
            object = this.getRelationshipHops(string, string2);
            RelationDescriptor relationDescriptor = object[((RelationDescriptor[])object).length - 1];
            string = MetadataUtil.getTargetType(relationDescriptor, this._metadataDirectory);
        }
        object = this._metadataDirectory.getPropertyDescriptor(string3, string);
        return object;
    }

    private void moveToNextElement(XMLStreamReader xMLStreamReader) throws XMLStreamException, UnmarshallException {
        if (xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
        }
        while (!xMLStreamReader.isStartElement() && xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
        }
    }

    private List<IdentifiableGenerationNumber> processGenerations(XMLStreamReader xMLStreamReader, String string, String string2, QName qName, Collection<Exception> collection) {
        assert (xMLStreamReader != null);
        assert (qName != null);
        try {
            return GenerationNumberUtil.readGenerationNumbers(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            collection.add(xMLStreamException);
            return null;
        }
    }

    private List<PropertyValue> processProperties(XMLStreamReader xMLStreamReader, String string, String string2, String string3, String string4, QName qName, Collection<Exception> collection) throws XMLStreamException, UnmarshallException {
        assert (xMLStreamReader != null);
        assert (qName != null);
        if (xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
        }
        while (!xMLStreamReader.isStartElement() && !xMLStreamReader.isEndElement() && xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
        }
        if (xMLStreamReader.isEndElement()) {
            return Collections.emptyList();
        }
        boolean bl = false;
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        while (!bl && xMLStreamReader.hasNext()) {
            List<PropertyValue> list = this.getPropertyValues(xMLStreamReader, string, string2, string3, string4, qName, collection);
            arrayList.addAll(list);
            ResultSetProcessor.moveToEndOfElement(xMLStreamReader, qName);
            bl = ResultSetProcessor.isAtTagStart(xMLStreamReader, qName) || ResultSetProcessor.isAtTagEnd(xMLStreamReader, qName);
        }
        ResultSetProcessor.moveToEndOfElement(xMLStreamReader, qName);
        return arrayList;
    }

    private static void moveToEndOfElement(XMLStreamReader xMLStreamReader, QName qName) throws XMLStreamException {
        assert (xMLStreamReader != null);
        assert (qName != null);
        while (!xMLStreamReader.isStartElement() && xMLStreamReader.hasNext() && !ResultSetProcessor.isAtTagEnd(xMLStreamReader, qName)) {
            xMLStreamReader.next();
        }
    }

    private static boolean isAtTagEnd(XMLStreamReader xMLStreamReader, QName qName) {
        QName qName2;
        assert (xMLStreamReader != null);
        assert (qName != null);
        return xMLStreamReader.isEndElement() && (qName2 = xMLStreamReader.getName()).equals(qName);
    }

    private static boolean isAtTagStart(XMLStreamReader xMLStreamReader, QName qName) {
        QName qName2;
        assert (xMLStreamReader != null);
        assert (qName != null);
        return xMLStreamReader.isStartElement() && (qName2 = xMLStreamReader.getName()).equals(qName);
    }

    private List<PropertyValue> getPropertyValues(XMLStreamReader xMLStreamReader, String string, String string2, String string3, String string4, QName qName, Collection<Exception> collection) throws XMLStreamException, UnmarshallException {
        String string5;
        String string6;
        assert (xMLStreamReader != null);
        assert (qName != null);
        if (ResultSetProcessor.isAtTagEnd(xMLStreamReader, qName)) {
            return Collections.emptyList();
        }
        String string7 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.DOC_PROVIDER_ATTRIB_QNAME);
        if (string7 != null) {
            string2 = string7;
        }
        if ((string6 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.DOC_VAPI_NAME_ATTRIB_QNAME)) != null) {
            string4 = string6;
        }
        if ((string5 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.DOC_RESOURCE_TYPE_ATTRIB_QNAME)) != null) {
            string3 = string5;
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            string = string2;
        }
        String string8 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.RESOURCE_ATTRIB_QNAME);
        String string9 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.PROVIDER_ATTRIB_QNAME);
        String string10 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.DOC_RESOURCE_TYPE_ATTRIB_QNAME);
        if (StringUtil.isNullOrEmpty((String)string8)) {
            string8 = string9;
        }
        String string11 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.VAPI_NAME_ATTRIB_QNAME);
        if (this.isWellKnownType(string8)) {
            QName qName2 = xMLStreamReader.getName();
            List<PropertyValue> list = this.processProperties(xMLStreamReader, string8, string9, string10, string11, qName2, collection);
            return list;
        }
        PropertyValue propertyValue = this.getPropertyValue(xMLStreamReader, string, string2, string3, string4, collection);
        if (propertyValue != null) {
            List<PropertyValue> list = Collections.singletonList(propertyValue);
            return list;
        }
        return Collections.emptyList();
    }

    private boolean isWellKnownType(String string) {
        Object object = null;
        if (string != null) {
            object = QueryUtil.getReference((String)string);
        }
        String string2 = null;
        if (object != null) {
            string2 = QueryUtil.getReferenceType((Object)object);
        }
        boolean bl = !Strings.isNullOrEmpty(string2) && this._metadataDirectory.hasDescriptor(string2);
        return bl;
    }

    private PropertyValue getPropertyValue(XMLStreamReader xMLStreamReader, String string, String string2, String string3, String string4, Collection<Exception> collection) throws XMLStreamException, UnmarshallException {
        Object object;
        PropertyDescriptor propertyDescriptor;
        Object object2;
        assert (xMLStreamReader != null);
        if (this.containsRedirectURL(xMLStreamReader)) {
            if (xMLStreamReader.hasNext()) {
                xMLStreamReader.next();
            }
            return null;
        }
        String string5 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.GENERATION_ATTRIB_QNAME);
        long l = GenerationNumberUtil.parseGeneration(string5);
        String string6 = ResultSetProcessor.getPropertyName(xMLStreamReader);
        assert (string != null) : "resourceID is required";
        Object object3 = QueryUtil.getReference((String)string);
        boolean bl = !string.equals(string2);
        boolean bl2 = StringUtil.isNullOrEmpty((String)string2);
        if (bl) {
            object2 = QueryUtil.getReferenceType((Object)object3);
            propertyDescriptor = this._metadataDirectory.getPropertyDescriptorIfComputed(string6, (String)object2);
            if (propertyDescriptor == null) {
                object = string3 != null ? string3 : object2;
                propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string6, (String)object, string4);
            }
        } else {
            object2 = QueryUtil.getReferenceType((Object)object3);
            propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string6, (String)object2, string4);
        }
        object2 = this._unmarshallerFactory.getPropertyUnmarshaller(object3, propertyDescriptor, bl, bl2);
        object = object2.getValue(propertyDescriptor, xMLStreamReader);
        Object t = ((ValueEx)object).getValue();
        collection.addAll(((ValueEx)object).getExceptions());
        if (!MetadataUtil.isSupported(propertyDescriptor)) {
            return null;
        }
        String string7 = null;
        Class<?> clazz = ((ValueEx)object).getProviderModel();
        if (clazz != null) {
            string7 = clazz.getName();
        }
        PropertyValueImpl propertyValueImpl = new PropertyValueImpl(string6, object3, propertyDescriptor, t, string7, l);
        return propertyValueImpl;
    }

    private static String getPropertyName(XMLStreamReader xMLStreamReader) {
        assert (xMLStreamReader != null);
        String string = xMLStreamReader.getLocalName();
        String string2 = xMLStreamReader.getPrefix();
        String string3 = XMLUtil.unescapeXmlTag((String)string);
        if (!StringUtil.isNullOrEmpty((String)string2)) {
            string3 = string2 + ':' + string3;
        }
        return string3;
    }

    private boolean containsRedirectURL(XMLStreamReader xMLStreamReader) {
        assert (xMLStreamReader != null);
        String string = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (String)"xlink:href");
        return string != null && (string.startsWith("https://") || string.startsWith("http://"));
    }

    private static class ResultContainer {
        final List<Match> matches = new ArrayList<Match>();
        final List<FacetInfo> facetInfos = new ArrayList<FacetInfo>();
        final List<Exception> exceptions = new ArrayList<Exception>();
        final Set<String> includedServices = new HashSet<String>();
        boolean resultSorted = false;
        boolean resultPaged = false;
        int matchCount = 0;

        private ResultContainer() {
        }
    }

    private static final class ResultItemContent {
        private final List<PropertyValue> _properties;
        private final List<IdentifiableGenerationNumber> _generations;

        public ResultItemContent(List<PropertyValue> list, List<IdentifiableGenerationNumber> list2) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{list, list2});
            this._properties = list;
            this._generations = list2;
        }

        public List<PropertyValue> properties() {
            return this._properties;
        }

        public List<IdentifiableGenerationNumber> generations() {
            return this._generations;
        }
    }
}

