/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.search.CompositeConstraint;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.ConstraintFactory;
import com.vmware.vise.search.Match;
import com.vmware.vise.search.ObjectIdentityConstraint;
import com.vmware.vise.search.PropertyUnmarshaller;
import com.vmware.vise.search.QueryExecutionDetails;
import com.vmware.vise.search.QuerySpec;
import com.vmware.vise.search.RelationalConstraint;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.ResultSet;
import com.vmware.vise.search.SearchService;
import com.vmware.vise.search.ValueEx;
import com.vmware.vise.search.impl.ConstraintFactoryImpl;
import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.impl.QueryContext;
import com.vmware.vise.search.impl.QueryProcessorFactory;
import com.vmware.vise.search.impl.QueryRequest;
import com.vmware.vise.search.impl.QueryTransformer;
import com.vmware.vise.search.impl.ResponseSpecificUnmarshallerDirectory;
import com.vmware.vise.search.impl.ResultSetProcessor;
import com.vmware.vise.search.impl.SearchServiceExtensionRegistryInternal;
import com.vmware.vise.search.impl.SpecUtil;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.transport.QueryService;
import com.vmware.vise.search.transport.QueryServiceDisposedException;
import com.vmware.vise.search.transport.QueryServiceException;
import com.vmware.vise.search.util.Config;
import com.vmware.vise.search.util.Disposable;
import com.vmware.vise.search.util.EventArgs;
import com.vmware.vise.search.util.EventListener;
import com.vmware.vise.search.util.QueryGenerator;
import com.vmware.vise.util.Directory;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.util.transform.Transformer;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProvider;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceDirectory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class SearchServiceImpl
implements SearchService,
EventListener<EventArgs> {
    private static final Log _logger = LogFactory.getLog(SearchServiceImpl.class);
    private static final ResultSet EMPTY_RESULT = SearchServiceImpl.createEmptyResult();
    private static final String SEARCH_SERVICE_LABEL_PREFIX = "searchService.";
    private final Object _syncObject = new Object();
    private final ArrayList<EventListener<EventArgs>> _listeners = new ArrayList();
    private final QueryProcessorFactory _queryProcessorFactory;
    private final MetadataDirectory _metadataDirectory;
    private final ConstraintFactory _constraintFactory;
    private final Directory<PropertyUnmarshaller> _unmarshallerDirectory;
    private final VcServiceDirectory _vcServiceDirectory;
    private final ResourceModelTypeProvider _resourceModelTypeProvider;

    SearchServiceImpl(SearchServiceExtensionRegistryInternal searchServiceExtensionRegistryInternal, VcServiceDirectory vcServiceDirectory, ResourceModelTypeProvider resourceModelTypeProvider) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{searchServiceExtensionRegistryInternal});
        this._metadataDirectory = searchServiceExtensionRegistryInternal.getMetadataDirectory();
        this._constraintFactory = new ConstraintFactoryImpl();
        this._unmarshallerDirectory = searchServiceExtensionRegistryInternal.getUnmarshallerDirectory();
        this._vcServiceDirectory = vcServiceDirectory;
        this._resourceModelTypeProvider = resourceModelTypeProvider;
        this._queryProcessorFactory = new QueryProcessorFactory(searchServiceExtensionRegistryInternal, this._constraintFactory);
    }

    @Override
    public MetadataDirectory getMetadataDirectory() {
        return this._metadataDirectory;
    }

    @Override
    public ConstraintFactory getConstraintFactory() {
        return this._constraintFactory;
    }

    @Override
    public QueryGenerator getQueryGenerator() {
        return this._queryProcessorFactory.createGenerator(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet search(QueryService queryService, QuerySpec querySpec, ResponseSpec responseSpec) throws QueryServiceException, InterruptedException {
        Object object;
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryService, querySpec});
        QueryGenerator queryGenerator = this._queryProcessorFactory.createGenerator(queryService.getServiceVersion());
        QueryTransformer queryTransformer = this._queryProcessorFactory.createTransformer(queryService.getServiceVersion());
        ExecutionProfiler executionProfiler = SessionUtil.getExecutionProfiler();
        String string = SEARCH_SERVICE_LABEL_PREFIX + querySpec.name + ".xqueryGeneration";
        Object object2 = executionProfiler.startTimer(string);
        QueryRequest queryRequest = null;
        String string2 = null;
        try {
            queryRequest = this.getModifiedQuery(queryTransformer, querySpec, responseSpec);
            this.validatedQuery(queryRequest, querySpec, responseSpec);
            string2 = queryGenerator.generate(queryRequest.querySpec, queryRequest.responseSpec);
        }
        finally {
            executionProfiler.stopTimer(object2);
        }
        Disposable disposable = null;
        try {
            Object object3;
            Object object4;
            QueryExecutionDetails queryExecutionDetails;
            Set<String> set;
            Collection<InputStream> collection;
            QueryContext queryContext = this.buildQueryContext(querySpec);
            object = SEARCH_SERVICE_LABEL_PREFIX + querySpec.name + ".runQuery";
            object2 = executionProfiler.startTimer((String)object);
            disposable = queryService.query(string2, queryRequest.querySpec.options, queryContext);
            executionProfiler.stopTimer(object2);
            if (disposable == null) {
                ResultSet resultSet = EMPTY_RESULT;
                return resultSet;
            }
            String string3 = SEARCH_SERVICE_LABEL_PREFIX + querySpec.name + ".processResults";
            object2 = executionProfiler.startTimer(string3);
            ResponseSpecificUnmarshallerDirectory responseSpecificUnmarshallerDirectory = new ResponseSpecificUnmarshallerDirectory(this._unmarshallerDirectory, disposable.getUnmarshaller(), this._resourceModelTypeProvider);
            ResultSetProcessor resultSetProcessor = this._queryProcessorFactory.createResultSetProcessor(queryService.getServiceVersion(), responseSpecificUnmarshallerDirectory, queryRequest);
            ValueEx<ResultSet> valueEx = resultSetProcessor.getResultSet(collection = disposable.getResponseStreams(), set = (queryExecutionDetails = disposable.getQueryExecutionDetails()) != null ? queryExecutionDetails.getQueriedServices() : null);
            ResultSet resultSet = valueEx.getValue();
            Exception exception = resultSet.getError();
            if (exception != null) {
                object4 = SpecUtil.toString(querySpec.options);
                object3 = String.format("Error de-serializing result for query: %1$s\n%2$s\n", string2, object4);
                _logger.error(object3, (Throwable)exception);
            }
            object4 = valueEx.getExceptions();
            this.logMessageAboutInternalErrors(querySpec, responseSpec, (Collection<? extends Exception>)object4);
            executionProfiler.stopTimer(object2);
            object2 = null;
            object3 = resultSet;
            return object3;
        }
        catch (QueryServiceDisposedException queryServiceDisposedException) {
            _logger.warn((Object)"Query service already logged-out or disposed. Cannot run query.");
            object = EMPTY_RESULT;
            return object;
        }
        finally {
            try {
                executionProfiler.stopTimer(object2);
            }
            catch (Exception exception) {
                _logger.error((Object)("Failed to stop timer '" + object2 + "'"), (Throwable)exception);
            }
            if (disposable != null) {
                disposable.dispose();
            }
        }
    }

    private QueryRequest getModifiedQuery(QueryTransformer queryTransformer, QuerySpec querySpec, ResponseSpec responseSpec) {
        QueryRequest queryRequest = new QueryRequest(querySpec, responseSpec);
        Transformer.Result<QueryRequest> result = queryTransformer.transform(queryRequest);
        QueryRequest queryRequest2 = (QueryRequest)result.getData();
        return queryRequest2;
    }

    private void validatedQuery(QueryRequest queryRequest, QuerySpec querySpec, ResponseSpec responseSpec) {
        ConstraintInternal constraintInternal;
        int n;
        if (queryRequest.querySpec != null && queryRequest.querySpec.constraint != null && queryRequest.querySpec.constraint instanceof ConstraintInternal && (n = (constraintInternal = (ConstraintInternal)queryRequest.querySpec.constraint).getNumberOfNestedConstraints()) > Config.MAXIMUM_NUMBER_OF_NESTED_CONSTRAINTS_PER_QUERY) {
            String string = "The query contains too many nested constraints: " + n + ". Recommended maximum: " + Config.MAXIMUM_NUMBER_OF_NESTED_CONSTRAINTS_PER_QUERY + ". Query will be allowed to execute but it is recommended to generate queries that are within the limits.";
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)(string + "\n" + SpecUtil.toString(querySpec) + "\n" + SpecUtil.toString(responseSpec)));
            }
        }
    }

    private QueryContext buildQueryContext(QuerySpec querySpec) {
        assert (querySpec != null);
        VcService vcService = this.getConstrainedVcService(querySpec.constraint);
        QueryContext queryContext = new QueryContext(vcService);
        return queryContext;
    }

    private void logMessageAboutInternalErrors(QuerySpec querySpec, ResponseSpec responseSpec, Collection<? extends Exception> collection) {
        if (collection != null && collection.size() > 0) {
            _logger.error((Object)("Internal errors occurred while processing query:\n" + SpecUtil.toString(querySpec) + "\n" + SpecUtil.toString(responseSpec)));
        }
    }

    private static String getServerGuid(Object object) {
        if (object == null) {
            return null;
        }
        String string = QueryUtil.getReferenceServerGuid((Object)object);
        return string;
    }

    private VcService getVcService(Object object) {
        if (object == null) {
            return null;
        }
        String string = SearchServiceImpl.getServerGuid(object);
        if (string == null) {
            return null;
        }
        Set set = this._vcServiceDirectory.findVcGuidsByServiceGuid(string);
        if (set == null || set.size() != 1) {
            return null;
        }
        string = (String)set.iterator().next();
        VcService vcService = VimSessionUtil.getService((String)string);
        return vcService;
    }

    private VcService getConstrainedVcService(Constraint constraint) {
        if (constraint instanceof PropertyConstraint) {
            return null;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            VcService vcService = this.getVcService(objectIdentityConstraint.getTarget());
            return vcService;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            Constraint constraint2 = relationalConstraint.getNestedConstraint();
            VcService vcService = this.getConstrainedVcService(constraint2);
            return vcService;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            VcService vcService = this.getConstrainedVcServiceFromCompositeConstraint(compositeConstraint);
            return vcService;
        }
        return null;
    }

    private VcService getConstrainedVcServiceFromCompositeConstraint(CompositeConstraint compositeConstraint) {
        assert (compositeConstraint != null);
        Constraint[] constraintArray = compositeConstraint.getNestedConstraints();
        if (constraintArray == null || constraintArray.length == 0) {
            return null;
        }
        ConstraintConjoiner constraintConjoiner = compositeConstraint.getConjoiner();
        VcService vcService = null;
        if (constraintConjoiner == ConstraintConjoiner.EXCEPT) {
            VcService vcService2 = this.getConstrainedVcService(constraintArray[0]);
            return vcService2;
        }
        for (Constraint constraint : constraintArray) {
            VcService vcService3 = this.getConstrainedVcService(constraint);
            if (vcService3 == null) {
                if (constraintConjoiner != ConstraintConjoiner.OR) continue;
                return null;
            }
            if (constraintConjoiner == ConstraintConjoiner.AND) {
                return vcService3;
            }
            if (vcService != null && !vcService.equals(vcService3)) {
                return null;
            }
            vcService = vcService3;
        }
        return vcService;
    }

    @Override
    public void update(Object object, EventArgs eventArgs) {
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(EventListener<EventArgs> eventListener) {
        Object object = this._syncObject;
        synchronized (object) {
            this._listeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(EventListener<EventArgs> eventListener) {
        Object object = this._syncObject;
        synchronized (object) {
            this._listeners.remove(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        ArrayList<EventListener<EventArgs>> arrayList = new ArrayList<EventListener<EventArgs>>();
        Iterator iterator = this._syncObject;
        synchronized (iterator) {
            arrayList.addAll(this._listeners);
        }
        for (EventListener eventListener : arrayList) {
            eventListener.update(this, EventArgs.empty);
        }
    }

    private static ResultSet createEmptyResult() {
        ResultSet resultSet = new ResultSet(){

            @Override
            public List<Match> getMatches() {
                return Collections.emptyList();
            }

            @Override
            public List<FacetInfo> getFacetInfos() {
                return Collections.emptyList();
            }

            @Override
            public int getMatchCount() {
                return 0;
            }

            @Override
            public Exception getError() {
                return null;
            }

            @Override
            public Set<String> getQueriedServices() {
                return Collections.emptySet();
            }

            @Override
            public Set<String> getIncludedServices() {
                return Collections.emptySet();
            }

            @Override
            public boolean getSorted() {
                return true;
            }

            @Override
            public boolean getPaged() {
                return true;
            }
        };
        return resultSet;
    }
}

