/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.metadata.ObjectModelProvider;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.util.xml.NamespaceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class VmodlProvider
implements ObjectModelProvider {
    private static final String DEFAULT_VMODL_TYPE_ID = Object.class.getSimpleName();
    private static final String[] NO_SUPER_TYPES = new String[0];
    private final int CACHE_MAX_ENTRIES = 1000;
    private final float CACHE_LOAD_FACTOR = 0.75f;
    private final boolean CACHE_ACCESS_ORDER = true;
    private final Map<Class<?>, TypeInfo> _superTypesCache;

    VmodlProvider() {
        LinkedHashMap linkedHashMap = new LinkedHashMap<Class<?>, TypeInfo>(1000, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Class<?>, TypeInfo> entry) {
                return this.size() > 1000;
            }
        };
        this._superTypesCache = Collections.synchronizedMap(linkedHashMap);
    }

    public String[] getSuperTypes(String string) {
        String[] stringArray;
        TypeInfo typeInfo = this.getSuperTypesFromTypeName(string);
        if (typeInfo == null) {
            stringArray = NO_SUPER_TYPES;
        } else {
            stringArray = new String[typeInfo.supertypes.size()];
            typeInfo.supertypes.toArray(stringArray);
        }
        return stringArray;
    }

    public String getImmediateSuperType(String string) {
        TypeInfo typeInfo = this.getSuperTypesFromTypeName(string);
        String string2 = typeInfo == null ? null : typeInfo.immediateSupertype;
        return string2;
    }

    private TypeInfo getSuperTypesFromTypeName(String string) {
        String string2 = NamespaceUtil.getUnqualifiedTypeName((String)string);
        Class<?> clazz = VmodlProvider.wsdlNameToBindingType(string2);
        TypeInfo typeInfo = clazz != null ? this.getSuperTypesFromClassDef(clazz) : null;
        return typeInfo;
    }

    private static Class<?> wsdlNameToBindingType(String string) {
        if (Strings.isNullOrEmpty(string)) {
            return null;
        }
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(string);
        if (vmodlType == null) {
            return null;
        }
        return vmodlType.getTypeClass();
    }

    private TypeInfo getSuperTypesFromClassDef(Class<?> clazz) {
        Class<?>[] classArray;
        assert (clazz != null);
        TypeInfo typeInfo = this._superTypesCache.get(clazz);
        if (typeInfo != null) {
            return typeInfo;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string = null;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            String string2 = VmodlProvider.bindingTypeToWsdlName(clazz2);
            linkedHashSet.add(string2);
            Set<String> set = this.getSuperTypesFromClassDef(clazz2).supertypes;
            linkedHashSet.addAll(set);
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            string = VmodlProvider.bindingTypeToWsdlName(clazz3);
            linkedHashSet.add(string);
            Set<String> set = this.getSuperTypesFromClassDef(clazz3).supertypes;
            linkedHashSet.addAll(set);
        }
        if (string == null && classArray.length == 1) {
            string = VmodlProvider.bindingTypeToWsdlName(classArray[0]);
        }
        if (!clazz.isInstance(Object.class)) {
            linkedHashSet.add(TypeRefUtils.ROOT_TYPEREF.getName());
        }
        typeInfo = new TypeInfo();
        typeInfo.supertypes = linkedHashSet;
        typeInfo.immediateSupertype = string;
        this._superTypesCache.put(clazz, typeInfo);
        return typeInfo;
    }

    private static String bindingTypeToWsdlName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(clazz);
        if (vmodlType == null) {
            return DEFAULT_VMODL_TYPE_ID;
        }
        String string = vmodlType.getVersion().getNamespace();
        if (ManagedObjectUtil.isDefaultNamespace((String)string)) {
            return vmodlType.getWsdlName();
        }
        String string2 = string + ":" + vmodlType.getWsdlName();
        return string2;
    }

    private static final class TypeInfo {
        Set<String> supertypes;
        String immediateSupertype;

        private TypeInfo() {
        }
    }
}

