/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.metadata.ChildNodeIndex;
import com.vmware.vise.search.metadata.FunctionDescriptor;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class FunctionDescriptorImpl
implements FunctionDescriptor {
    private static final boolean REQUIRED = false;
    private final String _name;
    private final String _definition;
    private final String[] _referencedFunctions;

    public FunctionDescriptorImpl(Node node) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{node});
        ChildNodeIndex childNodeIndex = new ChildNodeIndex(node);
        this._name = childNodeIndex.getStringValueFor("name", false);
        this._definition = childNodeIndex.getStringValueFor("expr", false);
        this._referencedFunctions = this.getIncludedFunctions(childNodeIndex);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDefinition() {
        return this._definition;
    }

    @Override
    public String[] getReferencedFunctionNames() {
        return this._referencedFunctions;
    }

    private String[] getIncludedFunctions(ChildNodeIndex childNodeIndex) {
        Collection<Node> collection = childNodeIndex.getNodes("includes");
        if (collection.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Node node : collection) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (1 != node2.getNodeType() || !"function".equals(node2.getNodeName())) continue;
                arrayList.add(node2.getTextContent());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

