/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.metadata.CodeFlavor;
import com.vmware.vise.search.metadata.DescriptorData;
import com.vmware.vise.search.metadata.DescriptorDirectoryStoreAccess;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.search.metadata.TypeDescriptorDirectory;
import com.vmware.vise.search.metadata.TypeDescriptorImpl;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TypeDescriptorDirectoryBase
implements TypeDescriptorDirectory,
DescriptorDirectoryStoreAccess<TypeDescriptor> {
    private static final Logger _logger = LoggerFactory.getLogger(TypeDescriptorDirectoryBase.class);
    private final ConcurrentMap<String, DescriptorData<TypeDescriptor>> _predefinedTypes = new ConcurrentHashMap<String, DescriptorData<TypeDescriptor>>();
    private final ConcurrentMap<String, DescriptorData<TypeDescriptor>> _autogenTypes = new ConcurrentHashMap<String, DescriptorData<TypeDescriptor>>();

    TypeDescriptorDirectoryBase() {
    }

    @Override
    public List<TypeDescriptor> getAllTypeDescriptors() {
        return this.getAllTypeDescriptors(true);
    }

    @Override
    public boolean hasDescriptor(String string) {
        return string != null && this.getDescriptorByKey(string, true) != null;
    }

    @Override
    public void addAll(Collection<TypeDescriptor> collection, MessageLocalizer messageLocalizer) {
        if (collection == null) {
            return;
        }
        for (TypeDescriptor typeDescriptor : collection) {
            if (typeDescriptor == null) {
                _logger.warn("Null TypeDescriptor ignored in the properties list.");
                continue;
            }
            DescriptorData<TypeDescriptor> descriptorData = new DescriptorData<TypeDescriptor>(typeDescriptor, messageLocalizer);
            this._predefinedTypes.put(typeDescriptor.getType(), descriptorData);
        }
    }

    @Override
    public void clearAll() {
        this._predefinedTypes.clear();
        this._autogenTypes.clear();
    }

    protected final List<TypeDescriptor> getAllTypeDescriptors(boolean bl) {
        List<TypeDescriptor> list = DescriptorData.extractDescriptors(this._predefinedTypes.values());
        if (bl) {
            list.addAll(DescriptorData.extractDescriptors(this._autogenTypes.values()));
        }
        return list;
    }

    protected final TypeDescriptor getDescriptorByKey(String string, boolean bl) {
        DescriptorData descriptorData;
        if (string == null) {
            string = TypeRefUtils.ROOT_TYPEREF.getName();
        }
        if ((descriptorData = (DescriptorData)this._predefinedTypes.get(string)) == null && bl) {
            descriptorData = (DescriptorData)this._autogenTypes.get(string);
        }
        return descriptorData != null ? (TypeDescriptor)descriptorData.getDescriptor() : null;
    }

    protected final TypeDescriptor createNewTypeDescriptor(String string, CodeFlavor codeFlavor) {
        TypeDescriptorImpl typeDescriptorImpl = new TypeDescriptorImpl(string, codeFlavor);
        DescriptorData<TypeDescriptorImpl> descriptorData = new DescriptorData<TypeDescriptorImpl>(typeDescriptorImpl, null);
        DescriptorData<TypeDescriptorImpl> descriptorData2 = this._autogenTypes.putIfAbsent(string, descriptorData);
        if (descriptorData2 != null) {
            descriptorData = descriptorData2;
        }
        return descriptorData.getDescriptor();
    }
}

