/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.transport.impl;

import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vise.search.QueryExecutionDetails;
import com.vmware.vise.search.auth.internal.AuthDataRegistryLocator;
import com.vmware.vise.search.impl.QueryContext;
import com.vmware.vise.search.transport.QueryOptions;
import com.vmware.vise.search.transport.QueryService;
import com.vmware.vise.search.transport.QueryServiceException;
import com.vmware.vise.search.transport.QueryServiceResult;
import com.vmware.vise.search.transport.impl.LinkedQueryServiceGroup;
import com.vmware.vise.search.transport.impl.LinkedQueryServiceImpl;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregatorQueryServiceImpl
implements QueryService {
    private static final Logger log = LoggerFactory.getLogger(AggregatorQueryServiceImpl.class);
    private final Map<VcService, QueryService> _standaloneServices;
    private final QueryService _startupService;
    private final ExecutorService _queryTasksPool;

    public AggregatorQueryServiceImpl(LinkedVcGroup linkedVcGroup, VcAwareSharedHttpConfigPool vcAwareSharedHttpConfigPool, ExecutorService executorService, PrivateKey privateKey, AuthDataRegistryLocator authDataRegistryLocator) {
        this._queryTasksPool = executorService;
        Collection collection = linkedVcGroup.getVcServices();
        this._standaloneServices = new HashMap<VcService, QueryService>(collection.size());
        for (VcService vcService : collection) {
            LinkedQueryServiceImpl linkedQueryServiceImpl = new LinkedQueryServiceImpl(LinkedQueryServiceGroup.createForStandalone(vcService), vcAwareSharedHttpConfigPool, privateKey, authDataRegistryLocator);
            this._standaloneServices.put(vcService, linkedQueryServiceImpl);
        }
        Object object = this._standaloneServices.get(linkedVcGroup.getStartUpVcService());
        if (object == null) {
            VcService vcService;
            vcService = linkedVcGroup.getStartUpVcService();
            log.warn("In supplied LinkedVcGroup startup VC service {} was not present in the service list. This may indicate problem with vCenter Lookup Service records.", (Object)vcService.getServiceUrl());
            object = new LinkedQueryServiceImpl(LinkedQueryServiceGroup.createForStandalone(vcService), vcAwareSharedHttpConfigPool, privateKey, authDataRegistryLocator);
            this._standaloneServices.put(vcService, (QueryService)object);
            this._startupService = object;
        } else {
            this._startupService = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryServiceResult query(String string, QueryOptions queryOptions, QueryContext queryContext) throws QueryServiceException, InterruptedException {
        Collection<QueryService> collection;
        VcService vcService = queryContext.getTargetSpecificVcService();
        if (vcService != null) {
            QueryService queryService = this._standaloneServices.get(vcService);
            if (queryService == null) {
                log.debug("Returning empty result for query which targets VC without query service: VcService(guid={}, url={}, version={})", new Object[]{vcService.getServiceGuid(), vcService.getServiceUrl(), vcService.getServiceVersion()});
                return null;
            }
            log.debug("Dispatching query which targets VcService(guid={}, url={}, version={})", new Object[]{vcService.getServiceGuid(), vcService.getServiceUrl(), vcService.getServiceVersion()});
            collection = Collections.singletonList(queryService);
        } else if (!queryOptions.federated) {
            log.debug("Dispatching non-federated query which targets no specific VC to startup query service");
            collection = Collections.singletonList(this._startupService);
        } else {
            log.debug("Dispatching federated query to all query services");
            collection = this._standaloneServices.values();
        }
        boolean bl = queryOptions.federated;
        queryOptions.federated = false;
        try {
            List<QueryServiceResult> list = this.collectResultsFromServices(collection, string, queryOptions, queryContext);
            if (list.isEmpty()) {
                throw new QueryServiceException("No Inventory Service responded to query.");
            }
            AggregatedResultImpl aggregatedResultImpl = new AggregatedResultImpl(list);
            return aggregatedResultImpl;
        }
        finally {
            queryOptions.federated = bl;
        }
    }

    private List<QueryServiceResult> collectResultsFromServices(Collection<QueryService> collection, final String string, final QueryOptions queryOptions, final QueryContext queryContext) throws QueryServiceException, InterruptedException {
        if (collection.size() == 1) {
            QueryService queryService = collection.iterator().next();
            return Collections.singletonList(queryService.query(string, queryOptions, queryContext));
        }
        ArrayList<1> arrayList = new ArrayList<1>(collection.size());
        final QueryServiceResult[] queryServiceResultArray = new QueryServiceResult[collection.size()];
        final HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        int n = 0;
        for (final QueryService queryServiceResultArray2 : collection) {
            final int n2 = n++;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        QueryServiceResult queryServiceResult;
                        SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
                        queryServiceResultArray[n2] = queryServiceResult = queryServiceResultArray2.query(string, queryOptions, queryContext);
                    }
                    catch (Exception exception) {
                        log.info(String.format("QueryService %s failed to respond: %s: %s", queryServiceResultArray2, exception.getClass().getName(), exception.getMessage()), (Throwable)exception);
                    }
                    finally {
                        SessionUtil.setHttpRequest(null);
                    }
                }
            };
            arrayList.add(runnable);
        }
        ExecutorUtil.executeTasks(arrayList, (Executor)this._queryTasksPool);
        ArrayList arrayList2 = new ArrayList(collection.size());
        for (QueryServiceResult queryServiceResult : queryServiceResultArray) {
            if (queryServiceResult == null) continue;
            arrayList2.add(queryServiceResult);
        }
        return arrayList2;
    }

    @Override
    public void dispose() {
        for (QueryService queryService : this._standaloneServices.values()) {
            queryService.dispose();
        }
    }

    @Override
    public String getServiceVersion() {
        return this._startupService.getServiceVersion();
    }

    @Override
    public boolean isMultiVc() {
        return this._standaloneServices.size() > 1;
    }

    private static final class AggregatedResultImpl
    implements QueryServiceResult {
        private final List<QueryServiceResult> _results;
        private final List<InputStream> _responseStreams;
        private final QueryExecutionDetails _executionDetails;
        private boolean _isRead = false;

        public AggregatedResultImpl(List<QueryServiceResult> list) {
            this._results = list;
            this._responseStreams = new ArrayList<InputStream>();
            HashSet<String> hashSet = new HashSet<String>();
            for (QueryServiceResult queryServiceResult : this._results) {
                hashSet.addAll(queryServiceResult.getQueryExecutionDetails().getQueriedServices());
            }
            this._executionDetails = new QueryExecutionDetails(hashSet);
        }

        @Override
        public Collection<InputStream> getResponseStreams() {
            if (!this._isRead) {
                for (QueryServiceResult queryServiceResult : this._results) {
                    this._responseStreams.addAll(queryServiceResult.getResponseStreams());
                }
                this._isRead = true;
            }
            return this._responseStreams;
        }

        @Override
        public Unmarshaller getUnmarshaller() {
            return this._results.get(0).getUnmarshaller();
        }

        @Override
        public QueryExecutionDetails getQueryExecutionDetails() {
            return this._executionDetails;
        }

        @Override
        public void dispose() {
            for (QueryServiceResult queryServiceResult : this._results) {
                queryServiceResult.dispose();
            }
        }
    }
}

