/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.transport.impl;

import com.vmware.vise.search.transport.impl.QueryServiceUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinkedQueryServiceGroup {
    private static final Logger log = LoggerFactory.getLogger(LinkedQueryServiceGroup.class);
    private final Deque<VcService> _groupServices;
    private final Set<String> _qsGuidsInGroup;
    private final String _startupServiceUrl;

    private LinkedQueryServiceGroup(Collection<VcService> collection, String string) {
        this._groupServices = new LinkedList<VcService>(collection);
        this._qsGuidsInGroup = Collections.unmodifiableSet(LinkedQueryServiceGroup.findQsGuidsInList(collection));
        this._startupServiceUrl = string;
        log.trace("LinkedQueryServiceGroup.c-tor service = {} ; QS guids = {}", this._groupServices, this._qsGuidsInGroup);
    }

    public synchronized VcService getCurrentService() {
        VcService vcService = this._groupServices.peek();
        return vcService;
    }

    public synchronized VcService nextService(VcService vcService) {
        Validate.notNull((Object)vcService);
        if (vcService != this._groupServices.peek()) {
            VcService vcService2 = this._groupServices.peek();
            return vcService2;
        }
        this._groupServices.add(this._groupServices.remove());
        VcService vcService3 = this._groupServices.peek();
        return vcService3;
    }

    public Set<String> getQueryServiceGuidsInGroup() {
        return this._qsGuidsInGroup;
    }

    public String getStartupServiceUrl() {
        return this._startupServiceUrl;
    }

    public synchronized boolean containsService(VcService vcService) {
        Validate.notNull((Object)vcService);
        return this._groupServices.contains(vcService);
    }

    public static LinkedQueryServiceGroup createForLinkedGroup(LinkedVcGroup linkedVcGroup) {
        Collection collection = linkedVcGroup.getVcServices();
        if (collection.isEmpty()) {
            VcService vcService = linkedVcGroup.getStartUpVcService();
            String string = vcService != null ? vcService.getServiceUrl() : "???";
            throw new IllegalStateException(LinkedVcGroup.class.getSimpleName() + " " + string + " doesn't contain any active VC services. Check the log to find out the reason.");
        }
        return new LinkedQueryServiceGroup(collection, QueryServiceUtil.getUri(linkedVcGroup.getStartUpVcService()));
    }

    public static LinkedQueryServiceGroup createForStandalone(VcService vcService) {
        return new LinkedQueryServiceGroup(Collections.singleton(vcService), QueryServiceUtil.getUri(vcService));
    }

    private static Set<String> findQsGuidsInList(Collection<VcService> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (VcService vcService : collection) {
            String string = vcService.getServiceGuid();
            for (ServiceEndpointEx serviceEndpointEx : vcService.getServiceEndPoints()) {
                if (serviceEndpointEx.getServiceEndpointType() != ServiceEndpointType.IS || !ObjectUtils.equals((Object)serviceEndpointEx.getVcGuid(), (Object)string)) continue;
                String string2 = serviceEndpointEx.instanceUuid;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }
}

