/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.transport.impl;

import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vise.search.QueryExecutionDetails;
import com.vmware.vise.search.auth.internal.AuthDataRegistryLocator;
import com.vmware.vise.search.impl.QueryContext;
import com.vmware.vise.search.transport.QueryOptions;
import com.vmware.vise.search.transport.QueryService;
import com.vmware.vise.search.transport.QueryServiceException;
import com.vmware.vise.search.transport.QueryServiceResult;
import com.vmware.vise.search.transport.impl.LinkedQueryServiceGroup;
import com.vmware.vise.search.transport.impl.QueryRequest;
import com.vmware.vise.search.transport.impl.QueryServiceCaller;
import com.vmware.vise.search.transport.impl.QueryServiceClientPool;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.BlockingCounter;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedQueryServiceImpl
implements QueryService {
    private static final int GLOBAL_MAX_RETRIES = 3;
    private static final Logger _logger = LoggerFactory.getLogger(LinkedQueryServiceImpl.class);
    private static final long SHUT_DOWN_WAIT_TIME = 2L;
    private static final TimeUnit SHUT_DOWN_TIME_UNIT = TimeUnit.MINUTES;
    private final BlockingCounter _openRequests = new BlockingCounter();
    private final int _retries;
    private final LinkedQueryServiceGroup _vcServiceGroup;
    private final QueryServiceClientPool _queryServiceClientPool;
    private final AtomicBoolean _disposeInvoked = new AtomicBoolean(false);
    private final boolean _isMultiVc;

    public LinkedQueryServiceImpl(LinkedQueryServiceGroup linkedQueryServiceGroup, VcAwareSharedHttpConfigPool vcAwareSharedHttpConfigPool, PrivateKey privateKey, AuthDataRegistryLocator authDataRegistryLocator) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{linkedQueryServiceGroup});
        this._vcServiceGroup = linkedQueryServiceGroup;
        this._queryServiceClientPool = new QueryServiceClientPool(vcAwareSharedHttpConfigPool, privateKey, authDataRegistryLocator);
        int n = linkedQueryServiceGroup.getQueryServiceGuidsInGroup().size();
        this._isMultiVc = n > 1;
        this._retries = Math.min(3, n);
    }

    @Override
    public QueryServiceResult query(String string, QueryOptions queryOptions, QueryContext queryContext) throws QueryServiceException, InterruptedException {
        if (this._retries == 0) {
            return null;
        }
        VcService vcService = queryContext.getTargetSpecificVcService();
        if (vcService != null && !this._vcServiceGroup.containsService(vcService)) {
            return null;
        }
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, queryOptions});
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.xquery = string;
        queryRequest.options = queryOptions;
        queryRequest.retries = this._retries;
        Pair<InputStream, QueryExecutionDetails> pair = this.executeRequest(queryRequest, queryContext);
        InputStream inputStream = (InputStream)pair.first;
        QueryExecutionDetails queryExecutionDetails = (QueryExecutionDetails)pair.second;
        QueryServiceResultImpl queryServiceResultImpl = new QueryServiceResultImpl(inputStream, queryRequest.vcService.getDeserializer(), queryExecutionDetails);
        return queryServiceResultImpl;
    }

    @Override
    public void dispose() {
        boolean bl = this._disposeInvoked.getAndSet(true);
        if (bl) {
            _logger.warn("Method dispose() has already been invoked.");
            return;
        }
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SessionUtil.ThreadContext threadContext2 = SessionUtil.getThreadContext((boolean)false);
                SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                String string = "?";
                String string2 = "?";
                try {
                    string = LinkedQueryServiceImpl.class.getSimpleName();
                    string2 = LinkedQueryServiceImpl.this._vcServiceGroup.getStartupServiceUrl();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    _logger.info("Shutting down " + string + " " + string2);
                    boolean bl = LinkedQueryServiceImpl.this._openRequests.blockUntilEmpty(2L, SHUT_DOWN_TIME_UNIT);
                    if (!bl) {
                        _logger.warn("There are still ongoing queries but the shutdown will not wait any longer and will close the connection(s) to the Inventory Service(s). This will cause the queries to fail and the log will contain query failure reports.");
                    }
                    LinkedQueryServiceImpl.this._queryServiceClientPool.shutdown();
                    _logger.info("Done shutting down " + string + " " + string2);
                }
                catch (Exception exception) {
                    _logger.info("Failed to shut down " + string + " " + string2, (Throwable)exception);
                }
                finally {
                    SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext2);
                }
            }
        };
        WorkerThreadFactory workerThreadFactory = new WorkerThreadFactory("LinkedQrySvcImpl-dispose");
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolFactory.newFixedThreadPool((int)1, (ThreadFactory)workerThreadFactory);
        threadPoolExecutor.execute(runnable);
        threadPoolExecutor.shutdown();
    }

    @Override
    public String getServiceVersion() {
        return this._vcServiceGroup.getCurrentService().getServiceVersion();
    }

    @Override
    public boolean isMultiVc() {
        return this._isMultiVc;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LinkedQueryService(").append(this._vcServiceGroup.getStartupServiceUrl()).append(")");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<InputStream, QueryExecutionDetails> executeRequest(QueryRequest queryRequest, QueryContext queryContext) throws QueryServiceException, InterruptedException {
        assert (queryRequest != null);
        boolean bl = queryRequest.options.federated;
        QueryServiceCaller queryServiceCaller = new QueryServiceCaller(this._vcServiceGroup, this._openRequests, this._queryServiceClientPool, this._vcServiceGroup.getQueryServiceGuidsInGroup(), queryRequest, queryContext);
        try {
            while (queryRequest.retries > 0) {
                --queryRequest.retries;
                InputStream inputStream = queryServiceCaller.attemptRequest();
                if (inputStream == null) continue;
                QueryExecutionDetails queryExecutionDetails = new QueryExecutionDetails(queryServiceCaller.getQueriedServices());
                Pair pair = new Pair((Object)inputStream, (Object)queryExecutionDetails);
                return pair;
            }
        }
        finally {
            queryRequest.options.federated = bl;
        }
        throw new QueryServiceException(queryRequest.xquery, this._vcServiceGroup.getStartupServiceUrl(), "Query failed.", queryServiceCaller.getLastError());
    }

    private class QueryServiceResultImpl
    implements QueryServiceResult {
        private final InputStream _stream;
        private final Unmarshaller _unmarshaller;
        private final QueryExecutionDetails _queryExecutionDetails;
        private boolean _isRead = false;
        private boolean _isDisposed = false;

        QueryServiceResultImpl(InputStream inputStream, Unmarshaller unmarshaller, QueryExecutionDetails queryExecutionDetails) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{inputStream, unmarshaller});
            this._stream = inputStream;
            this._unmarshaller = unmarshaller;
            this._queryExecutionDetails = queryExecutionDetails;
        }

        @Override
        public Collection<InputStream> getResponseStreams() {
            if (this._isRead) {
                return Collections.singleton(this._stream);
            }
            this._isRead = true;
            boolean bl = LinkedQueryServiceImpl.this._openRequests.increment();
            if (!bl) {
                throw new IllegalStateException("query service is disposed");
            }
            return Collections.singleton(this._stream);
        }

        @Override
        public Unmarshaller getUnmarshaller() {
            return this._unmarshaller;
        }

        @Override
        public QueryExecutionDetails getQueryExecutionDetails() {
            return this._queryExecutionDetails;
        }

        @Override
        public void dispose() {
            if (this._isDisposed) {
                return;
            }
            this._isDisposed = true;
            try {
                this._stream.close();
                _logger.debug("Result stream was closed successfully.");
            }
            catch (IOException iOException) {
                _logger.error("Error closing result stream.", (Throwable)iOException);
            }
            finally {
                LinkedQueryServiceImpl.this._openRequests.decrement();
            }
        }
    }
}

