/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.transport.impl;

import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.query.client.QueryDispatcher;
import com.vmware.vim.query.client.impl.QueryDispatcherImpl;
import com.vmware.vise.search.transport.QueryOptions;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public final class QueryServiceUtil {
    private static final String ENDPOINT_NOT_FOUND_ERROR = "inventory-service-endpoint-not-found-error";
    private static final String FORCE_PROVIDER_SYNC_OPTION_KEY = QueryDispatcherImpl.InternalOption.SYNC_PROVIDER.name();
    private static final String PROVIDERS_TO_SYNC_KEY = QueryDispatcherImpl.InternalOption.PROVIDERS_TO_SYNC.name();
    private static final String TIMEOUT_KEY = QueryDispatcherImpl.InternalOption.TIMEOUT.name();

    public static ServiceEndpointEx getInventoryServiceEndpoint(VcService vcService) {
        String string = vcService.getServiceGuid();
        for (ServiceEndpointEx serviceEndpointEx : vcService.getServiceEndPoints()) {
            String string2;
            ServiceEndpointType serviceEndpointType = serviceEndpointEx.getServiceEndpointType();
            if (serviceEndpointType != ServiceEndpointType.IS || !string.equals(string2 = serviceEndpointEx.getVcGuid())) continue;
            return serviceEndpointEx;
        }
        throw MixedUtil.getRuntimeFault((String)ENDPOINT_NOT_FOUND_ERROR);
    }

    public static String getSearchUrl(ServiceDirectory.ServiceEndpoint serviceEndpoint, VcService vcService) {
        String string = serviceEndpoint.getUrl();
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (uRI == null) {
            return string;
        }
        try {
            InetAddress.getByName(uRI.getHost());
            return string;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {
            return string;
        }
        String string2 = null;
        if (vcService != null) {
            string2 = vcService.getServiceUrl();
        }
        try {
            URI uRI2 = new URI(string2);
            String string3 = uRI2.getHost();
            String string4 = uRI.getHost();
            string = string.replaceFirst(string4, string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return string;
    }

    public static boolean areEqual(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    static Map<String, Object> transformQueryOptions(QueryOptions queryOptions, int n) {
        boolean bl;
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryOptions});
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!Strings.isNullOrEmpty(queryOptions.targetSpecificProviderName)) {
            hashMap.put(QueryDispatcher.QueryOption.TARGET_SPECIFIC_PRODUCT.name(), queryOptions.targetSpecificProviderName);
        }
        if (!Strings.isNullOrEmpty(queryOptions.targetSpecificProviderUuid)) {
            hashMap.put(QueryDispatcher.QueryOption.TARGET_SPECIFIC_UUID.name(), queryOptions.targetSpecificProviderUuid);
        }
        if (queryOptions.providersToSync != null && queryOptions.providersToSync.length > 0) {
            hashMap.put(PROVIDERS_TO_SYNC_KEY, queryOptions.providersToSync);
        }
        if (bl = queryOptions.forceProviderSync) {
            hashMap.put(FORCE_PROVIDER_SYNC_OPTION_KEY, Boolean.TRUE);
        }
        hashMap.put(QueryDispatcher.QueryOption.FEDERATED.name(), queryOptions.federated);
        if (n > 0) {
            hashMap.put(TIMEOUT_KEY, n);
        }
        return hashMap;
    }

    static String getUri(VcService vcService) {
        if (vcService == null) {
            return null;
        }
        ServiceEndpointEx serviceEndpointEx = QueryServiceUtil.getInventoryServiceEndpoint(vcService);
        String string = QueryServiceUtil.getSearchUrl((ServiceDirectory.ServiceEndpoint)serviceEndpointEx, vcService);
        return string;
    }
}

