/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery;

import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.PrimaryExpression;

public final class FunctionExpression
implements PrimaryExpression {
    private final Expression[] _parameters;
    private final String _functionName;

    public FunctionExpression(String string, Expression ... expressionArray) {
        this._functionName = string;
        this._parameters = expressionArray;
    }

    @Override
    public String evaluate() {
        String[] stringArray = new String[this._parameters.length];
        int n = 0;
        for (Expression expression : this._parameters) {
            stringArray[n++] = expression.evaluate();
        }
        String string = Strings.join(",", stringArray);
        if (this._functionName != null && this._functionName.equals("lower-case")) {
            return String.format("(%1$s)/%2$s(.)", string, this._functionName);
        }
        return String.format("%1$s(%2$s)", this._functionName, string);
    }

    public final class Functions {
        public static final String COUNT = "count";
        public static final String NUMBER = "fn:number";
        public static final String LOWER_CASE = "lower-case";
        public static final String TRUE = "true";
        public static final String FALSE = "false";
        public static final String POSITION = "fn:position";
        public static final String DISTINCT_NODES = "fn:distinct-nodes";
        public static final String STARTS_WITH = "fn:starts-with";
        public static final String ENDS_WITH = "fn:ends-with";
        public static final String TOKENIZE_FUNCTION = "tokenize";
        public static final String FTS = "xhive:fts";
        public static final String NOT = "not";
        public static final String EXISTS = "exists";
    }
}

