/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery;

import com.vmware.vise.search.xquery.ComparisonExpression;
import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.FunctionExpression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.LogicalExpression;

public class RangeExpression
implements Expression {
    public static final int XQUERY_START_INDEX = 1;
    private static final Expression POSITION_FUNCTION = new FunctionExpression("fn:position", new Expression[0]);
    private final int _startIndex;
    private final int _endIndex;

    public RangeExpression(int n) {
        this._startIndex = this._endIndex = n;
    }

    public RangeExpression(int n, int n2) {
        this._startIndex = n;
        this._endIndex = n2;
    }

    @Override
    public String evaluate() {
        Expression expression = null;
        LiteralExpression literalExpression = new LiteralExpression(String.valueOf(this._startIndex));
        LiteralExpression literalExpression2 = new LiteralExpression(String.valueOf(this._endIndex));
        if (this._startIndex == this._endIndex) {
            expression = literalExpression;
        } else if (this._startIndex > this._endIndex) {
            expression = new ComparisonExpression(POSITION_FUNCTION, ComparisonExpression.Operator.GREATER_OR_EQUALS, literalExpression);
        } else if (this._startIndex <= 1) {
            expression = new ComparisonExpression(POSITION_FUNCTION, ComparisonExpression.Operator.LESS_OR_EQUALS, literalExpression2);
        } else {
            ComparisonExpression comparisonExpression = new ComparisonExpression(POSITION_FUNCTION, ComparisonExpression.Operator.GREATER_OR_EQUALS, literalExpression);
            ComparisonExpression comparisonExpression2 = new ComparisonExpression(POSITION_FUNCTION, ComparisonExpression.Operator.LESS_OR_EQUALS, literalExpression2);
            expression = new LogicalExpression(LogicalExpression.Operator.AND, comparisonExpression, comparisonExpression2);
        }
        return expression.evaluate();
    }
}

