/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.search.OrderingCriteria;
import com.vmware.vise.search.OrderingPropertySpec;
import com.vmware.vise.search.QueryContextType;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.impl.PropertySpecExprBuilder;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.xquery.ConditionalExpression;
import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.FunctionExpression;
import com.vmware.vise.search.xquery.LetClauseExpression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.LogicalExpression;
import com.vmware.vise.search.xquery.PredicatedExpression;
import com.vmware.vise.search.xquery.PrimaryExpression;
import com.vmware.vise.search.xquery.RangeExpression;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.search.xquery.render.PropertyRenderer;
import com.vmware.vise.search.xquery.render.RendererFactory;
import com.vmware.vise.search.xquery.render.ReturnClauseGenerator;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public abstract class ModelAwareReturnClauseGenerator
implements ReturnClauseGenerator {
    private static final String RESULT_SORTED_FORMAT = "<%1$s:%2$s>{%3$s}</%1$s:%2$s>";
    private final MetadataDirectory _metadataDirectory;
    private final RendererFactory _rendererFactory;
    private final String _varQualifier;
    protected static final String ORDERED_TARGET_SET_ID = "orderedTargetSet";
    protected static final String RESULT_SORTED_FLAG_ID = "resultSortedFlag";
    protected static final String RET_TARGET_RESOURCE_ID = "resourceId";
    protected static final String RET_TARGET_DOCUMENT_ID = "targetDocId";
    protected static final String RET_ITEMS = "items";

    protected ModelAwareReturnClauseGenerator(MetadataDirectory metadataDirectory, RendererFactory rendererFactory, String string) {
        Validate.notNull((Object)metadataDirectory, (String)"metadataDir");
        this._metadataDirectory = metadataDirectory;
        this._rendererFactory = rendererFactory;
        this._varQualifier = string;
    }

    protected abstract String createOrderingIterationClause(OrderingCriteria var1);

    protected abstract String createOrderingReturnExpr();

    protected abstract String createReturnIterationClause(ResponseSpec var1);

    @Override
    public final String generate(ResponseSpec responseSpec) {
        if (responseSpec.maxResultsCount == 0) {
            return this.createEmptyReturnClause();
        }
        String string = this.generateOrderingClause(responseSpec.orderingCriteria);
        String string2 = this.createReturnSetDefn(responseSpec);
        return string + "\n\n" + string2;
    }

    protected final String qualifiedVarName(String string) {
        String string2 = StringUtils.isEmpty((String)this._varQualifier) ? string : this._varQualifier + StringUtils.capitalize((String)string);
        return string2;
    }

    protected final String applyPagingToTargetSet(ResponseSpec responseSpec, String string) {
        Expression expression;
        Expression expression2;
        int n;
        Expression expression3;
        VarRefExpression varRefExpression = new VarRefExpression(string);
        if (responseSpec.maxResultsCount == 0) {
            expression3 = new PredicatedExpression(varRefExpression, new LiteralExpression("0"));
        } else if (responseSpec.maxResultsCount > 0) {
            n = responseSpec.offset;
            int n2 = n + responseSpec.maxResultsCount - 1;
            expression2 = new RangeExpression(n, n2);
            expression3 = new PredicatedExpression(varRefExpression, expression2);
        } else if (responseSpec.offset > 1) {
            RangeExpression rangeExpression = new RangeExpression(responseSpec.offset, -1);
            expression3 = new PredicatedExpression(varRefExpression, rangeExpression);
        } else {
            expression3 = varRefExpression;
        }
        int n3 = n = responseSpec.orderingCriteria != null && (responseSpec.maxResultsCount > 0 || responseSpec.offset > 1) ? 1 : 0;
        if (n != 0) {
            expression2 = new VarRefExpression(this.qualifiedVarName(RESULT_SORTED_FLAG_ID));
            expression = new ConditionalExpression(expression2, expression3, varRefExpression);
        } else {
            expression = expression3;
        }
        return expression.evaluate();
    }

    private String generateOrderingClause(OrderingCriteria orderingCriteria) {
        Expression expression;
        String string;
        if (orderingCriteria != null) {
            string = this.createOrderingTargetSetDefn(orderingCriteria) + "\n";
            expression = this.createResultSortedExpr(orderingCriteria);
        } else {
            string = "";
            expression = new FunctionExpression("false", new Expression[0]);
        }
        String string2 = this.createResultSortedDefn(expression);
        return string + "\n" + string2;
    }

    private String createOrderingTargetSetDefn(OrderingCriteria orderingCriteria) {
        assert (orderingCriteria != null);
        PropertySpecExprBuilder propertySpecExprBuilder = new PropertySpecExprBuilder(orderingCriteria.applicableProperties, this._metadataDirectory, this._rendererFactory);
        String string = this.createOrderingIterationClause(orderingCriteria);
        VarRefExpression varRefExpression = new VarRefExpression(this.qualifiedVarName(ORDERED_TARGET_SET_ID));
        String string2 = propertySpecExprBuilder.getSetExprString();
        String string3 = this.createOrderingClause(propertySpecExprBuilder, orderingCriteria);
        String string4 = this.createOrderingReturnExpr();
        String string5 = String.format("let %1$s := %2$s%3$s\n%4$s\n  return %5$s", varRefExpression.evaluate(), string, string2, string3, string4);
        return string5;
    }

    private String createOrderingClause(PropertySpecExprBuilder propertySpecExprBuilder, OrderingCriteria orderingCriteria) {
        StringBuilder stringBuilder = new StringBuilder();
        if (orderingCriteria == null || orderingCriteria.applicableProperties.length <= 0) {
            return stringBuilder.toString();
        }
        stringBuilder.append("\n  order by");
        int n = 0;
        for (OrderingPropertySpec orderingPropertySpec : orderingCriteria.applicableProperties) {
            String string = propertySpecExprBuilder.getProviderIdFor(orderingPropertySpec);
            for (String string2 : orderingPropertySpec.properties) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                String string3 = this.createOrderingSubClause(orderingPropertySpec.sortType.name(), orderingPropertySpec.providerType, string, string2);
                stringBuilder.append(string3);
                ++n;
            }
        }
        String string = stringBuilder.toString();
        return string;
    }

    private String createOrderingSubClause(String string, String string2, String string3, String string4) {
        string = string.toLowerCase(Locale.ENGLISH);
        PropertyDescriptor propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string4, string2);
        PropertyRenderer propertyRenderer = this._rendererFactory.newOrderingPropertyRenderer();
        PropertyRenderer.PropertyRendererContext propertyRendererContext = new PropertyRenderer.PropertyRendererContext(propertyDescriptor, string3, null);
        propertyRenderer.setRendererContext(propertyRendererContext);
        String string5 = propertyRenderer.render();
        String string6 = String.format(" %1$s %2$s", string5, string);
        return string6;
    }

    private Expression createResultSortedExpr(OrderingCriteria orderingCriteria) {
        FunctionExpression functionExpression = new FunctionExpression("true", new Expression[0]);
        FunctionExpression functionExpression2 = new FunctionExpression("false", new Expression[0]);
        String string = String.format("%1$sSet", "target");
        Object[] objectArray = this.toOrderPropExprs(orderingCriteria, string);
        Expression expression = !ArrayUtil.isNullOrEmpty((Object[])objectArray) ? new ConditionalExpression(new LogicalExpression(LogicalExpression.Operator.AND, (Expression[])objectArray), functionExpression, functionExpression2) : functionExpression2;
        return expression;
    }

    private String createResultSortedDefn(Expression expression) {
        VarRefExpression varRefExpression = new VarRefExpression(this.qualifiedVarName(RESULT_SORTED_FLAG_ID));
        LetClauseExpression letClauseExpression = new LetClauseExpression(varRefExpression, expression);
        String string = String.format(RESULT_SORTED_FORMAT, "query", "resultSorted", varRefExpression.evaluate());
        VarRefExpression varRefExpression2 = new VarRefExpression(this.qualifiedVarName("resultSorted"));
        LetClauseExpression letClauseExpression2 = new LetClauseExpression(varRefExpression2, new LiteralExpression(string));
        return letClauseExpression.evaluate() + "\n" + letClauseExpression2.evaluate();
    }

    private Expression[] toOrderPropExprs(OrderingCriteria orderingCriteria, String string) {
        ArrayList<PrimaryExpression> arrayList = new ArrayList<PrimaryExpression>();
        for (OrderingPropertySpec orderingPropertySpec : orderingCriteria.applicableProperties) {
            for (String string2 : orderingPropertySpec.properties) {
                Object object;
                PropertyDescriptor propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string2, orderingPropertySpec.providerType);
                if (!MetadataUtil.isSupported(propertyDescriptor)) continue;
                if (propertyDescriptor.isComputed() || this._metadataDirectory.hasPreDefinedDescriptor(orderingPropertySpec.providerType, string2)) {
                    object = new FunctionExpression("true", new Expression[0]);
                    arrayList.add((PrimaryExpression)object);
                    continue;
                }
                object = MetadataUtil.getQueryExpression(propertyDescriptor, QueryContextType.CONTEXT_CURRENT);
                object = XQueryUtils.toQualifiedXPath(string, (String)object);
                arrayList.add(new LiteralExpression((String)object));
            }
        }
        Object[] objectArray = arrayList.toArray(new Expression[0]);
        return objectArray;
    }

    private String createReturnSetDefn(ResponseSpec responseSpec) {
        PropertySpecExprBuilder propertySpecExprBuilder = new PropertySpecExprBuilder(responseSpec.propertiesToRetrieve, this._metadataDirectory, this._rendererFactory);
        VarRefExpression varRefExpression = new VarRefExpression(this.qualifiedVarName(RET_ITEMS));
        String string = this.createReturnIterationClause(responseSpec);
        String string2 = propertySpecExprBuilder.getSetExprString();
        String string3 = propertySpecExprBuilder.getReturnExprString();
        String string4 = String.format("let %s := %s%s\n  %s", varRefExpression.evaluate(), string, string2, string3);
        return string4;
    }

    private String createEmptyReturnClause() {
        StringBuilder stringBuilder = new StringBuilder().append(this.createResultSortedDefn(new FunctionExpression("true", new Expression[0]))).append("\n").append("let $").append(this.qualifiedVarName(RET_ITEMS)).append(" := ()\n");
        return stringBuilder.toString();
    }
}

