/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.core.model.optional;
import com.vmware.vise.search.ComparisonOperator;
import com.vmware.vise.search.TypeRef;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.util.Translator;
import com.vmware.vise.search.xquery.ComparisonExpression;
import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.FunctionExpression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.LogicalExpression;
import com.vmware.vise.search.xquery.PrimaryExpression;
import com.vmware.vise.search.xquery.StringLiteralExpression;
import com.vmware.vise.search.xquery.xhive.fts.Translators;
import com.vmware.vise.vim.commons.MixedUtil;
import java.util.Locale;
import java.util.regex.Pattern;

final class RendererUtils {
    private static final char QUOTE = '\"';
    private static final String NULL = "null";
    private static final String EXACT_MATCH_PATTERN = "^\"[^\"]+\"$";

    RendererUtils() {
    }

    public static String toPropertyPredicate(PropertyRenderInfo propertyRenderInfo, ComparisonOperator comparisonOperator, ValueRenderInfo[] valueRenderInfoArray) {
        String string = null;
        switch (comparisonOperator) {
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER: 
            case GREATER_OR_EQUALS: 
            case SMALLER: 
            case SMALLER_OR_EQUALS: {
                string = RendererUtils.getComparisonPredicate(propertyRenderInfo, comparisonOperator, valueRenderInfoArray);
                break;
            }
            case STARTS_WITH: {
                string = RendererUtils.getTextFunctionPredicate("fn:starts-with", propertyRenderInfo, valueRenderInfoArray);
                break;
            }
            case ENDS_WITH: {
                string = RendererUtils.getTextFunctionPredicate("fn:ends-with", propertyRenderInfo, valueRenderInfoArray);
                break;
            }
            case CONTAINS: 
            case TEXTUALLY_MATCHES: {
                string = RendererUtils.getContainsPredicate(propertyRenderInfo, valueRenderInfoArray);
                break;
            }
        }
        return string;
    }

    private static Expression toFtsValueExpression(ValueRenderInfo[] valueRenderInfoArray) {
        if (valueRenderInfoArray.length == 0) {
            return new StringLiteralExpression(String.valueOf('*'));
        }
        Expression[] expressionArray = new Expression[valueRenderInfoArray.length];
        int n = 0;
        for (ValueRenderInfo valueRenderInfo : valueRenderInfoArray) {
            String string = RendererUtils.toFtsQueryText(valueRenderInfo.comparativeValue.toString(), valueRenderInfo.propertyRenderInfo);
            LiteralExpression literalExpression = new LiteralExpression(string);
            expressionArray[n++] = literalExpression;
        }
        return new StringLiteralExpression(new LogicalExpression(LogicalExpression.Operator.OR, expressionArray));
    }

    private static Expression toTextFunctionValueExpression(ValueRenderInfo[] valueRenderInfoArray) {
        if (valueRenderInfoArray.length == 0) {
            return new StringLiteralExpression("");
        }
        Expression[] expressionArray = new Expression[valueRenderInfoArray.length];
        int n = 0;
        for (ValueRenderInfo valueRenderInfo : valueRenderInfoArray) {
            String string = RendererUtils.prepareForTextComparison(valueRenderInfo.comparativeValue.toString(), valueRenderInfo.propertyRenderInfo);
            LiteralExpression literalExpression = new LiteralExpression(string);
            expressionArray[n++] = literalExpression;
        }
        return new StringLiteralExpression(new LogicalExpression(LogicalExpression.Operator.OR, expressionArray));
    }

    static boolean isLookingForExactMatch(String string) {
        return Pattern.matches(EXACT_MATCH_PATTERN, string);
    }

    private static String getContainsPredicate(PropertyRenderInfo propertyRenderInfo, ValueRenderInfo[] valueRenderInfoArray) {
        Expression expression = RendererUtils.toFtsValueExpression(valueRenderInfoArray);
        LiteralExpression literalExpression = new LiteralExpression(propertyRenderInfo.propertyExpression);
        FunctionExpression functionExpression = new FunctionExpression("xhive:fts", literalExpression, expression);
        return functionExpression.evaluate();
    }

    private static String getTextFunctionPredicate(String string, PropertyRenderInfo propertyRenderInfo, ValueRenderInfo[] valueRenderInfoArray) {
        Expression expression = RendererUtils.toTextFunctionValueExpression(valueRenderInfoArray);
        LiteralExpression literalExpression = new LiteralExpression(propertyRenderInfo.propertyExpression);
        FunctionExpression functionExpression = new FunctionExpression(string, literalExpression, expression);
        return functionExpression.evaluate();
    }

    private static String getComparisonPredicate(PropertyRenderInfo propertyRenderInfo, ComparisonOperator comparisonOperator, ValueRenderInfo[] valueRenderInfoArray) {
        Expression[] expressionArray = new Expression[valueRenderInfoArray.length];
        int n = 0;
        for (ValueRenderInfo valueRenderInfo : valueRenderInfoArray) {
            String string = valueRenderInfo.comparativeValue.toString();
            if (Strings.isNullOrEmpty(propertyRenderInfo.propertyExpression) || Strings.isNullOrEmpty(string)) {
                throw new IllegalArgumentException("Could not define property expression.");
            }
            TypeRef typeRef = propertyRenderInfo.propertyType;
            if (typeRef == null) {
                typeRef = TypeRefUtils.ROOT_TYPEREF;
            }
            string = RendererUtils.prepareForTextComparison(string, propertyRenderInfo);
            boolean bl = false;
            if (TypeRefUtils.isTextType(typeRef)) {
                bl = RendererUtils.isLookingForExactMatch(string);
                if (bl) {
                    string = Strings.trim(string, '\"');
                }
                string = string.toLowerCase(Locale.getDefault());
            }
            Expression expression = RendererUtils.toComparativeValue(propertyRenderInfo.propertyType, string, valueRenderInfo.comparativeValue);
            PrimaryExpression primaryExpression = new LiteralExpression(propertyRenderInfo.propertyExpression);
            boolean bl2 = string.toLowerCase(Locale.getDefault()).equals(NULL);
            ComparisonExpression.Operator operator = RendererUtils.toComparisonOperator(comparisonOperator);
            Expression expression2 = null;
            if (TypeRefUtils.isTextType(typeRef) && !bl && !bl2 && !propertyRenderInfo.caseSensitive) {
                FunctionExpression functionExpression = new FunctionExpression("exists", primaryExpression);
                primaryExpression = new FunctionExpression("lower-case", primaryExpression);
                ComparisonExpression comparisonExpression = new ComparisonExpression(primaryExpression, operator, expression);
                expression2 = comparisonOperator == ComparisonOperator.EQUALS && !string.isEmpty() ? new ComparisonExpression(primaryExpression, operator, expression) : new LogicalExpression(LogicalExpression.Operator.AND, comparisonExpression, functionExpression);
            } else {
                expression2 = new ComparisonExpression(primaryExpression, operator, expression);
            }
            switch (comparisonOperator) {
                case EQUALS: {
                    if (propertyRenderInfo.isComputed && TypeRefUtils.isBooleanType(typeRef) && string.toString().toLowerCase(Locale.getDefault()).equals(Boolean.TRUE.toString())) {
                        expression2 = primaryExpression;
                        break;
                    }
                    if (bl || !bl2) break;
                    expression2 = new FunctionExpression("not", primaryExpression);
                    break;
                }
            }
            expressionArray[n++] = expression2;
        }
        LogicalExpression logicalExpression = new LogicalExpression(LogicalExpression.Operator.OR, expressionArray);
        return logicalExpression.evaluate();
    }

    private static ComparisonExpression.Operator toComparisonOperator(ComparisonOperator comparisonOperator) {
        switch (comparisonOperator) {
            case EQUALS: {
                return ComparisonExpression.Operator.EQUALS;
            }
            case GREATER: {
                return ComparisonExpression.Operator.GREATER_THAN;
            }
            case GREATER_OR_EQUALS: {
                return ComparisonExpression.Operator.GREATER_OR_EQUALS;
            }
            case SMALLER: {
                return ComparisonExpression.Operator.LESS_THAN;
            }
            case SMALLER_OR_EQUALS: {
                return ComparisonExpression.Operator.LESS_OR_EQUALS;
            }
            case NOT_EQUALS: {
                return ComparisonExpression.Operator.NOT_EQUALS;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Expression toComparativeValue(TypeRef typeRef, String string, Object object) {
        String string2 = string.toLowerCase();
        if (string2.equals(Boolean.TRUE.toString())) {
            return new FunctionExpression("true", new Expression[0]);
        }
        if (string2.equals(Boolean.FALSE.toString())) {
            return new FunctionExpression("false", new Expression[0]);
        }
        LiteralExpression literalExpression = new StringLiteralExpression(string);
        if (TypeRefUtils.isNumericType(typeRef) || object instanceof Number) {
            literalExpression = new LiteralExpression(string);
        }
        return literalExpression;
    }

    private static String toFtsQueryText(String string, PropertyRenderInfo propertyRenderInfo) {
        String string2 = RendererUtils.prepareForTextComparison(string, propertyRenderInfo);
        Translator translator = Translators.newXhiveFtsTranslator();
        String string3 = translator.translate(string2);
        return string3;
    }

    static String prepareForTextComparison(String string, PropertyRenderInfo propertyRenderInfo) {
        String string2 = string.trim();
        TypeRef typeRef = propertyRenderInfo.providerType;
        if (RendererUtils.isManagedEntity(typeRef) && "name".equals(propertyRenderInfo.propertyName)) {
            string2 = MixedUtil.escapeVimEntityNameSpecialChars((String)string2);
        }
        string2 = string2.replaceAll("'", "''");
        string2 = string2.replaceAll("&", "&amp;");
        return string2;
    }

    private static boolean isManagedEntity(TypeRef typeRef) {
        if (typeRef == null) {
            return true;
        }
        boolean bl = typeRef.isInstanceOf("ManagedEntity");
        return bl;
    }

    static final class ValueRenderInfo {
        public Object comparativeValue;
        public PropertyRenderInfo propertyRenderInfo;

        public ValueRenderInfo() {
        }

        public ValueRenderInfo(PropertyRenderInfo propertyRenderInfo, Object object) {
            this.propertyRenderInfo = propertyRenderInfo;
            this.comparativeValue = object;
        }

        public static ValueRenderInfo[] fromComparativeValues(PropertyRenderInfo propertyRenderInfo, Object[] objectArray) {
            ValueRenderInfo[] valueRenderInfoArray = new ValueRenderInfo[objectArray.length];
            int n = 0;
            for (Object object : objectArray) {
                ValueRenderInfo valueRenderInfo = new ValueRenderInfo();
                valueRenderInfo.propertyRenderInfo = propertyRenderInfo;
                valueRenderInfo.comparativeValue = object;
                valueRenderInfoArray[n++] = valueRenderInfo;
            }
            return valueRenderInfoArray;
        }
    }

    static final class PropertyRenderInfo {
        String propertyExpression;
        TypeRef providerType;
        String propertyName;
        TypeRef propertyType;
        boolean isComputed;
        @optional
        boolean caseSensitive;

        PropertyRenderInfo(String string, TypeRef typeRef, String string2, TypeRef typeRef2, boolean bl) {
            this.propertyExpression = string;
            this.providerType = typeRef;
            this.propertyName = string2;
            this.propertyType = typeRef2;
            this.isComputed = bl;
        }
    }
}

