/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.SimplePropertyConstraint;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.render.ConstraintRenderer;
import com.vmware.vise.search.xquery.render.RendererUtils;

final class XQueryDefaultPropertyConstraintRenderer
implements ConstraintRenderer {
    private SimplePropertyConstraint _propConstr;

    XQueryDefaultPropertyConstraintRenderer() {
    }

    @Override
    public String render() {
        if (this._propConstr == null) {
            throw new IllegalArgumentException("Constraint has to be set.");
        }
        String string = this._propConstr.getProperty();
        RendererUtils.PropertyRenderInfo propertyRenderInfo = new RendererUtils.PropertyRenderInfo(string, null, string, TypeRefUtils.STRING_TYPEREF, false);
        RendererUtils.ValueRenderInfo[] valueRenderInfoArray = RendererUtils.ValueRenderInfo.fromComparativeValues(propertyRenderInfo, this._propConstr.getComparativeValues());
        String string2 = RendererUtils.toPropertyPredicate(propertyRenderInfo, this._propConstr.getComparisonOperator(), valueRenderInfoArray);
        return string2;
    }

    @Override
    public Constraint getConstraint() {
        return this._propConstr;
    }

    @Override
    public void setConstraint(Constraint constraint) {
        if (!(constraint instanceof SimplePropertyConstraint)) {
            throw new IllegalArgumentException("Parameter 'constraint' has to be of type: 'SimplePropertyConstraint'");
        }
        this._propConstr = (SimplePropertyConstraint)constraint;
        XQueryDefaultPropertyConstraintRenderer.verifyConstraint(this._propConstr);
    }

    private static void verifyConstraint(SimplePropertyConstraint simplePropertyConstraint) {
        if (simplePropertyConstraint == null) {
            throw new IllegalArgumentException("SimplePropertyConstraint has to be set.");
        }
        String string = simplePropertyConstraint.getProperty();
        if (Strings.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("Property name must be defined.");
        }
        String string2 = simplePropertyConstraint.getSearchTarget();
        if (string2 == null) {
            throw new IllegalArgumentException("SearchTarget must be defined.");
        }
        Object[] objectArray = simplePropertyConstraint.getComparativeValues();
        if (objectArray.length <= 0) {
            throw new IllegalArgumentException("ComparativeValues must be defined.");
        }
    }
}

