/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.search.ComparisonOperator;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.QueryContextType;
import com.vmware.vise.search.SimplePropertyConstraint;
import com.vmware.vise.search.TypeRef;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.PropertyDescriptorDirectory;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.render.ConstraintRenderer;
import com.vmware.vise.search.xquery.render.RendererUtils;
import com.vmware.vise.util.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XQueryPropertyConstraintRenderer
implements ConstraintRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(XQueryPropertyConstraintRenderer.class);
    private static final String CASE_SENSITIVE = "caseSensitive";
    private final TypeRefDirectory _typeRefDirectory;
    private final PropertyDescriptorDirectory _propertyDirectory;
    private SimplePropertyConstraint _propConstr;

    XQueryPropertyConstraintRenderer(TypeRefDirectory typeRefDirectory, PropertyDescriptorDirectory propertyDescriptorDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeRefDirectory, propertyDescriptorDirectory});
        this._typeRefDirectory = typeRefDirectory;
        this._propertyDirectory = propertyDescriptorDirectory;
    }

    @Override
    public String render() {
        if (this._propConstr == null) {
            throw new IllegalArgumentException("Constraint has to be set.");
        }
        PropertyDescriptor propertyDescriptor = this._propertyDirectory.getPropertyDescriptor(this._propConstr.getProperty(), this._propConstr.getSearchTarget());
        Object[] objectArray = this._propConstr.getComparativeValues();
        ComparisonOperator comparisonOperator = this._propConstr.getComparisonOperator();
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("ComparativeValues must be set.");
        }
        TypeRef typeRef = this._typeRefDirectory.getTypeRef(propertyDescriptor.getProvider());
        TypeRef typeRef2 = this._typeRefDirectory.getTypeRef(propertyDescriptor.getType());
        String string = MetadataUtil.getQueryExpression(propertyDescriptor, QueryContextType.CONTEXT_CURRENT);
        if (string == null) {
            LOG.error(this._propConstr.getSearchTarget() + "/" + this._propConstr.getProperty() + "is an xquery defined property and it is used as constraint, but doesn't have an expression with attribute context='current'.");
        }
        RendererUtils.PropertyRenderInfo propertyRenderInfo = new RendererUtils.PropertyRenderInfo(string, typeRef, propertyDescriptor.getName(), typeRef2, propertyDescriptor.isComputed());
        String string2 = propertyDescriptor.getTags().get(CASE_SENSITIVE);
        propertyRenderInfo.caseSensitive = string2 != null ? Boolean.parseBoolean(string2) : false;
        return RendererUtils.toPropertyPredicate(propertyRenderInfo, comparisonOperator, RendererUtils.ValueRenderInfo.fromComparativeValues(propertyRenderInfo, objectArray));
    }

    @Override
    public Constraint getConstraint() {
        return this._propConstr;
    }

    @Override
    public void setConstraint(Constraint constraint) {
        if (!(constraint instanceof SimplePropertyConstraint)) {
            throw new IllegalArgumentException("Parameter 'constraint' has to be of type: 'SimplePropertyConstraint'");
        }
        this._propConstr = (SimplePropertyConstraint)constraint;
        XQueryPropertyConstraintRenderer.verifyConstraint(this._propConstr);
    }

    private static void verifyConstraint(SimplePropertyConstraint simplePropertyConstraint) {
        if (simplePropertyConstraint == null) {
            throw new IllegalArgumentException("SimplePropertyConstraint has to be set.");
        }
        String string = simplePropertyConstraint.getProperty();
        if (Strings.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("Property name must be defined.");
        }
        String string2 = simplePropertyConstraint.getSearchTarget();
        if (string2 == null) {
            throw new IllegalArgumentException("SearchTarget must be defined.");
        }
        Object[] objectArray = simplePropertyConstraint.getComparativeValues();
        if (objectArray.length <= 0) {
            throw new IllegalArgumentException("ComparativeValues must be defined.");
        }
    }
}

