/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.xhive.fts;

import com.vmware.vise.search.util.StateMachine;
import com.vmware.vise.search.util.Token;
import com.vmware.vise.search.util.TokenType;
import com.vmware.vise.search.xquery.xhive.fts.BaseState;
import com.vmware.vise.search.xquery.xhive.fts.RegularXhiveFtsTokenImpl;

final class RegularStateImpl
extends BaseState {
    private static final String XHIVE_FTS_ESCAPE_QUOTE = "[\"]";
    private static final String XHIVE_FTS_ESCAPE_REPLACEMENT_PATTERN = "\\\\$0";
    private final StringBuilder _text = new StringBuilder();

    public RegularStateImpl(StateMachine stateMachine) {
        super(stateMachine);
    }

    @Override
    public Token getToken() {
        String string = RegularStateImpl.xhiveFtsEscapeQuotes(this._text.toString().trim());
        return new RegularXhiveFtsTokenImpl(string);
    }

    @Override
    public void readSymbol(String string, int n) {
        char c = string.charAt(n);
        boolean bl = RegularStateImpl.containsQuoteAfter(string, n);
        StateMachine stateMachine = this.getStateMachine();
        if (c == '\"' && bl) {
            stateMachine.transitionTo(stateMachine.getStates().get((Object)TokenType.Quoted));
        } else if (Character.isWhitespace(c)) {
            stateMachine.transitionTo(this);
        } else {
            this._text.append(c);
        }
    }

    @Override
    public void enter() {
        this._text.setLength(0);
        super.enter();
    }

    private static String xhiveFtsEscapeQuotes(String string) {
        return string.replaceAll(XHIVE_FTS_ESCAPE_QUOTE, XHIVE_FTS_ESCAPE_REPLACEMENT_PATTERN);
    }
}

