/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionMenuItem;
import com.vmware.vise.actionsfw.ActionMenusRequestSpec;
import com.vmware.vise.actionsfw.ActionToolbarRequestSpec;
import com.vmware.vise.actionsfw.ActionsRequestSpec;
import com.vmware.vise.actionsfw.ActionsService;
import com.vmware.vise.actionsfw.RequestPolicy;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.actions.model.EvaluatedMenus;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/actionsService"})
public class ActionsServiceController {
    private static final Log _logger = LogFactory.getLog(ActionsServiceController.class);
    private final ActionsService _actionsService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public ActionsServiceController(ActionsService actionsService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._actionsService = actionsService;
        this._objectReferenceService = objectReferenceService;
    }

    @RequestMapping(value={"/toolbar"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionMenuItem> getToolbarActions(@RequestParam(value="listViewId", required=true) String string, @RequestParam(value="targetUids", required=false) String[] stringArray) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /actionsService/toolbar for ", string}));
        }
        ActionToolbarRequestSpec actionToolbarRequestSpec = new ActionToolbarRequestSpec();
        actionToolbarRequestSpec.listViewId = string;
        ActionContext actionContext = new ActionContext();
        List<Object> list = this.getObjectRefsForTargets(stringArray);
        actionContext.setTargetObjects(list);
        actionToolbarRequestSpec.context = actionContext;
        List list2 = this._actionsService.getToolbarActions(actionToolbarRequestSpec);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /actionsService/toolbar for ", string}));
        }
        return list2;
    }

    @RequestMapping(value={"/menu"}, method={RequestMethod.POST})
    @ResponseBody
    public ActionMenuItem getOrBuildMenu(@RequestParam(value="menuType", required=true) String string, @RequestBody(required=false) String[] stringArray) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /actionsService/menu for ", string}));
        }
        ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
        actionMenusRequestSpec.menuTypes = ArrayUtil.toArrayList((Object[])StringUtil.splitAndTrim((String)string, (String)","));
        ActionContext actionContext = new ActionContext();
        List<Object> list = this.getObjectRefsForTargets(stringArray);
        actionContext.setTargetObjects(list);
        actionMenusRequestSpec.context = actionContext;
        ActionMenuItem actionMenuItem = this._actionsService.getOrBuildMenu(actionMenusRequestSpec);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /actionsService/menu for ", string}));
        }
        return actionMenuItem;
    }

    @RequestMapping(value={"/actions/descriptions/{actionUid:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public Action getAction(@PathVariable(value="actionUid") String string) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /actionsService/actions/descriptions/", string}));
        }
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("Action identifer must not be null or empty.");
        }
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.actionUids = ArrayUtil.toArrayList((Object[])new String[]{string});
        List list = this._actionsService.getActions(actionsRequestSpec, false);
        if (list.size() == 0) {
            throw new IllegalArgumentException("No Action registered with ID " + string + ".");
        }
        assert (list.size() == 1) : "Received more than one action with ID " + string + ".";
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /actionsService/actions/descriptions/", string}));
        }
        return (Action)list.get(0);
    }

    @RequestMapping(value={"/actions/descriptions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Action> getActions(@RequestParam(value="actionUids", required=false) String[] stringArray, @RequestParam(value="targetTypes", required=false) String string, @RequestParam(value="globalActions", required=false) String string2) {
        _logger.debug((Object)"GET /actionsService/actions/descriptions");
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.actionUids = ArrayUtil.toArrayList((Object[])stringArray);
        actionsRequestSpec.targetTypes = ArrayUtil.toArrayList((Object[])StringUtil.splitAndTrim((String)string, (String)","));
        if (!StringUtil.isNullOrWhitespace((String)string2)) {
            actionsRequestSpec.globalActions = RequestPolicy.valueOf((String)string2.toUpperCase());
        }
        List list = this._actionsService.getActions(actionsRequestSpec, false);
        _logger.trace((Object)"Finish execution of GET /actionsService/actions/descriptions");
        return list;
    }

    @RequestMapping(value={"/actions/evaluations/{actionUid:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ActionEvaluation getActionEvaluation(@PathVariable(value="actionUid") String string, @RequestParam(value="targetUids", required=false) String[] stringArray) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /actionsService/actions/evaluations/", string}));
        }
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("Action identifer must not be null or empty.");
        }
        ActionContext actionContext = new ActionContext();
        actionContext.setTargetObjects(this.getObjectRefsForTargets(stringArray));
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.context = actionContext;
        actionsRequestSpec.actionUids = ArrayUtil.toArrayList((Object[])new String[]{string});
        List list = this._actionsService.getEvaluatedActions(actionsRequestSpec, false);
        if (list.size() == 0) {
            throw new IllegalArgumentException("No Action registered with ID " + string + ".");
        }
        assert (list.size() == 1) : "Found more than one action with ID " + string + ".";
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /actionsService/actions/evaluations/", string}));
        }
        return (ActionEvaluation)list.get(0);
    }

    @RequestMapping(value={"/actions/evaluations"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ActionEvaluation> getActionEvaluations(@RequestParam(value="actionUids", required=false) String[] stringArray, @RequestParam(value="globalActions", required=false) String string, @RequestParam(value="skipActionFilteringStage", required=false, defaultValue="false") boolean bl, @RequestBody(required=false) String[] stringArray2) throws Exception {
        _logger.debug((Object)"POST /actionsService/actions/evaluations");
        ActionContext actionContext = new ActionContext();
        List<Object> list = this.getObjectRefsForTargets(stringArray2);
        actionContext.setTargetObjects(list);
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.context = actionContext;
        if (!ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            actionsRequestSpec.actionUids = ArrayUtil.toArrayList((Object[])stringArray);
        }
        if (!StringUtil.isNullOrEmpty((String)string)) {
            actionsRequestSpec.globalActions = RequestPolicy.valueOf((String)string.toUpperCase());
        }
        List<ActionEvaluation> list2 = Collections.emptyList();
        try {
            return this._actionsService.getEvaluatedActions(actionsRequestSpec, bl);
        }
        catch (ManagedObjectNotFound managedObjectNotFound) {
            _logger.debug((Object)"Unable to find object", (Throwable)managedObjectNotFound);
            _logger.trace((Object)"Finish execution of POST /actionsService/actions/evaluations");
            return list2;
        }
    }

    @RequestMapping(value={"/menus"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionMenuItem> getMenus() {
        _logger.debug((Object)"GET /actionsService/menus");
        ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
        List list = this._actionsService.getMenus(actionMenusRequestSpec);
        _logger.trace((Object)"Finish execution of GET /actionsService/menus");
        return list;
    }

    @RequestMapping(value={"/menus/{menuType:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionMenuItem> getMenus(@PathVariable(value="menuType") String string, @RequestParam(value="targetUids", required=false) String[] stringArray) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /actionsService/menus/", string}));
        }
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("Menu type must not be null or empty.");
        }
        ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
        actionMenusRequestSpec.menuTypes = ArrayUtil.toArrayList((Object[])StringUtil.splitAndTrim((String)string, (String)","));
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            return this._actionsService.getMenus(actionMenusRequestSpec);
        }
        List<ActionMenuItem> list = this.getApplicableMenus(stringArray, actionMenusRequestSpec);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /actionsService/menus/", string}));
        }
        return list;
    }

    @RequestMapping(value={"/menus/{menuIds:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public EvaluatedMenus getEvaluatedMenus(@PathVariable(value="menuIds") String string, @RequestBody(required=false) String[] stringArray) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /actionsService/menus/", string, stringArray}));
        }
        ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
        actionMenusRequestSpec.menuIds = ArrayUtil.toArrayList((Object[])StringUtil.splitAndTrim((String)string, (String)","));
        List<ActionMenuItem> list = ArrayUtil.isNullOrEmpty((Object[])stringArray) ? this._actionsService.getMenus(actionMenusRequestSpec) : this.getApplicableMenus(stringArray, actionMenusRequestSpec);
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.actionUids = new ArrayList();
        actionsRequestSpec.context = actionMenusRequestSpec.context;
        for (ActionMenuItem actionMenuItem : list) {
            actionsRequestSpec.actionUids.addAll(this.extractActionIds(actionMenuItem));
        }
        Object object = null;
        if (stringArray == null || stringArray.length == 1) {
            object = this._actionsService.getEvaluatedActions(actionsRequestSpec, true);
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /actionsService/menus/", string, stringArray}));
        }
        return new EvaluatedMenus(list, (List<ActionEvaluation>)object);
    }

    @RequestMapping(value={"/menus/{menuType:.*}/{menuUid:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ActionMenuItem getMenu(@PathVariable(value="menuType") String string, @PathVariable(value="menuUid") String string2, @RequestParam(value="targetUids", required=false) String[] stringArray) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /actionsService/menus/", string, string2}));
        }
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("Menu type must not be null or empty.");
        }
        if (StringUtil.isNullOrWhitespace((String)string2)) {
            throw new IllegalArgumentException("Menu uid must not be null or empty.");
        }
        ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
        actionMenusRequestSpec.menuTypes = ArrayUtil.toArrayList((Object[])new String[]{string});
        actionMenusRequestSpec.menuIds = ArrayUtil.toArrayList((Object[])new String[]{string2});
        List<ActionMenuItem> list = ArrayUtil.isNullOrEmpty((Object[])stringArray) ? this._actionsService.getMenus(actionMenusRequestSpec) : this.getApplicableMenus(stringArray, actionMenusRequestSpec);
        if (list.size() > 1) {
            _logger.warn((Object)("More than one menu registered with uid " + string2));
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /actionsService/menus/", string, string2}));
        }
        return list.get(0);
    }

    private List<ActionMenuItem> getApplicableMenus(String[] stringArray, ActionMenusRequestSpec actionMenusRequestSpec) {
        ActionContext actionContext = new ActionContext();
        List<Object> list = this.getObjectRefsForTargets(stringArray);
        actionContext.setTargetObjects(list);
        actionMenusRequestSpec.context = actionContext;
        return this._actionsService.getMenus(actionMenusRequestSpec);
    }

    private List<Object> getObjectRefsForTargets(String[] stringArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (String string : stringArray) {
            Object object = this._objectReferenceService.getReference(string, true);
            if (object == null) {
                _logger.warn((Object)("Object " + string + " could not be found."));
                continue;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private Collection<String> extractActionIds(ActionMenuItem actionMenuItem) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(actionMenuItem.getId());
        if (actionMenuItem.getChildren() != null) {
            for (ActionMenuItem actionMenuItem2 : actionMenuItem.getChildren()) {
                arrayList.addAll(this.extractActionIds(actionMenuItem2));
            }
        }
        return arrayList;
    }
}

