/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AlarmsController {
    private static final Log _logger = LogFactory.getLog(AlarmsController.class);
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private static final String ALARM_ISSUE_TYPE = "AlarmIssue";
    private static final String INFO_PROPERTY = "info";
    private static final String ALARM_ENTITY_PROPERTY = "info.entity";
    private final QuerySpecBuilder _querySpecBuilder;
    private final QueryExecutor _queryExecutor;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public AlarmsController(QuerySpecBuilder querySpecBuilder, QueryExecutor queryExecutor, ObjectReferenceService objectReferenceService) {
        this._querySpecBuilder = querySpecBuilder;
        this._queryExecutor = queryExecutor;
        this._objectReferenceService = objectReferenceService;
    }

    @RequestMapping(value={"/entityAlarms"})
    @ResponseBody
    public final List<IssueInfo> getTriggerredAlarms(@RequestParam(value="objectId") String string, @RequestParam(value="count", defaultValue="-1") int n) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /entityAlarms for ", string, " count=", n}));
        }
        Object object = null;
        PropertyConstraint propertyConstraint = null;
        if (string != null) {
            object = this._objectReferenceService.getReference(string, true);
            propertyConstraint = QueryUtil.createPropertyConstraint((String)ALARM_ISSUE_TYPE, (String)ALARM_ENTITY_PROPERTY, (Comparator)Comparator.EQUALS, (Object)object);
        }
        String[] stringArray = new String[]{INFO_PROPERTY};
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)propertyConstraint, stringArray, Collections.singleton(ALARM_ISSUE_TYPE));
        querySpec.name = this._opId;
        propertyConstraint.targetType = ALARM_ISSUE_TYPE;
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = n;
        querySpec.resultSpec = resultSpec;
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        List<IssueInfo> list = this.formatResults(resultSet);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /entityAlarms for ", string, " count=", n}));
        }
        return list;
    }

    @RequestMapping(value={"/alarms"})
    @ResponseBody
    public final List<IssueInfo> getAlarms(@RequestParam(value="count", defaultValue="150") int n) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /alarms count=", n}));
        }
        Constraint constraint = new Constraint();
        constraint.targetType = ALARM_ISSUE_TYPE;
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = n;
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(constraint, new String[]{INFO_PROPERTY});
        querySpec.resultSpec = resultSpec;
        querySpec.name = this._opId;
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /alarms count=", n}));
        }
        return this.formatResults(resultSet);
    }

    private List<IssueInfo> formatResults(ResultSet resultSet) {
        ArrayList<IssueInfo> arrayList = new ArrayList<IssueInfo>();
        for (ResultItem resultItem : resultSet.items) {
            for (PropertyValue propertyValue : resultItem.properties) {
                IssueInfo issueInfo = (IssueInfo)propertyValue.value;
                arrayList.add(issueInfo);
            }
        }
        return arrayList;
    }
}

